(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8406,        295]
NotebookOptionsPosition[      4661,        182]
NotebookOutlinePosition[      7072,        250]
CellTagsIndexPosition[      6922,        243]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
FindMinimum::fmgz
FindFit::fmgz\
\>", "ObjectName",
 CellID->17453],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"fmgz\"\>"}], ":", 
  " ", "\<\"Encountered a gradient that is effectively zero. The result \
returned may not be a minimum; it may be a maximum or a saddle \
point.\"\>"}]], "Message", "MSG",
 CellID->606149371],

Cell["\<\
Generated when the gradient of the objective function is zero to within \
numerical error at a point that is checked by the algorithm.\
\>", "Notes",
 CellID->25245],

Cell["\<\
If the function has a minimum, this error can often be corrected by choosing \
different starting values, or by giving two starting values for each \
variable.\
\>", "Notes",
 CellID->13489]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->818920226],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->596334130],

Cell["\<\
An error occurs in this example because the starting point corresponds to a \
saddle point.\
\>", "ExampleText",
 CellID->27447955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{"y", "^", "2"}], "+", 
    RowBox[{"y", "^", "4"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellTags->{"FindMinimum::fmgz", "FindFit::fmgz"},
 CellLabel->"In[1]:=",
 CellID->2896],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindMinimum", "::", "\<\"fmgz\"\>"}], ":", 
  " ", "\<\"Encountered a gradient that is effectively zero. The result \
returned may not be a minimum; it may be a maximum or a saddle \
point.\"\>"}]], "Message", "MSG",
 CellTags->{"FindMinimum::fmgz", "FindFit::fmgz"},
 CellID->311231110],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.`"}]}], "}"}]}], "}"}]], "Output",
 CellTags->{"FindMinimum::fmgz", "FindFit::fmgz"},
 CellLabel->"Out[1]=",
 CellID->308812292]
}, Open  ]],

Cell["\<\
The minimum is computed without difficulty if different starting values are \
used.\
\>", "ExampleText",
 CellID->23088856],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{"y", "^", "2"}], "+", 
    RowBox[{"y", "^", "4"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->{"FindMinimum::fmgz", "FindFit::fmgz"},
 CellLabel->"In[2]:=",
 CellID->23066],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.75`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.7071067811869883`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellTags->{"FindMinimum::fmgz", "FindFit::fmgz"},
 CellLabel->"Out[2]=",
 CellID->378020642]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FindMinimum::fmgz - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 2, 2.7805400}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "FindMinimum::fmgz FindFit::fmgz", "synonyms" -> {}, "title" -> 
    "FindMinimum::fmgz", "type" -> "Message", "uri" -> "ref/message/fmgz"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1989, 77, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->818920226]},
 "FindMinimum::fmgz"->{
  Cell[2691, 106, 403, 13, 70, "Input",
   CellTags->{"FindMinimum::fmgz", "FindFit::fmgz"},
   CellID->2896],
  Cell[3097, 121, 322, 7, 70, "Message",
   CellTags->{"FindMinimum::fmgz", "FindFit::fmgz"},
   CellID->311231110],
  Cell[3422, 130, 286, 9, 70, "Output",
   CellTags->{"FindMinimum::fmgz", "FindFit::fmgz"},
   CellID->308812292],
  Cell[3881, 150, 404, 13, 70, "Input",
   CellTags->{"FindMinimum::fmgz", "FindFit::fmgz"},
   CellID->23066],
  Cell[4288, 165, 307, 10, 70, "Output",
   CellTags->{"FindMinimum::fmgz", "FindFit::fmgz"},
   CellID->378020642]},
 "FindFit::fmgz"->{
  Cell[2691, 106, 403, 13, 70, "Input",
   CellTags->{"FindMinimum::fmgz", "FindFit::fmgz"},
   CellID->2896],
  Cell[3097, 121, 322, 7, 70, "Message",
   CellTags->{"FindMinimum::fmgz", "FindFit::fmgz"},
   CellID->311231110],
  Cell[3422, 130, 286, 9, 70, "Output",
   CellTags->{"FindMinimum::fmgz", "FindFit::fmgz"},
   CellID->308812292],
  Cell[3881, 150, 404, 13, 70, "Input",
   CellTags->{"FindMinimum::fmgz", "FindFit::fmgz"},
   CellID->23066],
  Cell[4288, 165, 307, 10, 70, "Output",
   CellTags->{"FindMinimum::fmgz", "FindFit::fmgz"},
   CellID->378020642]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5588, 204},
 {"FindMinimum::fmgz", 5731, 208},
 {"FindFit::fmgz", 6325, 224}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 77, 4, 70, "ObjectName",
 CellID->17453],
Cell[CellGroupData[{
Cell[805, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1283, 52, 288, 7, 70, "Message",
 CellID->606149371],
Cell[1574, 61, 175, 4, 70, "Notes",
 CellID->25245],
Cell[1752, 67, 200, 5, 70, "Notes",
 CellID->13489]
}, Closed]],
Cell[CellGroupData[{
Cell[1989, 77, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->818920226],
Cell[CellGroupData[{
Cell[2374, 91, 148, 5, 70, "ExampleSection",
 CellID->596334130],
Cell[2525, 98, 141, 4, 70, "ExampleText",
 CellID->27447955],
Cell[CellGroupData[{
Cell[2691, 106, 403, 13, 70, "Input",
 CellTags->{"FindMinimum::fmgz", "FindFit::fmgz"},
 CellID->2896],
Cell[3097, 121, 322, 7, 70, "Message",
 CellTags->{"FindMinimum::fmgz", "FindFit::fmgz"},
 CellID->311231110],
Cell[3422, 130, 286, 9, 70, "Output",
 CellTags->{"FindMinimum::fmgz", "FindFit::fmgz"},
 CellID->308812292]
}, Open  ]],
Cell[3723, 142, 133, 4, 70, "ExampleText",
 CellID->23088856],
Cell[CellGroupData[{
Cell[3881, 150, 404, 13, 70, "Input",
 CellTags->{"FindMinimum::fmgz", "FindFit::fmgz"},
 CellID->23066],
Cell[4288, 165, 307, 10, 70, "Output",
 CellTags->{"FindMinimum::fmgz", "FindFit::fmgz"},
 CellID->378020642]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4634, 180, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

