(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10083,        322]
NotebookOptionsPosition[      5196,        191]
NotebookOutlinePosition[      8629,        277]
CellTagsIndexPosition[      8441,        269]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
FindMinimum::fmwar
FindMaximum::fmwar
FindFit::fmwar\
\>", "ObjectName",
 CellID->3732],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"fmwar\"\>"}], ":", 
  " ", "\<\"Only the first starting value in each dimension, `1` is used \
unless Method -> PrincipalAxis or Automatic.\"\>"}]], "Message", "MSG",
 CellID->219492433],

Cell[TextData[{
 "Generated when the indicated function is used with ",
 StyleBox["Method\[Rule]\"LevenbergMarquardt\"", "MR"],
 ", ",
 StyleBox["Method\[Rule]\"Newton\"", "MR"],
 ", or ",
 StyleBox["Method\[Rule]\"QuasiNewton\"", "MR"],
 ", and more than one starting value is specified for the variable or  \
variables."
}], "Notes",
 CellID->28127],

Cell[TextData[{
 "Only one starting value is needed for each variable if the value of the ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option is ",
 Cell[BoxData["\"\<LevenbergMarquardt\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Newton\>\""], "InlineFormula"],
 ", or ",
 Cell[BoxData["\"\<QuasiNewton\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->8441]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->163565947],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->56366355],

Cell["\<\
A warning message is generated in this example because only one of the \
specified starting values will be used.\
\>", "ExampleText",
 CellID->24617144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<Newton\>\""}]}], "]"}]], "Input",
 CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"},
 CellLabel->"In[1]:=",
 CellID->25477],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindMinimum", "::", "\<\"fmwar\"\>"}], ":", 
  " ", "\<\"Only the first starting value in each dimension, \\!\\({3.`}\\) \
is used unless Method -> PrincipalAxis or Automatic. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/FindMinimum/fmwar\\\", ButtonNote -> \
\\\"FindMinimum::fmwar\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"},
 CellID->744073646],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "10.995574287564253`"}], "}"}]}], "}"}]], "Output",\

 CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"},
 CellLabel->"Out[1]=",
 CellID->493945562]
}, Open  ]],

Cell[TextData[{
 "This shows a correct specification of a starting value for ",
 StyleBox["Method->\"Newton\"", "MR"],
 "."
}], "ExampleText",
 CellID->260693727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<Newton\>\""}]}], "]"}]], "Input",
 CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"},
 CellLabel->"In[2]:=",
 CellID->15828],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "10.995574287564253`"}], "}"}]}], "}"}]], "Output",\

 CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"},
 CellLabel->"Out[2]=",
 CellID->270896549]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FindMinimum::fmwar - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 2, 3.1711750}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "FindMinimum::fmwar FindMaximum::fmwar FindFit::fmwar", 
    "synonyms" -> {}, "title" -> "FindMinimum::fmwar", "type" -> "Message", 
    "uri" -> "ref/message/fmwar"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2403, 92, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->163565947]},
 "FindMinimum::fmwar"->{
  Cell[3125, 121, 349, 9, 70, "Input",
   CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"},
   CellID->25477],
  Cell[3477, 132, 532, 9, 70, "Message",
   CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"},
   CellID->744073646],
  Cell[4012, 143, 287, 9, 70, "Output",
   CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"},
   CellID->493945562],
  Cell[4501, 164, 339, 9, 70, "Input",
   CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"},
   CellID->15828],
  Cell[4843, 175, 287, 9, 70, "Output",
   CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"},
   CellID->270896549]},
 "FindMaximum::fmwar"->{
  Cell[3125, 121, 349, 9, 70, "Input",
   CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"},
   CellID->25477],
  Cell[3477, 132, 532, 9, 70, "Message",
   CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"},
   CellID->744073646],
  Cell[4012, 143, 287, 9, 70, "Output",
   CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"},
   CellID->493945562],
  Cell[4501, 164, 339, 9, 70, "Input",
   CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"},
   CellID->15828],
  Cell[4843, 175, 287, 9, 70, "Output",
   CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"},
   CellID->270896549]},
 "FindFit::fmwar"->{
  Cell[3125, 121, 349, 9, 70, "Input",
   CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"},
   CellID->25477],
  Cell[3477, 132, 532, 9, 70, "Message",
   CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"},
   CellID->744073646],
  Cell[4012, 143, 287, 9, 70, "Output",
   CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"},
   CellID->493945562],
  Cell[4501, 164, 339, 9, 70, "Input",
   CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"},
   CellID->15828],
  Cell[4843, 175, 287, 9, 70, "Output",
   CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"},
   CellID->270896549]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6152, 214},
 {"FindMinimum::fmwar", 6296, 218},
 {"FindMaximum::fmwar", 7013, 234},
 {"FindFit::fmwar", 7726, 250}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 97, 5, 70, "ObjectName",
 CellID->3732],
Cell[CellGroupData[{
Cell[825, 36, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1303, 53, 263, 6, 70, "Message",
 CellID->219492433],
Cell[1569, 61, 351, 10, 70, "Notes",
 CellID->28127],
Cell[1923, 73, 443, 14, 70, "Notes",
 CellID->8441]
}, Closed]],
Cell[CellGroupData[{
Cell[2403, 92, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->163565947],
Cell[CellGroupData[{
Cell[2788, 106, 147, 5, 70, "ExampleSection",
 CellID->56366355],
Cell[2938, 113, 162, 4, 70, "ExampleText",
 CellID->24617144],
Cell[CellGroupData[{
Cell[3125, 121, 349, 9, 70, "Input",
 CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"},
 CellID->25477],
Cell[3477, 132, 532, 9, 70, "Message",
 CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"},
 CellID->744073646],
Cell[4012, 143, 287, 9, 70, "Output",
 CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"},
 CellID->493945562]
}, Open  ]],
Cell[4314, 155, 162, 5, 70, "ExampleText",
 CellID->260693727],
Cell[CellGroupData[{
Cell[4501, 164, 339, 9, 70, "Input",
 CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"},
 CellID->15828],
Cell[4843, 175, 287, 9, 70, "Output",
 CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"},
 CellID->270896549]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5169, 189, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

