(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11528,        399]
NotebookOptionsPosition[      5119,        200]
NotebookOutlinePosition[      9937,        344]
CellTagsIndexPosition[      9716,        335]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
FindMinimum::reged
FindMaximum::reged
FindFit::reged
FindRoot::reged\
\>", "ObjectName",
 CellID->29613],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"reged\"\>"}], ":", 
  " ", "\<\"The point `1` is at the edge of the search region `3` in \
coordinate `2` and the computed search direction points outside the region.\"\
\>"}]], "Message", "MSG",
 CellID->185499519],

Cell["\<\
Generated when the indicated function does not find a  solution within the \
specified search region.\
\>", "Notes",
 CellID->19390],

Cell[TextData[{
 "The search  region is specified in the second argument of ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FindMaximum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMaximum"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 ", and in the third argument of ",
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->31357]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->453978896],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->170559299],

Cell["\<\
A warning message is generated in this example because the search reaches a \
point outside the search region.\
\>", "ExampleText",
 CellID->71059501],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "6", ",", "5", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
   "FindRoot::reged"},
 CellLabel->"In[1]:=",
 CellID->22347],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindMinimum", "::", "\<\"reged\"\>"}], ":", 
  " ", "\<\"The point \\!\\({5.`}\\) is at the edge of the search region \
\\!\\({5.`, 7.`}\\) in coordinate \\!\\(1\\) and the computed search \
direction points outside the region.\"\>"}]], "Message", "MSG",
 CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
   "FindRoot::reged"},
 CellID->260704781],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.9589242746631385`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "5.`"}], "}"}]}], "}"}]], "Output",
 CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
   "FindRoot::reged"},
 CellLabel->"Out[1]=",
 CellID->360850371]
}, Open  ]],

Cell["\<\
A minimum is computed without difficulty if the search region is expanded to \
include a minimum.\
\>", "ExampleText",
 CellID->338223852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "6", ",", "4", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
   "FindRoot::reged"},
 CellLabel->"In[2]:=",
 CellID->19401],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "4.712388980281876`"}], "}"}]}], "}"}]], "Output",\

 CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
   "FindRoot::reged"},
 CellLabel->"Out[2]=",
 CellID->523362638]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FindMinimum::reged - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 2, 10.4526114}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "FindMinimum::reged FindMaximum::reged FindFit::reged FindRoot::reged", 
    "synonyms" -> {}, "title" -> "FindMinimum::reged", "type" -> "Message", 
    "uri" -> "ref/message/reged"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2448, 97, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->453978896]},
 "FindMinimum::reged"->{
  Cell[3169, 126, 327, 10, 70, "Input",
   CellTags->{
    "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
     "FindRoot::reged"},
   CellID->22347],
  Cell[3499, 138, 410, 9, 70, "Message",
   CellTags->{
    "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
     "FindRoot::reged"},
   CellID->260704781],
  Cell[3912, 149, 311, 10, 70, "Output",
   CellTags->{
    "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
     "FindRoot::reged"},
   CellID->360850371],
  Cell[4411, 170, 327, 10, 70, "Input",
   CellTags->{
    "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
     "FindRoot::reged"},
   CellID->19401],
  Cell[4741, 182, 312, 11, 70, "Output",
   CellTags->{
    "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
     "FindRoot::reged"},
   CellID->523362638]},
 "FindMaximum::reged"->{
  Cell[3169, 126, 327, 10, 70, "Input",
   CellTags->{
    "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
     "FindRoot::reged"},
   CellID->22347],
  Cell[3499, 138, 410, 9, 70, "Message",
   CellTags->{
    "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
     "FindRoot::reged"},
   CellID->260704781],
  Cell[3912, 149, 311, 10, 70, "Output",
   CellTags->{
    "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
     "FindRoot::reged"},
   CellID->360850371],
  Cell[4411, 170, 327, 10, 70, "Input",
   CellTags->{
    "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
     "FindRoot::reged"},
   CellID->19401],
  Cell[4741, 182, 312, 11, 70, "Output",
   CellTags->{
    "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
     "FindRoot::reged"},
   CellID->523362638]},
 "FindFit::reged"->{
  Cell[3169, 126, 327, 10, 70, "Input",
   CellTags->{
    "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
     "FindRoot::reged"},
   CellID->22347],
  Cell[3499, 138, 410, 9, 70, "Message",
   CellTags->{
    "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
     "FindRoot::reged"},
   CellID->260704781],
  Cell[3912, 149, 311, 10, 70, "Output",
   CellTags->{
    "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
     "FindRoot::reged"},
   CellID->360850371],
  Cell[4411, 170, 327, 10, 70, "Input",
   CellTags->{
    "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
     "FindRoot::reged"},
   CellID->19401],
  Cell[4741, 182, 312, 11, 70, "Output",
   CellTags->{
    "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
     "FindRoot::reged"},
   CellID->523362638]},
 "FindRoot::reged"->{
  Cell[3169, 126, 327, 10, 70, "Input",
   CellTags->{
    "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
     "FindRoot::reged"},
   CellID->22347],
  Cell[3499, 138, 410, 9, 70, "Message",
   CellTags->{
    "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
     "FindRoot::reged"},
   CellID->260704781],
  Cell[3912, 149, 311, 10, 70, "Output",
   CellTags->{
    "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
     "FindRoot::reged"},
   CellID->360850371],
  Cell[4411, 170, 327, 10, 70, "Input",
   CellTags->{
    "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
     "FindRoot::reged"},
   CellID->19401],
  Cell[4741, 182, 312, 11, 70, "Output",
   CellTags->{
    "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
     "FindRoot::reged"},
   CellID->523362638]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6097, 224},
 {"FindMinimum::reged", 6241, 228},
 {"FindMaximum::reged", 7112, 254},
 {"FindFit::reged", 7979, 280},
 {"FindRoot::reged", 8847, 306}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 114, 6, 70, "ObjectName",
 CellID->29613],
Cell[CellGroupData[{
Cell[842, 37, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1320, 54, 292, 7, 70, "Message",
 CellID->185499519],
Cell[1615, 63, 142, 4, 70, "Notes",
 CellID->19390],
Cell[1760, 69, 651, 23, 70, "Notes",
 CellID->31357]
}, Closed]],
Cell[CellGroupData[{
Cell[2448, 97, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->453978896],
Cell[CellGroupData[{
Cell[2833, 111, 148, 5, 70, "ExampleSection",
 CellID->170559299],
Cell[2984, 118, 160, 4, 70, "ExampleText",
 CellID->71059501],
Cell[CellGroupData[{
Cell[3169, 126, 327, 10, 70, "Input",
 CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
   "FindRoot::reged"},
 CellID->22347],
Cell[3499, 138, 410, 9, 70, "Message",
 CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
   "FindRoot::reged"},
 CellID->260704781],
Cell[3912, 149, 311, 10, 70, "Output",
 CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
   "FindRoot::reged"},
 CellID->360850371]
}, Open  ]],
Cell[4238, 162, 148, 4, 70, "ExampleText",
 CellID->338223852],
Cell[CellGroupData[{
Cell[4411, 170, 327, 10, 70, "Input",
 CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
   "FindRoot::reged"},
 CellID->19401],
Cell[4741, 182, 312, 11, 70, "Output",
 CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
   "FindRoot::reged"},
 CellID->523362638]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5092, 198, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

