(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8620,        317]
NotebookOptionsPosition[      5345,        207]
NotebookOutlinePosition[      7185,        264]
CellTagsIndexPosition[      7068,        258]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["FindRoot::lstol", "ObjectName",
 CellID->18863],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"lstol\"\>"}], ":", 
  " ", "\<\"The line search decreased the step size to within tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the merit function.  You may need more than `1` digits \
of working precision to meet these tolerances.\"\>"}]], "Message", "MSG",
 CellID->603784960],

Cell[TextData[{
 "Generated when the algorithm used by ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " does not find a root within the indicated number of iterations. "
}], "Notes",
 CellID->7507],

Cell[TextData[{
 "If a root exists, this error can often be corrected by  giving better \
starting values, or by changing the values of the ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["MaxIterations",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxIterations"]], "InlineFormula"],
 " options."
}], "Notes",
 CellID->11465]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->355731796],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->251779417],

Cell["\<\
An error occurs in this example because the objective function does not have \
a real root.\
\>", "ExampleText",
 CellID->273031067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "x", "+", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellTags->"FindRoot::lstol",
 CellLabel->"In[1]:=",
 CellID->26991],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"lstol\"\>"}], ":", 
  " ", "\<\"The line search decreased the step size to within tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the merit function.  You may need more than \
\\!\\(MachinePrecision\\) digits of working precision to meet these \
tolerances.\"\>"}]], "Message", "MSG",
 CellTags->"FindRoot::lstol",
 CellID->489231768],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"-", "0.4999975458148378`"}]}], "}"}]], "Output",
 CellTags->"FindRoot::lstol",
 CellLabel->"Out[1]=",
 CellID->94865027]
}, Open  ]],

Cell["\<\
The complex roots can be found by using complex starting values.\
\>", "ExampleText",
 CellID->388715189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "x", "+", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "I"}], "}"}]}], "]"}]], "Input",
 CellTags->"FindRoot::lstol",
 CellLabel->"In[2]:=",
 CellID->6024],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{
    RowBox[{"-", "0.5`"}], "+", 
    RowBox[{"0.8660254037844386`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 CellTags->"FindRoot::lstol",
 CellLabel->"Out[2]=",
 CellID->37382655]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "x", "+", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "I"}]}], "}"}]}], "]"}]], "Input",
 CellTags->"FindRoot::lstol",
 CellLabel->"In[3]:=",
 CellID->32547],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{
    RowBox[{"-", "0.5`"}], "-", 
    RowBox[{"0.8660254037844386`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 CellTags->"FindRoot::lstol",
 CellLabel->"Out[3]=",
 CellID->373258991]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FindRoot::lstol - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 2, 26.8905322}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "FindRoot::lstol", "synonyms" -> {}, "title" -> 
    "FindRoot::lstol", "type" -> "Message", "uri" -> "ref/message/lstol"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2419, 87, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->355731796]},
 "FindRoot::lstol"->{
  Cell[3122, 116, 261, 9, 70, "Input",
   CellTags->"FindRoot::lstol",
   CellID->26991],
  Cell[3386, 127, 449, 9, 70, "Message",
   CellTags->"FindRoot::lstol",
   CellID->489231768],
  Cell[3838, 138, 188, 6, 70, "Output",
   CellTags->"FindRoot::lstol",
   CellID->94865027],
  Cell[4181, 154, 260, 9, 70, "Input",
   CellTags->"FindRoot::lstol",
   CellID->6024],
  Cell[4444, 165, 256, 9, 70, "Output",
   CellTags->"FindRoot::lstol",
   CellID->37382655],
  Cell[4737, 179, 282, 10, 70, "Input",
   CellTags->"FindRoot::lstol",
   CellID->32547],
  Cell[5022, 191, 257, 9, 70, "Output",
   CellTags->"FindRoot::lstol",
   CellID->373258991]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6254, 229},
 {"FindRoot::lstol", 6395, 233}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 1, 70, "ObjectName",
 CellID->18863],
Cell[CellGroupData[{
Cell[781, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 49, 395, 7, 70, "Message",
 CellID->603784960],
Cell[1657, 58, 273, 8, 70, "Notes",
 CellID->7507],
Cell[1933, 68, 449, 14, 70, "Notes",
 CellID->11465]
}, Closed]],
Cell[CellGroupData[{
Cell[2419, 87, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->355731796],
Cell[CellGroupData[{
Cell[2804, 101, 148, 5, 70, "ExampleSection",
 CellID->251779417],
Cell[2955, 108, 142, 4, 70, "ExampleText",
 CellID->273031067],
Cell[CellGroupData[{
Cell[3122, 116, 261, 9, 70, "Input",
 CellTags->"FindRoot::lstol",
 CellID->26991],
Cell[3386, 127, 449, 9, 70, "Message",
 CellTags->"FindRoot::lstol",
 CellID->489231768],
Cell[3838, 138, 188, 6, 70, "Output",
 CellTags->"FindRoot::lstol",
 CellID->94865027]
}, Open  ]],
Cell[4041, 147, 115, 3, 70, "ExampleText",
 CellID->388715189],
Cell[CellGroupData[{
Cell[4181, 154, 260, 9, 70, "Input",
 CellTags->"FindRoot::lstol",
 CellID->6024],
Cell[4444, 165, 256, 9, 70, "Output",
 CellTags->"FindRoot::lstol",
 CellID->37382655]
}, Open  ]],
Cell[CellGroupData[{
Cell[4737, 179, 282, 10, 70, "Input",
 CellTags->"FindRoot::lstol",
 CellID->32547],
Cell[5022, 191, 257, 9, 70, "Output",
 CellTags->"FindRoot::lstol",
 CellID->373258991]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5318, 205, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

