(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7691,        296]
NotebookOptionsPosition[      4460,        186]
NotebookOutlinePosition[      6259,        243]
CellTagsIndexPosition[      6145,        237]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Format::fttp", "ObjectName",
 CellID->16187],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Format", "::", "\<\"fttp\"\>"}], ":", 
  " ", "\<\"Format type `1` is not a symbol.\"\>"}]], "Message", "MSG",
 CellID->3967859],

Cell[TextData[{
 "Generated when the second argument in ",
 Cell[BoxData[
  ButtonBox["Format",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Format"]], "InlineFormula"],
 " is not a symbol."
}], "Notes",
 CellID->10370],

Cell[TextData[{
 "The second argument in ",
 Cell[BoxData[
  ButtonBox["Format",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Format"]], "InlineFormula"],
 " is expected to be a symbol that specifies a format type."
}], "Notes",
 CellID->4687]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->54475827],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->269514742],

Cell[TextData[{
 "An error occurs in this example because the second argument in ",
 Cell[BoxData[
  ButtonBox["Format",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Format"]], "InlineFormula"],
 " is a normal expression rather than a symbol."
}], "ExampleText",
 CellID->437962275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Format", "[", 
   RowBox[{"FortranForm", ",", 
    RowBox[{"test", "[", "p_", "]"}]}], "]"}], ":=", 
  RowBox[{"test", "[", 
   RowBox[{"p", ",", "0"}], "]"}]}]], "Input",
 CellTags->"Format::fttp",
 CellLabel->"In[1]:=",
 CellID->23163],

Cell[BoxData[
 RowBox[{
  RowBox[{"Format", "::", "\<\"fttp\"\>"}], ":", 
  " ", "\<\"Format type \\!\\(test[p_]\\) is not a symbol.\"\>"}]], "Message",\
 "MSG",
 CellTags->"Format::fttp",
 CellID->356299108],

Cell[BoxData["$Failed"], "Output",
 CellTags->"Format::fttp",
 CellLabel->"Out[1]=",
 CellID->395516603]
}, Open  ]],

Cell["This example shows valid arguments in a formatting rule.", "ExampleText",
 CellID->543678021],

Cell[BoxData[
 RowBox[{
  RowBox[{"Format", "[", 
   RowBox[{
    RowBox[{"test", "[", "p_", "]"}], ",", "FortranForm"}], "]"}], ":=", 
  RowBox[{"test", "[", 
   RowBox[{"p", ",", "0"}], "]"}]}]], "Input",
 CellTags->"Format::fttp",
 CellLabel->"In[2]:=",
 CellID->19881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FortranForm", "[", 
  RowBox[{"test", "[", "7", "]"}], "]"}]], "Input",
 CellTags->"Format::fttp",
 CellLabel->"In[3]:=",
 CellID->29754],

Cell["test(7,0)", "Output",
 CellTags->"Format::fttp",
 CellLabel->"Out[3]//FortranForm=",
 CellID->551388397]
}, Open  ]],

Cell[TextData[{
 "Remove the formatting rule for ",
 StyleBox["test", "MR"],
 "."
}], "ExampleText",
 CellID->150955],

Cell[BoxData[
 RowBox[{
  RowBox[{"Format", "[", 
   RowBox[{
    RowBox[{"test", "[", "p_", "]"}], ",", "FortranForm"}], "]"}], 
  "=."}]], "Input",
 CellTags->"Format::fttp",
 CellLabel->"In[4]:=",
 CellID->20160]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Format::fttp - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 2, 50.4380100}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Format::fttp", "synonyms" -> {}, "title" -> "Format::fttp", 
    "type" -> "Message", "uri" -> "ref/message/fttp"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1932, 78, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->54475827]},
 "Format::fttp"->{
  Cell[2778, 111, 272, 9, 70, "Input",
   CellTags->"Format::fttp",
   CellID->23163],
  Cell[3053, 122, 208, 6, 70, "Message",
   CellTags->"Format::fttp",
   CellID->356299108],
  Cell[3264, 130, 104, 3, 70, "Output",
   CellTags->"Format::fttp",
   CellID->395516603],
  Cell[3485, 139, 272, 9, 70, "Input",
   CellTags->"Format::fttp",
   CellID->19881],
  Cell[3782, 152, 161, 5, 70, "Input",
   CellTags->"Format::fttp",
   CellID->29754],
  Cell[3946, 159, 110, 3, 70, "Output",
   CellTags->"Format::fttp",
   CellID->551388397],
  Cell[4191, 172, 215, 8, 70, "Input",
   CellTags->"Format::fttp",
   CellID->20160]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5359, 208},
 {"Format::fttp", 5496, 212}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 50, 1, 70, "ObjectName",
 CellID->16187],
Cell[CellGroupData[{
Cell[778, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1256, 49, 163, 4, 70, "Message",
 CellID->3967859],
Cell[1422, 55, 223, 8, 70, "Notes",
 CellID->10370],
Cell[1648, 65, 247, 8, 70, "Notes",
 CellID->4687]
}, Closed]],
Cell[CellGroupData[{
Cell[1932, 78, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->54475827],
Cell[CellGroupData[{
Cell[2316, 92, 148, 5, 70, "ExampleSection",
 CellID->269514742],
Cell[2467, 99, 286, 8, 70, "ExampleText",
 CellID->437962275],
Cell[CellGroupData[{
Cell[2778, 111, 272, 9, 70, "Input",
 CellTags->"Format::fttp",
 CellID->23163],
Cell[3053, 122, 208, 6, 70, "Message",
 CellTags->"Format::fttp",
 CellID->356299108],
Cell[3264, 130, 104, 3, 70, "Output",
 CellTags->"Format::fttp",
 CellID->395516603]
}, Open  ]],
Cell[3383, 136, 99, 1, 70, "ExampleText",
 CellID->543678021],
Cell[3485, 139, 272, 9, 70, "Input",
 CellTags->"Format::fttp",
 CellID->19881],
Cell[CellGroupData[{
Cell[3782, 152, 161, 5, 70, "Input",
 CellTags->"Format::fttp",
 CellID->29754],
Cell[3946, 159, 110, 3, 70, "Output",
 CellTags->"Format::fttp",
 CellID->551388397]
}, Open  ]],
Cell[4071, 165, 117, 5, 70, "ExampleText",
 CellID->150955],
Cell[4191, 172, 215, 8, 70, "Input",
 CellTags->"Format::fttp",
 CellID->20160]
}, Open  ]]
}, Open  ]],
Cell[4433, 184, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

