(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11085,        426]
NotebookOptionsPosition[      6567,        272]
NotebookOutlinePosition[      8952,        347]
CellTagsIndexPosition[      8836,        341]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Function::slot", "ObjectName",
 CellID->10342],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "::", "\<\"slot\"\>"}], ":", 
  " ", "\<\"`1` (in `2`) should contain a non-negative integer.\"\>"}]], \
"Message", "MSG",
 CellID->340259500],

Cell[TextData[{
 "Generated when the argument in ",
 Cell[BoxData[
  ButtonBox["Slot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slot"]], "InlineFormula"],
 " is not an integer or is negative."
}], "Notes",
 CellID->14433],

Cell[TextData[{
 StyleBox["Slot[n]", "MR"],
 " can be entered using the notation ",
 StyleBox["#n", "MR"],
 "."
}], "Notes",
 CellID->18543],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["Slot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slot"]], "InlineFormula"],
 " is used in a position where it is not evaluated, such as in ",
 Cell[BoxData[
  ButtonBox["Function",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Function"]], "InlineFormula"],
 ", arguments that might evaluate to integers will not be evaluated unless ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " or some other construction is used to cause the evaluation."
}], "Notes",
 CellID->18542]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->13188719],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->77103564],

Cell["\<\
An error occurs in this example because a symbol is used when a non-negative \
integer is expected.\
\>", "ExampleText",
 CellID->40958277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Slot", "[", "n", "]"}], "&"}]], "Input",
 CellTags->"Function::slot",
 CellLabel->"In[1]:=",
 CellID->23103],

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "::", "\<\"slot\"\>"}], ":", 
  " ", "\<\"\\!\\(Slot[n]\\) (in \\!\\(\\(\\(Slot[n]\\)\\) &\\)) should \
contain a non-negative integer.\"\>"}]], "Message", "MSG",
 CellTags->"Function::slot",
 CellID->347160139],

Cell[BoxData[
 RowBox[{
  RowBox[{"Slot", "[", "n", "]"}], "&"}]], "Output",
 CellTags->"Function::slot",
 CellLabel->"Out[1]=",
 CellID->80846693]
}, Open  ]],

Cell[TextData[{
 "The same error will be generated unless the argument in ",
 Cell[BoxData[
  ButtonBox["Slot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slot"]], "InlineFormula"],
 " is a non-negative integer or evaluates to give a non-negative integer."
}], "ExampleText",
 CellID->236402212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", "=", "1"}], "}"}], ",", 
   RowBox[{
    RowBox[{"Slot", "[", "n", "]"}], "&"}]}], "]"}]], "Input",
 CellTags->"Function::slot",
 CellLabel->"In[2]:=",
 CellID->10305],

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "::", "\<\"slot\"\>"}], ":", 
  " ", "\<\"\\!\\(Slot[n]\\) (in \\!\\(\\(\\(Slot[n]\\)\\) &\\)) should \
contain a non-negative integer.\"\>"}]], "Message", "MSG",
 CellTags->"Function::slot",
 CellID->15170520],

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "::", "\<\"slot\"\>"}], ":", 
  " ", "\<\"\\!\\(Slot[n]\\) (in \\!\\(\\(\\(Slot[n]\\)\\) &\\)) should \
contain a non-negative integer.\"\>"}]], "Message", "MSG",
 CellTags->"Function::slot",
 CellID->324302733],

Cell[BoxData[
 RowBox[{
  RowBox[{"Slot", "[", "n", "]"}], "&"}]], "Output",
 CellTags->"Function::slot",
 CellLabel->"Out[2]=",
 CellID->183715000]
}, Open  ]],

Cell[TextData[{
 "These examples show valid uses of ",
 Cell[BoxData[
  ButtonBox["Slot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slot"]], "InlineFormula"],
 " in a ",
 Cell[BoxData[
  ButtonBox["Function",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Function"]], "InlineFormula"],
 " expression."
}], "ExampleText",
 CellID->118498440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Slot", "[", "1", "]"}], "&"}]], "Input",
 CellTags->"Function::slot",
 CellLabel->"In[3]:=",
 CellID->19384],

Cell[BoxData[
 RowBox[{"#1", "&"}]], "Output",
 CellTags->"Function::slot",
 CellLabel->"Out[3]=",
 CellID->96495866]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", "=", "1"}], "}"}], ",", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"Slot", "[", "n", "]"}], "]"}], "&"}]}], "]"}]], "Input",
 CellTags->"Function::slot",
 CellLabel->"In[4]:=",
 CellID->707975881],

Cell[BoxData[
 RowBox[{"#1", "&"}]], "Output",
 CellTags->"Function::slot",
 CellLabel->"Out[4]=",
 CellID->24260261]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", "=", "1"}], "}"}], ",", 
   RowBox[{
    RowBox[{"Slot", "[", "n", "]"}], "&"}]}], "]"}]], "Input",
 CellTags->"Function::slot",
 CellLabel->"In[5]:=",
 CellID->29554],

Cell[BoxData[
 RowBox[{"#1", "&"}]], "Output",
 CellTags->"Function::slot",
 CellLabel->"Out[5]=",
 CellID->435635425]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Function::slot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 3, 14.5948784}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Function::slot", "synonyms" -> {}, "title" -> 
    "Function::slot", "type" -> "Message", "uri" -> "ref/message/slot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2470, 97, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->13188719]},
 "Function::slot"->{
  Cell[3178, 126, 143, 5, 70, "Input",
   CellTags->"Function::slot",
   CellID->23103],
  Cell[3324, 133, 257, 6, 70, "Message",
   CellTags->"Function::slot",
   CellID->347160139],
  Cell[3584, 141, 147, 5, 70, "Output",
   CellTags->"Function::slot",
   CellID->80846693],
  Cell[4072, 161, 250, 9, 70, "Input",
   CellTags->"Function::slot",
   CellID->10305],
  Cell[4325, 172, 256, 6, 70, "Message",
   CellTags->"Function::slot",
   CellID->15170520],
  Cell[4584, 180, 257, 6, 70, "Message",
   CellTags->"Function::slot",
   CellID->324302733],
  Cell[4844, 188, 148, 5, 70, "Output",
   CellTags->"Function::slot",
   CellID->183715000],
  Cell[5382, 213, 143, 5, 70, "Input",
   CellTags->"Function::slot",
   CellID->19384],
  Cell[5528, 220, 117, 4, 70, "Output",
   CellTags->"Function::slot",
   CellID->96495866],
  Cell[5682, 229, 292, 10, 70, "Input",
   CellTags->"Function::slot",
   CellID->707975881],
  Cell[5977, 241, 117, 4, 70, "Output",
   CellTags->"Function::slot",
   CellID->24260261],
  Cell[6131, 250, 249, 9, 70, "Input",
   CellTags->"Function::slot",
   CellID->29554],
  Cell[6383, 261, 118, 4, 70, "Output",
   CellTags->"Function::slot",
   CellID->435635425]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7472, 294},
 {"Function::slot", 7611, 298}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->10342],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 188, 5, 70, "Message",
 CellID->340259500],
Cell[1449, 56, 229, 8, 70, "Notes",
 CellID->14433],
Cell[1681, 66, 140, 6, 70, "Notes",
 CellID->18543],
Cell[1824, 74, 609, 18, 70, "Notes",
 CellID->18542]
}, Closed]],
Cell[CellGroupData[{
Cell[2470, 97, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->13188719],
Cell[CellGroupData[{
Cell[2854, 111, 147, 5, 70, "ExampleSection",
 CellID->77103564],
Cell[3004, 118, 149, 4, 70, "ExampleText",
 CellID->40958277],
Cell[CellGroupData[{
Cell[3178, 126, 143, 5, 70, "Input",
 CellTags->"Function::slot",
 CellID->23103],
Cell[3324, 133, 257, 6, 70, "Message",
 CellTags->"Function::slot",
 CellID->347160139],
Cell[3584, 141, 147, 5, 70, "Output",
 CellTags->"Function::slot",
 CellID->80846693]
}, Open  ]],
Cell[3746, 149, 301, 8, 70, "ExampleText",
 CellID->236402212],
Cell[CellGroupData[{
Cell[4072, 161, 250, 9, 70, "Input",
 CellTags->"Function::slot",
 CellID->10305],
Cell[4325, 172, 256, 6, 70, "Message",
 CellTags->"Function::slot",
 CellID->15170520],
Cell[4584, 180, 257, 6, 70, "Message",
 CellTags->"Function::slot",
 CellID->324302733],
Cell[4844, 188, 148, 5, 70, "Output",
 CellTags->"Function::slot",
 CellID->183715000]
}, Open  ]],
Cell[5007, 196, 350, 13, 70, "ExampleText",
 CellID->118498440],
Cell[CellGroupData[{
Cell[5382, 213, 143, 5, 70, "Input",
 CellTags->"Function::slot",
 CellID->19384],
Cell[5528, 220, 117, 4, 70, "Output",
 CellTags->"Function::slot",
 CellID->96495866]
}, Open  ]],
Cell[CellGroupData[{
Cell[5682, 229, 292, 10, 70, "Input",
 CellTags->"Function::slot",
 CellID->707975881],
Cell[5977, 241, 117, 4, 70, "Output",
 CellTags->"Function::slot",
 CellID->24260261]
}, Open  ]],
Cell[CellGroupData[{
Cell[6131, 250, 249, 9, 70, "Input",
 CellTags->"Function::slot",
 CellID->29554],
Cell[6383, 261, 118, 4, 70, "Output",
 CellTags->"Function::slot",
 CellID->435635425]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6540, 270, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

