(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12625,        485]
NotebookOptionsPosition[      8082,        331]
NotebookOutlinePosition[     10481,        406]
CellTagsIndexPosition[     10364,        400]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Function::slotp", "ObjectName",
 CellID->26553],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "::", "\<\"slotp\"\>"}], ":", 
  " ", "\<\"`1` (in `2`) should contain a positive integer.\"\>"}]], "Message",\
 "MSG",
 CellID->622438407],

Cell[TextData[{
 "Generated when the argument in a ",
 Cell[BoxData[
  ButtonBox["SlotSequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SlotSequence"]], "InlineFormula"],
 " expression in ",
 Cell[BoxData[
  ButtonBox["Function",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Function"]], "InlineFormula"],
 " is not a positive integer."
}], "Notes",
 CellID->32625],

Cell[TextData[{
 "The notation ",
 StyleBox["##", "MR"],
 StyleBox["n", "MR",
  FontSlant->"Italic"],
 " is equivalent to ",
 StyleBox["SlotSequence[", "MR"],
 StyleBox["n", "MR",
  FontSlant->"Italic"],
 StyleBox["]", "MR"],
 " if ",
 StyleBox["n", "MR",
  FontSlant->"Italic"],
 " is a positive integer."
}], "Notes",
 CellID->20827],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["SlotSequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SlotSequence"]], "InlineFormula"],
 " is used in a position where it is not evaluated, such as in ",
 Cell[BoxData[
  ButtonBox["Function",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Function"]], "InlineFormula"],
 ", arguments that might evaluate to integers will not be evaluated unless ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " or some other construction is used to cause the evaluation."
}], "Notes",
 CellID->12216]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->25946],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->160949895],

Cell[TextData[{
 "An error occurs in this example because the argument in ",
 Cell[BoxData[
  ButtonBox["SlotSequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SlotSequence"]], "InlineFormula"],
 " is not an integer."
}], "ExampleText",
 CellID->653478450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Slot", "[", "1", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"SlotSequence", "[", "n", "]"}], "}"}]}], "}"}], "&"}]], "Input",\

 CellTags->"Function::slotp",
 CellLabel->"In[1]:=",
 CellID->23187],

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "::", "\<\"slotp\"\>"}], ":", 
  " ", "\<\"\\!\\(SlotSequence[n]\\) (in \\!\\(\\(\\({#1, \
\\(\\({\\(SlotSequence[n]\\)}\\)\\)}\\)\\) &\\)) should contain a positive \
integer.\"\>"}]], "Message", "MSG",
 CellTags->"Function::slotp",
 CellID->71060044],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"#1", ",", 
    RowBox[{"{", 
     RowBox[{"SlotSequence", "[", "n", "]"}], "}"}]}], "}"}], "&"}]], "Output",\

 CellTags->"Function::slotp",
 CellLabel->"Out[1]=",
 CellID->232878695]
}, Open  ]],

Cell[TextData[{
 "The same error will be generated unless the argument in ",
 Cell[BoxData[
  ButtonBox["SlotSequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SlotSequence"]], "InlineFormula"],
 " is a non-negative integer or evaluates to give a non-negative integer."
}], "ExampleText",
 CellID->327218249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", "=", "2"}], "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#", ",", 
      RowBox[{"{", 
       RowBox[{"SlotSequence", "[", "n", "]"}], "}"}]}], "}"}], "&"}]}], 
  "]"}]], "Input",
 CellTags->"Function::slotp",
 CellLabel->"In[2]:=",
 CellID->13401],

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "::", "\<\"slotp\"\>"}], ":", 
  " ", "\<\"\\!\\(SlotSequence[n]\\) (in \\!\\(\\(\\({#1, \
\\(\\({\\(SlotSequence[n]\\)}\\)\\)}\\)\\) &\\)) should contain a positive \
integer.\"\>"}]], "Message", "MSG",
 CellTags->"Function::slotp",
 CellID->284021298],

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "::", "\<\"slotp\"\>"}], ":", 
  " ", "\<\"\\!\\(SlotSequence[n]\\) (in \\!\\(\\(\\({#1, \
\\(\\({\\(SlotSequence[n]\\)}\\)\\)}\\)\\) &\\)) should contain a positive \
integer.\"\>"}]], "Message", "MSG",
 CellTags->"Function::slotp",
 CellID->385269172],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"#1", ",", 
    RowBox[{"{", 
     RowBox[{"SlotSequence", "[", "n", "]"}], "}"}]}], "}"}], "&"}]], "Output",\

 CellTags->"Function::slotp",
 CellLabel->"Out[2]=",
 CellID->6279986]
}, Open  ]],

Cell[TextData[{
 "These examples show valid uses of ",
 Cell[BoxData[
  ButtonBox["SlotSequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SlotSequence"]], "InlineFormula"],
 " in a ",
 Cell[BoxData[
  ButtonBox["Function",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Function"]], "InlineFormula"],
 " expression."
}], "ExampleText",
 CellID->37282125],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"#1", ",", 
    RowBox[{"{", 
     RowBox[{"SlotSequence", "[", "2", "]"}], "}"}]}], "}"}], "&"}]], "Input",\

 CellTags->"Function::slotp",
 CellLabel->"In[3]:=",
 CellID->4174],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"#1", ",", 
    RowBox[{"{", "##2", "}"}]}], "}"}], "&"}]], "Output",
 CellTags->"Function::slotp",
 CellLabel->"Out[3]=",
 CellID->204081265]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", "=", "2"}], "}"}], ",", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"{", 
      RowBox[{"#1", ",", 
       RowBox[{"{", 
        RowBox[{"SlotSequence", "[", "n", "]"}], "}"}]}], "}"}], "]"}], 
    "&"}]}], "]"}]], "Input",
 CellTags->"Function::slotp",
 CellLabel->"In[4]:=",
 CellID->7899],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"#1", ",", 
    RowBox[{"{", "##2", "}"}]}], "}"}], "&"}]], "Output",
 CellTags->"Function::slotp",
 CellLabel->"Out[4]=",
 CellID->698817715]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", "=", "2"}], "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#1", ",", 
      RowBox[{"{", 
       RowBox[{"SlotSequence", "[", "n", "]"}], "}"}]}], "}"}], "&"}]}], 
  "]"}]], "Input",
 CellTags->"Function::slotp",
 CellLabel->"In[5]:=",
 CellID->16931],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"#1", ",", 
    RowBox[{"{", "##2", "}"}]}], "}"}], "&"}]], "Output",
 CellTags->"Function::slotp",
 CellLabel->"Out[5]=",
 CellID->17044062]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Function::slotp - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 3, 14.8917610}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Function::slotp", "synonyms" -> {}, "title" -> 
    "Function::slotp", "type" -> "Message", "uri" -> "ref/message/slotp"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2829, 111, 356, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->25946]},
 "Function::slotp"->{
  Cell[3651, 144, 262, 10, 70, "Input",
   CellTags->"Function::slotp",
   CellID->23187],
  Cell[3916, 156, 298, 7, 70, "Message",
   CellTags->"Function::slotp",
   CellID->71060044],
  Cell[4217, 165, 235, 9, 70, "Output",
   CellTags->"Function::slotp",
   CellID->232878695],
  Cell[4809, 189, 343, 13, 70, "Input",
   CellTags->"Function::slotp",
   CellID->13401],
  Cell[5155, 204, 299, 7, 70, "Message",
   CellTags->"Function::slotp",
   CellID->284021298],
  Cell[5457, 213, 299, 7, 70, "Message",
   CellTags->"Function::slotp",
   CellID->385269172],
  Cell[5759, 222, 233, 9, 70, "Output",
   CellTags->"Function::slotp",
   CellID->6279986],
  Cell[6397, 251, 229, 9, 70, "Input",
   CellTags->"Function::slotp",
   CellID->4174],
  Cell[6629, 262, 193, 7, 70, "Output",
   CellTags->"Function::slotp",
   CellID->204081265],
  Cell[6859, 274, 386, 14, 70, "Input",
   CellTags->"Function::slotp",
   CellID->7899],
  Cell[7248, 290, 193, 7, 70, "Output",
   CellTags->"Function::slotp",
   CellID->698817715],
  Cell[7478, 302, 343, 13, 70, "Input",
   CellTags->"Function::slotp",
   CellID->16931],
  Cell[7824, 317, 192, 7, 70, "Output",
   CellTags->"Function::slotp",
   CellID->17044062]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8991, 353},
 {"Function::slotp", 9129, 357}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 1, 70, "ObjectName",
 CellID->26553],
Cell[CellGroupData[{
Cell[781, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 49, 185, 5, 70, "Message",
 CellID->622438407],
Cell[1447, 56, 379, 13, 70, "Notes",
 CellID->32625],
Cell[1829, 71, 335, 15, 70, "Notes",
 CellID->20827],
Cell[2167, 88, 625, 18, 70, "Notes",
 CellID->12216]
}, Closed]],
Cell[CellGroupData[{
Cell[2829, 111, 356, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->25946],
Cell[CellGroupData[{
Cell[3210, 125, 148, 5, 70, "ExampleSection",
 CellID->160949895],
Cell[3361, 132, 265, 8, 70, "ExampleText",
 CellID->653478450],
Cell[CellGroupData[{
Cell[3651, 144, 262, 10, 70, "Input",
 CellTags->"Function::slotp",
 CellID->23187],
Cell[3916, 156, 298, 7, 70, "Message",
 CellTags->"Function::slotp",
 CellID->71060044],
Cell[4217, 165, 235, 9, 70, "Output",
 CellTags->"Function::slotp",
 CellID->232878695]
}, Open  ]],
Cell[4467, 177, 317, 8, 70, "ExampleText",
 CellID->327218249],
Cell[CellGroupData[{
Cell[4809, 189, 343, 13, 70, "Input",
 CellTags->"Function::slotp",
 CellID->13401],
Cell[5155, 204, 299, 7, 70, "Message",
 CellTags->"Function::slotp",
 CellID->284021298],
Cell[5457, 213, 299, 7, 70, "Message",
 CellTags->"Function::slotp",
 CellID->385269172],
Cell[5759, 222, 233, 9, 70, "Output",
 CellTags->"Function::slotp",
 CellID->6279986]
}, Open  ]],
Cell[6007, 234, 365, 13, 70, "ExampleText",
 CellID->37282125],
Cell[CellGroupData[{
Cell[6397, 251, 229, 9, 70, "Input",
 CellTags->"Function::slotp",
 CellID->4174],
Cell[6629, 262, 193, 7, 70, "Output",
 CellTags->"Function::slotp",
 CellID->204081265]
}, Open  ]],
Cell[CellGroupData[{
Cell[6859, 274, 386, 14, 70, "Input",
 CellTags->"Function::slotp",
 CellID->7899],
Cell[7248, 290, 193, 7, 70, "Output",
 CellTags->"Function::slotp",
 CellID->698817715]
}, Open  ]],
Cell[CellGroupData[{
Cell[7478, 302, 343, 13, 70, "Input",
 CellTags->"Function::slotp",
 CellID->16931],
Cell[7824, 317, 192, 7, 70, "Output",
 CellTags->"Function::slotp",
 CellID->17044062]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[8055, 329, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

