(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9217,        303]
NotebookOptionsPosition[      5617,        194]
NotebookOutlinePosition[      7753,        255]
CellTagsIndexPosition[      7622,        249]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["FunctionInterpolation::argdim", "ObjectName",
 CellID->30132],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionInterpolation", "::", "\<\"argdim\"\>"}], ":", 
  " ", "\<\"The dimension of the argument to an InterpolatingFunction \
function object in the input does not match the dimension of the \
InterpolatingFunction.\"\>"}]], "Message", "MSG",
 CellID->844608640],

Cell[TextData[{
 "Generated when an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " expression is used with an incorrect number of arguments and occurs as an  \
argument in ",
 Cell[BoxData[
  ButtonBox["FunctionInterpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionInterpolation"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->8154]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->9577286],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->171878544],

Cell[TextData[{
 "An error occurs in this example because a one-dimensional ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " expression is used with two arguments."
}], "ExampleText",
 CellID->33059724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionInterpolation", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"3", " ", 
     RowBox[{
      RowBox[{"Interpolation", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "2", ",", "1"}], "}"}], "]"}], 
      "[", 
      RowBox[{"x", ",", "y"}], "]"}]}], "\n", "\t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellTags->"FunctionInterpolation::argdim",
 CellLabel->"In[1]:=",
 CellID->2852],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionInterpolation", "::", "\<\"argdim\"\>"}], ":", 
  " ", "\<\"The dimension of the argument to an InterpolatingFunction \
function object in the input does not match the dimension of the \
InterpolatingFunction.\"\>"}]], "Message", "MSG",
 CellTags->"FunctionInterpolation::argdim",
 CellID->327390149],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionInterpolation", "::", "\<\"nreal\"\>"}], ":", 
  " ", "\<\"Near \\!\\({x}\\) = \\!\\({1}\\), the function did not evaluate \
to a real number.\"\>"}]], "Message", "MSG",
 CellTags->"FunctionInterpolation::argdim",
 CellID->213574998],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionInterpolation", "::", "\<\"nreal\"\>"}], ":", 
  " ", "\<\"Near \\!\\({x}\\) = \\!\\({7\\/5}\\), the function did not \
evaluate to a real number.\"\>"}]], "Message", "MSG",
 CellTags->"FunctionInterpolation::argdim",
 CellID->638491298],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionInterpolation", "::", "\<\"nreal\"\>"}], ":", 
  " ", "\<\"Near \\!\\({x}\\) = \\!\\({9\\/5}\\), the function did not \
evaluate to a real number.\"\>"}]], "Message", "MSG",
 CellTags->"FunctionInterpolation::argdim",
 CellID->264996081],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"stop\"\>"}], ":", 
  " ", "\<\"Further output of \\!\\(FunctionInterpolation :: \\\"nreal\\\"\\) \
will be suppressed during this calculation.\"\>"}]], "Message", "MSG",
 CellTags->"FunctionInterpolation::argdim",
 CellID->439788946],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionInterpolation", "::", "\<\"precbd\"\>"}], ":", 
  " ", "\<\"Requested precision \\!\\(\[Infinity]\\) is not a machine-sized \
real number between $MinPrecision and $MaxPrecision.\"\>"}]], "Message", \
"MSG",
 CellTags->"FunctionInterpolation::argdim",
 CellID->6072124],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"FunctionInterpolation::argdim",
 CellLabel->"Out[1]=",
 CellID->695680383]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FunctionInterpolation::argdim - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 3, 7.1259372}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "FunctionInterpolation::argdim", "synonyms" -> {}, "title" -> 
    "FunctionInterpolation::argdim", "type" -> "Message", "uri" -> 
    "ref/message/argdim"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2068, 76, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->9577286]},
 "FunctionInterpolation::argdim"->{
  Cell[2931, 109, 507, 15, 70, "Input",
   CellTags->"FunctionInterpolation::argdim",
   CellID->2852],
  Cell[3441, 126, 343, 7, 70, "Message",
   CellTags->"FunctionInterpolation::argdim",
   CellID->327390149],
  Cell[3787, 135, 276, 6, 70, "Message",
   CellTags->"FunctionInterpolation::argdim",
   CellID->213574998],
  Cell[4066, 143, 280, 6, 70, "Message",
   CellTags->"FunctionInterpolation::argdim",
   CellID->638491298],
  Cell[4349, 151, 280, 6, 70, "Message",
   CellTags->"FunctionInterpolation::argdim",
   CellID->264996081],
  Cell[4632, 159, 289, 6, 70, "Message",
   CellTags->"FunctionInterpolation::argdim",
   CellID->439788946],
  Cell[4924, 167, 312, 7, 70, "Message",
   CellTags->"FunctionInterpolation::argdim",
   CellID->6072124],
  Cell[5239, 176, 312, 11, 70, "Output",
   CellTags->"FunctionInterpolation::argdim",
   CellID->695680383]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6573, 217},
 {"FunctionInterpolation::argdim", 6726, 221}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 67, 1, 70, "ObjectName",
 CellID->30132],
Cell[CellGroupData[{
Cell[795, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1273, 49, 299, 6, 70, "Message",
 CellID->844608640],
Cell[1575, 57, 456, 14, 70, "Notes",
 CellID->8154]
}, Closed]],
Cell[CellGroupData[{
Cell[2068, 76, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->9577286],
Cell[CellGroupData[{
Cell[2451, 90, 148, 5, 70, "ExampleSection",
 CellID->171878544],
Cell[2602, 97, 304, 8, 70, "ExampleText",
 CellID->33059724],
Cell[CellGroupData[{
Cell[2931, 109, 507, 15, 70, "Input",
 CellTags->"FunctionInterpolation::argdim",
 CellID->2852],
Cell[3441, 126, 343, 7, 70, "Message",
 CellTags->"FunctionInterpolation::argdim",
 CellID->327390149],
Cell[3787, 135, 276, 6, 70, "Message",
 CellTags->"FunctionInterpolation::argdim",
 CellID->213574998],
Cell[4066, 143, 280, 6, 70, "Message",
 CellTags->"FunctionInterpolation::argdim",
 CellID->638491298],
Cell[4349, 151, 280, 6, 70, "Message",
 CellTags->"FunctionInterpolation::argdim",
 CellID->264996081],
Cell[4632, 159, 289, 6, 70, "Message",
 CellTags->"FunctionInterpolation::argdim",
 CellID->439788946],
Cell[4924, 167, 312, 7, 70, "Message",
 CellTags->"FunctionInterpolation::argdim",
 CellID->6072124],
Cell[5239, 176, 312, 11, 70, "Output",
 CellTags->"FunctionInterpolation::argdim",
 CellID->695680383]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5590, 192, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

