(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9226,        317]
NotebookOptionsPosition[      5900,        212]
NotebookOutlinePosition[      7785,        267]
CellTagsIndexPosition[      7656,        261]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["FunctionInterpolation::ncvb", "ObjectName",
 CellID->5342],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionInterpolation", "::", "\<\"ncvb\"\>"}], ":", 
  " ", "\<\"FunctionInterpolation failed to meet the prescribed accuracy and \
precision goals after `1` recursive bisections near `2` = `3`. Continuing to \
refine elsewhere.\"\>"}]], "Message", "MSG",
 CellID->13417359],

Cell[TextData[{
 "Generated when ",
 Cell[BoxData[
  ButtonBox["FunctionInterpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionInterpolation"]], "InlineFormula"],
 " is unable to compute a suitable interpolation using the indicated number  \
of recursive refinements of the interval."
}], "Notes",
 CellID->1956],

Cell["\<\
This message  is most often seen for functions that have a sharp feature or \
that have  features that are difficult to approximate.\
\>", "Notes",
 CellID->12726],

Cell[TextData[{
 "This error  can usually be corrected by increasing the value of the ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " option, decreasing the ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " options, or through qualitative changes in the input, such as breaking the \
 interpolation up into smooth segments."
}], "Notes",
 CellID->23600]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->9441328],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->929403043],

Cell["\<\
An error occurs in this example because of difficulties approximating the \
sharp feature in the function given in the first argument.\
\>", "ExampleText",
 CellID->126966343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionInterpolation", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"FunctionInterpolation::ncvb",
 CellLabel->"In[1]:=",
 CellID->29956],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionInterpolation", "::", "\<\"ncvb\"\>"}], ":", 
  " ", "\<\"FunctionInterpolation failed to meet the prescribed accuracy and \
precision goals after \\!\\(9\\) recursive bisections near \\!\\(x\\) = \
\\!\\(0.`\\). Continuing to refine elsewhere.\"\>"}]], "Message", "MSG",
 CellTags->"FunctionInterpolation::ncvb",
 CellID->188686106],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionInterpolation", "::", "\<\"ncvb\"\>"}], ":", 
  " ", "\<\"FunctionInterpolation failed to meet the prescribed accuracy and \
precision goals after \\!\\(9\\) recursive bisections near \\!\\(x\\) = \
\\!\\(0.0009765625`\\). Continuing to refine elsewhere.\"\>"}]], "Message", \
"MSG",
 CellTags->"FunctionInterpolation::ncvb",
 CellID->143756146],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"FunctionInterpolation::ncvb",
 CellLabel->"Out[1]=",
 CellID->1774571]
}, Open  ]],

Cell[TextData[{
 "The interpolation can be constructed without error by reducing the value of \
 the ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " option."
}], "ExampleText",
 CellID->781073729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionInterpolation", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"AccuracyGoal", "->", "2"}]}], "]"}]], "Input",
 CellTags->"FunctionInterpolation::ncvb",
 CellLabel->"In[2]:=",
 CellID->3625],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"FunctionInterpolation::ncvb",
 CellLabel->"Out[2]=",
 CellID->412501528]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FunctionInterpolation::ncvb - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 3, 7.2665658}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "FunctionInterpolation::ncvb", "synonyms" -> {}, "title" -> 
    "FunctionInterpolation::ncvb", "type" -> "Message", "uri" -> 
    "ref/message/ncvb"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2788, 98, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->9441328]},
 "FunctionInterpolation::ncvb"->{
  Cell[3532, 127, 269, 8, 70, "Input",
   CellTags->"FunctionInterpolation::ncvb",
   CellID->29956],
  Cell[3804, 137, 376, 7, 70, "Message",
   CellTags->"FunctionInterpolation::ncvb",
   CellID->188686106],
  Cell[4183, 146, 388, 8, 70, "Message",
   CellTags->"FunctionInterpolation::ncvb",
   CellID->143756146],
  Cell[4574, 156, 312, 11, 70, "Output",
   CellTags->"FunctionInterpolation::ncvb",
   CellID->1774571],
  Cell[5207, 183, 314, 9, 70, "Input",
   CellTags->"FunctionInterpolation::ncvb",
   CellID->3625],
  Cell[5524, 194, 310, 11, 70, "Output",
   CellTags->"FunctionInterpolation::ncvb",
   CellID->412501528]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6848, 235},
 {"FunctionInterpolation::ncvb", 6999, 239}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 64, 1, 70, "ObjectName",
 CellID->5342],
Cell[CellGroupData[{
Cell[792, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1270, 49, 310, 6, 70, "Message",
 CellID->13417359],
Cell[1583, 57, 330, 9, 70, "Notes",
 CellID->1956],
Cell[1916, 68, 173, 4, 70, "Notes",
 CellID->12726],
Cell[2092, 74, 659, 19, 70, "Notes",
 CellID->23600]
}, Closed]],
Cell[CellGroupData[{
Cell[2788, 98, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->9441328],
Cell[CellGroupData[{
Cell[3171, 112, 148, 5, 70, "ExampleSection",
 CellID->929403043],
Cell[3322, 119, 185, 4, 70, "ExampleText",
 CellID->126966343],
Cell[CellGroupData[{
Cell[3532, 127, 269, 8, 70, "Input",
 CellTags->"FunctionInterpolation::ncvb",
 CellID->29956],
Cell[3804, 137, 376, 7, 70, "Message",
 CellTags->"FunctionInterpolation::ncvb",
 CellID->188686106],
Cell[4183, 146, 388, 8, 70, "Message",
 CellTags->"FunctionInterpolation::ncvb",
 CellID->143756146],
Cell[4574, 156, 312, 11, 70, "Output",
 CellTags->"FunctionInterpolation::ncvb",
 CellID->1774571]
}, Open  ]],
Cell[4901, 170, 281, 9, 70, "ExampleText",
 CellID->781073729],
Cell[CellGroupData[{
Cell[5207, 183, 314, 9, 70, "Input",
 CellTags->"FunctionInterpolation::ncvb",
 CellID->3625],
Cell[5524, 194, 310, 11, 70, "Output",
 CellTags->"FunctionInterpolation::ncvb",
 CellID->412501528]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5873, 210, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

