(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12965,        464]
NotebookOptionsPosition[      9067,        332]
NotebookOutlinePosition[     11171,        398]
CellTagsIndexPosition[     11055,        392]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::dupv", "ObjectName",
 CellID->26817],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"dupv\"\>"}], ":", 
  " ", "\<\"Duplicate variable `1` found in `2`.\"\>"}]], "Message", "MSG",
 CellID->6304623],

Cell["\<\
Generated when the same name is used to specify two variables that are \
required to be distinct.\
\>", "Notes",
 CellID->3922]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->214210123],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->118844439],

Cell[TextData[{
 "An error occurs in this example because the same symbol is used in both of  \
the range specifications (the third and fourth arguments) in this input to ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->117682833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"2", ",", "0"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "==", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "1"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"0", ",", "t"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"1", ",", "t"}], "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "==", 
      RowBox[{"x", "^", "2"}]}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"General::dupv",
 CellLabel->"In[1]:=",
 CellID->24445],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"dupv\"\>"}], ":", 
  " ", "\<\"Duplicate variable \\!\\(x\\) found in \
\\!\\(NDSolve[\\(\\(\\(\\({\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"f\\\", \
TagBox[\\((2, 0)\\), Derivative], Rule[MultilineFunction, \
None]]\\)\\)[\\(\\(x, t\\)\\)]\\)\\) \[Equal] \
\\(\\(\\(\\(\\*SuperscriptBox[\\\"f\\\", TagBox[\\((0, 1)\\), Derivative], \
Rule[MultilineFunction, None]]\\)\\)[\\(\\(x, t\\)\\)]\\)\\)\\)\\), \\(\\(\\(\
\\(f[\\(\\(0, t\\)\\)]\\)\\) \[Equal] 0\\)\\), \\(\\(\\(\\(f[\\(\\(1, \
t\\)\\)]\\)\\) \[Equal] 1\\)\\), \\(\\(\\(\\(f[\\(\\(x, 0\\)\\)]\\)\\) \
\[Equal] x\\^2\\)\\)}\\)\\), f, \\(\\({x, 0, 1}\\)\\), \\(\\({x, 0, \
1}\\)\\)\\)\\)]\\).\"\>"}]], "Message", "MSG",
 CellTags->"General::dupv",
 CellID->688456966],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"0", ",", "t"}], "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"1", ",", "t"}], "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "\[Equal]", 
      SuperscriptBox["x", "2"]}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Output",
 CellTags->"General::dupv",
 CellLabel->"Out[1]=",
 CellID->221746606]
}, Open  ]],

Cell[TextData[{
 "This shows valid input to ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->127665467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"2", ",", "0"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "==", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "1"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"0", ",", "t"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"1", ",", "t"}], "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "==", 
      RowBox[{"x", "^", "2"}]}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"General::dupv",
 CellLabel->"In[2]:=",
 CellID->13414],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"General::dupv",
 CellLabel->"Out[2]=",
 CellID->305069129]
}, Open  ]],

Cell["\<\
An error occurs in this example because the same symbol is used for both \
variables of integration.\
\>", "ExampleText",
 CellID->637487842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"x", " ", "y"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"General::dupv",
 CellLabel->"In[3]:=",
 CellID->3616],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"dupv\"\>"}], ":", 
  " ", "\<\"Duplicate variable \\!\\(x\\) found in \\!\\(NIntegrate[\\(\\(\\(\
\\(x\\\\ y\\)\\), \\(\\({x, 0, 1}\\)\\), \\(\\({x, 0, \
1}\\)\\)\\)\\)]\\).\"\>"}]], "Message", "MSG",
 CellTags->"General::dupv",
 CellID->11160914],

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"x", " ", "y"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Output",
 CellTags->"General::dupv",
 CellLabel->"Out[3]=",
 CellID->11445469]
}, Open  ]],

Cell[TextData[{
 "This shows valid variable specifications in ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->493236103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"x", " ", "y"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"General::dupv",
 CellLabel->"In[4]:=",
 CellID->267474499],

Cell[BoxData["0.24999999999999994`"], "Output",
 CellTags->"General::dupv",
 CellLabel->"Out[4]=",
 CellID->156215562]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::dupv - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 4, 10.4400580}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::dupv", "synonyms" -> {}, "title" -> 
    "General::dupv", "type" -> "Message", "uri" -> "ref/message/dupv"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1602, 64, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->214210123]},
 "General::dupv"->{
  Cell[2497, 98, 1004, 32, 70, "Input",
   CellTags->"General::dupv",
   CellID->24445],
  Cell[3504, 132, 777, 14, 70, "Message",
   CellTags->"General::dupv",
   CellID->688456966],
  Cell[4284, 148, 1144, 38, 70, "Output",
   CellTags->"General::dupv",
   CellID->221746606],
  Cell[5675, 201, 1004, 32, 70, "Input",
   CellTags->"General::dupv",
   CellID->13414],
  Cell[6682, 235, 502, 18, 70, "Output",
   CellTags->"General::dupv",
   CellID->305069129],
  Cell[7375, 264, 304, 10, 70, "Input",
   CellTags->"General::dupv",
   CellID->3616],
  Cell[7682, 276, 306, 7, 70, "Message",
   CellTags->"General::dupv",
   CellID->11160914],
  Cell[7991, 285, 309, 10, 70, "Output",
   CellTags->"General::dupv",
   CellID->11445469],
  Cell[8571, 310, 309, 10, 70, "Input",
   CellTags->"General::dupv",
   CellID->267474499],
  Cell[8883, 322, 118, 3, 70, "Output",
   CellTags->"General::dupv",
   CellID->156215562]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9969, 354},
 {"General::dupv", 10108, 358}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->26817],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 168, 4, 70, "Message",
 CellID->6304623],
Cell[1428, 55, 137, 4, 70, "Notes",
 CellID->3922]
}, Closed]],
Cell[CellGroupData[{
Cell[1602, 64, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->214210123],
Cell[CellGroupData[{
Cell[1987, 78, 148, 5, 70, "ExampleSection",
 CellID->118844439],
Cell[2138, 85, 334, 9, 70, "ExampleText",
 CellID->117682833],
Cell[CellGroupData[{
Cell[2497, 98, 1004, 32, 70, "Input",
 CellTags->"General::dupv",
 CellID->24445],
Cell[3504, 132, 777, 14, 70, "Message",
 CellTags->"General::dupv",
 CellID->688456966],
Cell[4284, 148, 1144, 38, 70, "Output",
 CellTags->"General::dupv",
 CellID->221746606]
}, Open  ]],
Cell[5443, 189, 207, 8, 70, "ExampleText",
 CellID->127665467],
Cell[CellGroupData[{
Cell[5675, 201, 1004, 32, 70, "Input",
 CellTags->"General::dupv",
 CellID->13414],
Cell[6682, 235, 502, 18, 70, "Output",
 CellTags->"General::dupv",
 CellID->305069129]
}, Open  ]],
Cell[7199, 256, 151, 4, 70, "ExampleText",
 CellID->637487842],
Cell[CellGroupData[{
Cell[7375, 264, 304, 10, 70, "Input",
 CellTags->"General::dupv",
 CellID->3616],
Cell[7682, 276, 306, 7, 70, "Message",
 CellTags->"General::dupv",
 CellID->11160914],
Cell[7991, 285, 309, 10, 70, "Output",
 CellTags->"General::dupv",
 CellID->11445469]
}, Open  ]],
Cell[8315, 298, 231, 8, 70, "ExampleText",
 CellID->493236103],
Cell[CellGroupData[{
Cell[8571, 310, 309, 10, 70, "Input",
 CellTags->"General::dupv",
 CellID->267474499],
Cell[8883, 322, 118, 3, 70, "Output",
 CellTags->"General::dupv",
 CellID->156215562]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[9040, 330, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

