(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7850,        290]
NotebookOptionsPosition[      5035,        196]
NotebookOutlinePosition[      6682,        247]
CellTagsIndexPosition[      6566,        241]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::estep", "ObjectName",
 CellID->3749],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"estep\"\>"}], ":", 
  " ", "\<\"Value of option `1` -> `2` is not a positive integer.\"\>"}]], \
"Message", "MSG",
 CellID->13165168],

Cell[TextData[{
 "Generated when the value of the ",
 Cell[BoxData[
  ButtonBox["ExponentStep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentStep"]], "InlineFormula"],
 " option is not a positive integer or infinity."
}], "Notes",
 CellID->27055]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->402883270],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->687860407],

Cell[TextData[{
 "An error occurs in this example because the value of the ",
 Cell[BoxData[
  ButtonBox["ExponentStep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentStep"]], "InlineFormula"],
 " option is an inexact number rather than an integer."
}], "ExampleText",
 CellID->64894695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.7*^-23", ",", "2.3*^18", ",", "3.9*^35"}], "}"}], ",", 
   RowBox[{"ExponentStep", "->", "5.0"}]}], "]"}]], "Input",
 CellTags->"General::estep",
 CellLabel->"In[1]:=",
 CellID->15333],

Cell[BoxData[
 RowBox[{
  RowBox[{"NumberForm", "::", "\<\"estep\"\>"}], ":", 
  " ", "\<\"Value of option \\!\\(ExponentStep\\) -> \\!\\(\\\"5.\\\"\\) is \
not a positive integer.\"\>"}]], "Message", "MSG",
 CellTags->"General::estep",
 CellID->196552351],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"1.7\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"-23\"\>"]}],
     1.7*^-23,
     AutoDelete->True], ",", 
    InterpretationBox[
     RowBox[{"\<\"2.3\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"18\"\>"]}],
     2.3*^18,
     AutoDelete->True], ",", 
    InterpretationBox[
     RowBox[{"\<\"3.9\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"35\"\>"]}],
     3.9*^35,
     AutoDelete->True]}], "}"}],
  NumberForm[#, ExponentStep -> 5.]& ]], "Output",
 CellTags->"General::estep",
 CellLabel->"Out[1]//NumberForm=",
 CellID->2174755]
}, Open  ]],

Cell[TextData[{
 "This shows a valid value for the ",
 Cell[BoxData[
  ButtonBox["ExponentStep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentStep"]], "InlineFormula"],
 " option."
}], "ExampleText",
 CellID->696137093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.7*^-23", ",", "2.3*^18", ",", "3.9*^35"}], "}"}], ",", 
   RowBox[{"ExponentStep", "->", "5"}]}], "]"}]], "Input",
 CellTags->"General::estep",
 CellLabel->"In[2]:=",
 CellID->21330],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"170.\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"-25\"\>"]}],
     1.7*^-23,
     AutoDelete->True], ",", 
    InterpretationBox[
     RowBox[{"\<\"2300.\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"15\"\>"]}],
     2.3*^18,
     AutoDelete->True], ",", 
    InterpretationBox[
     RowBox[{"\<\"3.9\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"35\"\>"]}],
     3.9*^35,
     AutoDelete->True]}], "}"}],
  NumberForm[#, ExponentStep -> 5]& ]], "Output",
 CellTags->"General::estep",
 CellLabel->"Out[2]//NumberForm=",
 CellID->102903163]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::estep - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 4, 18.2683834}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::estep", "synonyms" -> {}, "title" -> 
    "General::estep", "type" -> "Message", "uri" -> "ref/message/estep"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1744, 69, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->402883270]},
 "General::estep"->{
  Cell[2603, 102, 270, 8, 70, "Input",
   CellTags->"General::estep",
   CellID->15333],
  Cell[2876, 112, 256, 6, 70, "Message",
   CellTags->"General::estep",
   CellID->196552351],
  Cell[3135, 120, 644, 22, 70, "Output",
   CellTags->"General::estep",
   CellID->2174755],
  Cell[4050, 157, 268, 8, 70, "Input",
   CellTags->"General::estep",
   CellID->21330],
  Cell[4321, 167, 648, 22, 70, "Output",
   CellTags->"General::estep",
   CellID->102903163]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5941, 218},
 {"General::estep", 6081, 222}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->3749],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 189, 5, 70, "Message",
 CellID->13165168],
Cell[1449, 56, 258, 8, 70, "Notes",
 CellID->27055]
}, Closed]],
Cell[CellGroupData[{
Cell[1744, 69, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->402883270],
Cell[CellGroupData[{
Cell[2129, 83, 148, 5, 70, "ExampleSection",
 CellID->687860407],
Cell[2280, 90, 298, 8, 70, "ExampleText",
 CellID->64894695],
Cell[CellGroupData[{
Cell[2603, 102, 270, 8, 70, "Input",
 CellTags->"General::estep",
 CellID->15333],
Cell[2876, 112, 256, 6, 70, "Message",
 CellTags->"General::estep",
 CellID->196552351],
Cell[3135, 120, 644, 22, 70, "Output",
 CellTags->"General::estep",
 CellID->2174755]
}, Open  ]],
Cell[3794, 145, 231, 8, 70, "ExampleText",
 CellID->696137093],
Cell[CellGroupData[{
Cell[4050, 157, 268, 8, 70, "Input",
 CellTags->"General::estep",
 CellID->21330],
Cell[4321, 167, 648, 22, 70, "Output",
 CellTags->"General::estep",
 CellID->102903163]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5008, 194, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

