(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9051,        345]
NotebookOptionsPosition[      6070,        245]
NotebookOutlinePosition[      7718,        296]
CellTagsIndexPosition[      7602,        290]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::level", "ObjectName",
 CellID->3066],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"level\"\>"}], ":", 
  " ", "\<\"Level specification `1` is not of the form n, {n}, or {m, \
n}.\"\>"}]], "Message", "MSG",
 CellID->750081553],

Cell["\<\
Generated when a level specification does not have the  expected form.\
\>", "Notes",
 CellID->27734],

Cell["\<\
A level specification is normally  expected to be either an integer or a list \
of one or two integers. \
\>", "Notes",
 CellID->22991],

Cell[TextData[{
 "Level specifications are used by ",
 Cell[BoxData[
  ButtonBox["Apply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apply"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Cases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cases"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Count",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Count"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["DeleteCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DeleteCases"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FreeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FreeQ"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Level",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Level"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MapIndexed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapIndexed"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MemberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MemberQ"]], "InlineFormula"],
 ", ",
 StyleBox["Pad", "MR"],
 ", ",
 Cell[BoxData[
  ButtonBox["Position",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Position"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Scan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scan"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Select",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Select"]], "InlineFormula"],
 ", and other functions."
}], "Notes",
 CellID->5846],

Cell["\<\
Level specifications indicate  the depth within an expression that should be \
inspected or modified.\
\>", "Notes",
 CellID->29403]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->38384942],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->49857781],

Cell[TextData[{
 "The third element in ",
 Cell[BoxData[
  ButtonBox["MemberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MemberQ"]], "InlineFormula"],
 " is a level specification.  The level specification in this example does  \
not have a correct form."
}], "ExampleText",
 CellID->156391186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"28", ",", "11", ",", "15", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", " ", "7", ",", " ", "13"}], "}"}], ",", "11"}], "}"}],
    ",", "7", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"General::level",
 CellLabel->"In[1]:=",
 CellID->8044],

Cell[BoxData[
 RowBox[{
  RowBox[{"MemberQ", "::", "\<\"level\"\>"}], ":", 
  " ", "\<\"Level specification \\!\\({0, 1, 2}\\) is not of the form n, {n}, \
or {m, n}.\"\>"}]], "Message", "MSG",
 CellTags->"General::level",
 CellID->312218177],

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"28", ",", "11", ",", "15", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "7", ",", "13"}], "}"}], ",", "11"}], "}"}], ",", "7",
    ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Output",
 CellTags->"General::level",
 CellLabel->"Out[1]=",
 CellID->96820160]
}, Open  ]],

Cell["\<\
This shows a correct way to specify levels 0, 1, and 2 in an expression.\
\>", "ExampleText",
 CellID->105845859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"28", ",", "11", ",", "15", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", " ", "7", ",", " ", "13"}], "}"}], ",", "11"}], "}"}],
    ",", "7", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"General::level",
 CellLabel->"In[2]:=",
 CellID->12800],

Cell[BoxData["True"], "Output",
 CellTags->"General::level",
 CellLabel->"Out[2]=",
 CellID->147348907]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::level - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 4, 58.8319218}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::level", "synonyms" -> {}, "title" -> 
    "General::level", "type" -> "Message", "uri" -> "ref/message/level"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3501, 143, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->38384942]},
 "General::level"->{
  Cell[4361, 177, 380, 12, 70, "Input",
   CellTags->"General::level",
   CellID->8044],
  Cell[4744, 191, 242, 6, 70, "Message",
   CellTags->"General::level",
   CellID->312218177],
  Cell[4989, 199, 375, 12, 70, "Output",
   CellTags->"General::level",
   CellID->96820160],
  Cell[5527, 221, 371, 12, 70, "Input",
   CellTags->"General::level",
   CellID->12800],
  Cell[5901, 235, 103, 3, 70, "Output",
   CellTags->"General::level",
   CellID->147348907]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6976, 267},
 {"General::level", 7116, 271}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->3066],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 198, 5, 70, "Message",
 CellID->750081553],
Cell[1458, 56, 111, 3, 70, "Notes",
 CellID->27734],
Cell[1572, 61, 145, 4, 70, "Notes",
 CellID->22991],
Cell[1720, 67, 1599, 65, 70, "Notes",
 CellID->5846],
Cell[3322, 134, 142, 4, 70, "Notes",
 CellID->29403]
}, Closed]],
Cell[CellGroupData[{
Cell[3501, 143, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->38384942],
Cell[CellGroupData[{
Cell[3885, 157, 147, 5, 70, "ExampleSection",
 CellID->49857781],
Cell[4035, 164, 301, 9, 70, "ExampleText",
 CellID->156391186],
Cell[CellGroupData[{
Cell[4361, 177, 380, 12, 70, "Input",
 CellTags->"General::level",
 CellID->8044],
Cell[4744, 191, 242, 6, 70, "Message",
 CellTags->"General::level",
 CellID->312218177],
Cell[4989, 199, 375, 12, 70, "Output",
 CellTags->"General::level",
 CellID->96820160]
}, Open  ]],
Cell[5379, 214, 123, 3, 70, "ExampleText",
 CellID->105845859],
Cell[CellGroupData[{
Cell[5527, 221, 371, 12, 70, "Input",
 CellTags->"General::level",
 CellID->12800],
Cell[5901, 235, 103, 3, 70, "Output",
 CellTags->"General::level",
 CellID->147348907]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6043, 243, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

