(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9914,        360]
NotebookOptionsPosition[      6468,        244]
NotebookOutlinePosition[      8315,        301]
CellTagsIndexPosition[      8198,        295]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::meprec", "ObjectName",
 CellID->20381],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = `1` reached while \
evaluating `2`.\"\>"}]], "Message", "MSG",
 CellID->452465580],

Cell["\<\
Generated when the indicated precision is insufficient  for numerical \
resolution of an inequality.\
\>", "Notes",
 CellID->20658],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically uses numerical computations to resolve inequalities  \
involving numeric quantities. The precision used in these computations is  \
limited by the value of ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6074],

Cell["\<\
This message can be generated when comparing  expressions that are \
numerically equivalent. In such cases, no amount of  extra precision can \
resolve the inequality.\
\>", "Notes",
 CellID->15179],

Cell["\<\
This  message can be generated within other functions that use inequalities, \
and so  can appear even when there are no inequalities in the input. \
\>", "Notes",
 CellID->19787],

Cell["\<\
This message is primarily advisory and often does not  indicate an error \
condition.\
\>", "Notes",
 CellID->11556]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->88818449],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->44198497],

Cell[TextData[{
 "Since ",
 StyleBox["Sin[2]", "MR"],
 " is numerically equivalent to ",
 StyleBox["2 Sin[1] Cos[1]", "MR"],
 ", this inequality cannot be resolved using numerical methods.  Increasing  \
the value of ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " will not help to resolve the inequality in this example."
}], "ExampleText",
 CellID->65312500],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", "2", "]"}], " ", "<", " ", 
  RowBox[{"2", " ", 
   RowBox[{"Sin", "[", "1", "]"}], " ", 
   RowBox[{"Cos", "[", "1", "]"}]}]}]], "Input",
 CellTags->"General::meprec",
 CellLabel->"In[1]:=",
 CellID->32502],

Cell[BoxData["False"], "Output",
 CellTags->"General::meprec",
 CellLabel->"Out[1]=",
 CellID->720674626]
}, Open  ]],

Cell[TextData[{
 "Although the default precision used to resolve inequalities is insufficient \
 in this example, this inequality can be resolved by increasing the value of  \
",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 ". You can use ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " to temporarily change the value of ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->7171590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", "2", "]"}], " ", "<", " ", 
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"Sin", "[", "1", "]"}], " ", 
    RowBox[{"Cos", "[", "1", "]"}]}], "+", 
   RowBox[{"Exp", "[", 
    RowBox[{"-", "1000"}], "]"}]}]}]], "Input",
 CellTags->"General::meprec",
 CellLabel->"In[2]:=",
 CellID->5840],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \
\\!\\(\\(\\(-\\(\\(1\\/\[ExponentialE]\\^1000\\)\\)\\)\\) - \\(\\(2\\\\ \
\\(\\(Cos[1]\\)\\)\\\\ \\(\\(Sin[1]\\)\\)\\)\\) + \
\\(\\(Sin[2]\\)\\)\\).\"\>"}]], "Message", "MSG",
 CellTags->"General::meprec",
 CellID->230799300],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", "2", "]"}], "<", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox["\[ExponentialE]", "1000"]], "+", 
   RowBox[{"2", " ", 
    RowBox[{"Cos", "[", "1", "]"}], " ", 
    RowBox[{"Sin", "[", "1", "]"}]}]}]}]], "Output",
 CellTags->"General::meprec",
 CellLabel->"Out[2]=",
 CellID->443042946]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", " ", "=", " ", "1000"}], "}"}], ",", "\n", 
   "\t", 
   RowBox[{
    RowBox[{"Sin", "[", "2", "]"}], "<", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"Sin", "[", "1", "]"}], " ", 
      RowBox[{"Cos", "[", "1", "]"}]}], "+", 
     RowBox[{"Exp", "[", 
      RowBox[{"-", "1000"}], "]"}]}]}]}], "]"}]], "Input",
 CellTags->"General::meprec",
 CellLabel->"In[3]:=",
 CellID->393409658],

Cell[BoxData["True"], "Output",
 CellTags->"General::meprec",
 CellLabel->"Out[3]=",
 CellID->160848697]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::meprec - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 5, 7.2852632}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::meprec", "synonyms" -> {}, "title" -> 
    "General::meprec", "type" -> "Message", "uri" -> "ref/message/meprec"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2604, 98, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->88818449]},
 "General::meprec"->{
  Cell[3620, 136, 253, 8, 70, "Input",
   CellTags->"General::meprec",
   CellID->32502],
  Cell[3876, 146, 105, 3, 70, "Output",
   CellTags->"General::meprec",
   CellID->720674626],
  Cell[4692, 176, 332, 11, 70, "Input",
   CellTags->"General::meprec",
   CellID->5840],
  Cell[5027, 189, 397, 9, 70, "Message",
   CellTags->"General::meprec",
   CellID->230799300],
  Cell[5427, 200, 339, 11, 70, "Output",
   CellTags->"General::meprec",
   CellID->443042946],
  Cell[5803, 216, 492, 16, 70, "Input",
   CellTags->"General::meprec",
   CellID->393409658],
  Cell[6298, 234, 104, 3, 70, "Output",
   CellTags->"General::meprec",
   CellID->160848697]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7377, 266},
 {"General::meprec", 7517, 270}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 1, 70, "ObjectName",
 CellID->20381],
Cell[CellGroupData[{
Cell[781, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 49, 217, 5, 70, "Message",
 CellID->452465580],
Cell[1479, 56, 141, 4, 70, "Notes",
 CellID->20658],
Cell[1623, 62, 412, 12, 70, "Notes",
 CellID->6074],
Cell[2038, 76, 208, 5, 70, "Notes",
 CellID->15179],
Cell[2249, 83, 189, 4, 70, "Notes",
 CellID->19787],
Cell[2441, 89, 126, 4, 70, "Notes",
 CellID->11556]
}, Closed]],
Cell[CellGroupData[{
Cell[2604, 98, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->88818449],
Cell[CellGroupData[{
Cell[2988, 112, 147, 5, 70, "ExampleSection",
 CellID->44198497],
Cell[3138, 119, 457, 13, 70, "ExampleText",
 CellID->65312500],
Cell[CellGroupData[{
Cell[3620, 136, 253, 8, 70, "Input",
 CellTags->"General::meprec",
 CellID->32502],
Cell[3876, 146, 105, 3, 70, "Output",
 CellTags->"General::meprec",
 CellID->720674626]
}, Open  ]],
Cell[3996, 152, 671, 20, 70, "ExampleText",
 CellID->7171590],
Cell[CellGroupData[{
Cell[4692, 176, 332, 11, 70, "Input",
 CellTags->"General::meprec",
 CellID->5840],
Cell[5027, 189, 397, 9, 70, "Message",
 CellTags->"General::meprec",
 CellID->230799300],
Cell[5427, 200, 339, 11, 70, "Output",
 CellTags->"General::meprec",
 CellID->443042946]
}, Open  ]],
Cell[CellGroupData[{
Cell[5803, 216, 492, 16, 70, "Input",
 CellTags->"General::meprec",
 CellID->393409658],
Cell[6298, 234, 104, 3, 70, "Output",
 CellTags->"General::meprec",
 CellID->160848697]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6441, 242, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

