(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7756,        298]
NotebookOptionsPosition[      4849,        200]
NotebookOutlinePosition[      6484,        251]
CellTagsIndexPosition[      6369,        245]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::nalg", "ObjectName",
 CellID->10058],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"nalg\"\>"}], ":", 
  " ", "\<\"`1` is not an explicit algebraic number.\"\>"}]], "Message", \
"MSG",
 CellID->829114],

Cell["\<\
Generated when the indicated expression is expected to  be an algebraic \
number.\
\>", "Notes",
 CellID->28339],

Cell[TextData[{
 "The value of the ",
 Cell[BoxData[
  ButtonBox["Extension",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Extension"]], "InlineFormula"],
 " option in ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " and related functions is expected to be an algebraic number or a list of  \
algebraic numbers."
}], "Notes",
 CellID->22944],

Cell[TextData[{
 "An algebraic number is a number that  can occur as the root of a polynomial \
with integer coefficients.  Integers,  rational numbers, roots of integers, \
and ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " expressions are algebraic numbers."
}], "Notes",
 CellID->20264]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->511330179],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->72042463],

Cell[TextData[{
 "An error occurs in this example because ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 " is a symbol rather than an algebraic number."
}], "ExampleText",
 CellID->122405630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"2", "-", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"Extension", "->", "All"}]}], "]"}]], "Input",
 CellTags->"General::nalg",
 CellLabel->"In[1]:=",
 CellID->19747],

Cell[BoxData[
 RowBox[{
  RowBox[{"Factor", "::", "\<\"nalg\"\>"}], ":", 
  " ", "\<\"\\!\\(All\\) is not an explicit algebraic number.\"\>"}]], \
"Message", "MSG",
 CellTags->"General::nalg",
 CellID->23494695],

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"2", "-", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{"Extension", "\[Rule]", "All"}]}], "]"}]], "Output",
 CellTags->"General::nalg",
 CellLabel->"Out[1]=",
 CellID->117220999]
}, Open  ]],

Cell[TextData[{
 "This shows a valid value for the ",
 Cell[BoxData[
  ButtonBox["Extension",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Extension"]], "InlineFormula"],
 " option in ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->409280157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"2", "-", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"Extension", "->", 
    RowBox[{"Sqrt", "[", "2", "]"}]}]}], "]"}]], "Input",
 CellTags->"General::nalg",
 CellLabel->"In[2]:=",
 CellID->9736],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "-", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "+", "x"}], ")"}]}]], "Output",
 CellTags->"General::nalg",
 CellLabel->"Out[2]=",
 CellID->145030998]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::nalg - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 5, 22.4419012}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::nalg", "synonyms" -> {}, "title" -> 
    "General::nalg", "type" -> "Message", "uri" -> "ref/message/nalg"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2374, 93, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->511330179]},
 "General::nalg"->{
  Cell[3191, 126, 233, 8, 70, "Input",
   CellTags->"General::nalg",
   CellID->19747],
  Cell[3427, 136, 211, 6, 70, "Message",
   CellTags->"General::nalg",
   CellID->23494695],
  Cell[3641, 144, 244, 8, 70, "Output",
   CellTags->"General::nalg",
   CellID->117220999],
  Cell[4274, 172, 263, 9, 70, "Input",
   CellTags->"General::nalg",
   CellID->9736],
  Cell[4540, 183, 243, 10, 70, "Output",
   CellTags->"General::nalg",
   CellID->145030998]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5751, 222},
 {"General::nalg", 5890, 226}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->10058],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 173, 5, 70, "Message",
 CellID->829114],
Cell[1433, 56, 122, 4, 70, "Notes",
 CellID->28339],
Cell[1558, 62, 417, 14, 70, "Notes",
 CellID->22944],
Cell[1978, 78, 359, 10, 70, "Notes",
 CellID->20264]
}, Closed]],
Cell[CellGroupData[{
Cell[2374, 93, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->511330179],
Cell[CellGroupData[{
Cell[2759, 107, 147, 5, 70, "ExampleSection",
 CellID->72042463],
Cell[2909, 114, 257, 8, 70, "ExampleText",
 CellID->122405630],
Cell[CellGroupData[{
Cell[3191, 126, 233, 8, 70, "Input",
 CellTags->"General::nalg",
 CellID->19747],
Cell[3427, 136, 211, 6, 70, "Message",
 CellTags->"General::nalg",
 CellID->23494695],
Cell[3641, 144, 244, 8, 70, "Output",
 CellTags->"General::nalg",
 CellID->117220999]
}, Open  ]],
Cell[3900, 155, 349, 13, 70, "ExampleText",
 CellID->409280157],
Cell[CellGroupData[{
Cell[4274, 172, 263, 9, 70, "Input",
 CellTags->"General::nalg",
 CellID->9736],
Cell[4540, 183, 243, 10, 70, "Output",
 CellTags->"General::nalg",
 CellID->145030998]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4822, 198, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

