(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10428,        389]
NotebookOptionsPosition[      6291,        249]
NotebookOutlinePosition[      8493,        318]
CellTagsIndexPosition[      8377,        312]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::njnum", "ObjectName",
 CellID->9404],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"njnum\"\>"}], ":", 
  " ", "\<\"The Jacobian is not a matrix of numbers at `2` = `1`.\"\>"}]], \
"Message", "MSG",
 CellID->347624626],

Cell[TextData[{
 "Generated when the value of the ",
 Cell[BoxData["Jacobian"], "InlineFormula"],
 " option does not have the required form, or when when the corresponding  \
derivatives are not numerical at the indicated point,"
}], "Notes",
 CellID->15675],

Cell[TextData[{
 " This error can occur if a point is encountered at which the derivatives of \
 the equations are singular or non-numerical, or if the value of the ",
 Cell[BoxData["Jacobian"], "InlineFormula"],
 " option includes symbolic parameters that do not have numerical values."
}], "Notes",
 CellID->8207]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->464633900],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->69761429],

Cell["\<\
An error occurs in this example because the first argument includes a \
symbolic parameter that does not have a numerical value.\
\>", "ExampleText",
 CellID->658461912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "==", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}], ",", 
   RowBox[{"Jacobian", "->", "f"}]}], "]"}]], "Input",
 CellTags->"General::njnum",
 CellLabel->"In[1]:=",
 CellID->23558],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"njnum\"\>"}], ":", 
  " ", "\<\"The Jacobian is not a matrix of numbers at \\!\\({x}\\) = \
\\!\\({2.`}\\).\"\>"}]], "Message", "MSG",
 CellTags->"General::njnum",
 CellID->373380936],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "2.`"}], "}"}]], "Output",
 CellTags->"General::njnum",
 CellLabel->"Out[1]=",
 CellID->34613807]
}, Open  ]],

Cell[TextData[{
 "This shows a valid value for the ",
 Cell[BoxData["Jacobian"], "InlineFormula"],
 " option in ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->436806173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", "=", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2", " ", 
        RowBox[{"Cos", "[", "x", "]"}]}], "}"}], "}"}]}], "}"}], ",", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}], "==", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "2"}], "}"}], ",", 
     RowBox[{"Jacobian", "->", "f"}]}], "]"}]}], "]"}]], "Input",
 CellTags->"General::njnum",
 CellLabel->"In[2]:=",
 CellID->30599],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "2.6179938779914944`"}], "}"}]], "Output",
 CellTags->"General::njnum",
 CellLabel->"Out[2]=",
 CellID->594818471]
}, Open  ]],

Cell["\<\
An error occurs in this example because the derivative of the first argument \
is singular at the starting point.\
\>", "ExampleText",
 CellID->860946238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", "x", "]"}], "==", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellTags->"General::njnum",
 CellLabel->"In[3]:=",
 CellID->6717],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/\\@0.`\\) encountered.\"\>"}]], \
"Message", "MSG",
 CellTags->"General::njnum",
 CellID->508563993],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"njnum\"\>"}], ":", 
  " ", "\<\"The Jacobian is not a matrix of numbers at \\!\\({x}\\) = \
\\!\\({0.`}\\).\"\>"}]], "Message", "MSG",
 CellTags->"General::njnum",
 CellID->27672034],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "0.`"}], "}"}]], "Output",
 CellTags->"General::njnum",
 CellLabel->"Out[3]=",
 CellID->727028220]
}, Open  ]],

Cell["\<\
This error can be avoided by choosing a different starting value.\
\>", "ExampleText",
 CellID->309676543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", "x", "]"}], "==", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"General::njnum",
 CellLabel->"In[4]:=",
 CellID->22982],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "4.`"}], "}"}]], "Output",
 CellTags->"General::njnum",
 CellLabel->"Out[4]=",
 CellID->188940014]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::njnum - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 5, 30.3014774}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::njnum", "synonyms" -> {}, "title" -> 
    "General::njnum", "type" -> "Message", "uri" -> "ref/message/njnum"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2063, 75, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->464633900]},
 "General::njnum"->{
  Cell[2802, 104, 326, 11, 70, "Input",
   CellTags->"General::njnum",
   CellID->23558],
  Cell[3131, 117, 240, 6, 70, "Message",
   CellTags->"General::njnum",
   CellID->373380936],
  Cell[3374, 125, 152, 5, 70, "Output",
   CellTags->"General::njnum",
   CellID->34613807],
  Cell[3843, 147, 561, 19, 70, "Input",
   CellTags->"General::njnum",
   CellID->30599],
  Cell[4407, 168, 169, 5, 70, "Output",
   CellTags->"General::njnum",
   CellID->594818471],
  Cell[4780, 184, 258, 9, 70, "Input",
   CellTags->"General::njnum",
   CellID->6717],
  Cell[5041, 195, 215, 6, 70, "Message",
   CellTags->"General::njnum",
   CellID->508563993],
  Cell[5259, 203, 239, 6, 70, "Message",
   CellTags->"General::njnum",
   CellID->27672034],
  Cell[5501, 211, 153, 5, 70, "Output",
   CellTags->"General::njnum",
   CellID->727028220],
  Cell[5810, 226, 259, 9, 70, "Input",
   CellTags->"General::njnum",
   CellID->22982],
  Cell[6072, 237, 153, 5, 70, "Output",
   CellTags->"General::njnum",
   CellID->188940014]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7197, 271},
 {"General::njnum", 7337, 275}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->9404],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 190, 5, 70, "Message",
 CellID->347624626],
Cell[1450, 56, 258, 6, 70, "Notes",
 CellID->15675],
Cell[1711, 64, 315, 6, 70, "Notes",
 CellID->8207]
}, Closed]],
Cell[CellGroupData[{
Cell[2063, 75, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->464633900],
Cell[CellGroupData[{
Cell[2448, 89, 147, 5, 70, "ExampleSection",
 CellID->69761429],
Cell[2598, 96, 179, 4, 70, "ExampleText",
 CellID->658461912],
Cell[CellGroupData[{
Cell[2802, 104, 326, 11, 70, "Input",
 CellTags->"General::njnum",
 CellID->23558],
Cell[3131, 117, 240, 6, 70, "Message",
 CellTags->"General::njnum",
 CellID->373380936],
Cell[3374, 125, 152, 5, 70, "Output",
 CellTags->"General::njnum",
 CellID->34613807]
}, Open  ]],
Cell[3541, 133, 277, 10, 70, "ExampleText",
 CellID->436806173],
Cell[CellGroupData[{
Cell[3843, 147, 561, 19, 70, "Input",
 CellTags->"General::njnum",
 CellID->30599],
Cell[4407, 168, 169, 5, 70, "Output",
 CellTags->"General::njnum",
 CellID->594818471]
}, Open  ]],
Cell[4591, 176, 164, 4, 70, "ExampleText",
 CellID->860946238],
Cell[CellGroupData[{
Cell[4780, 184, 258, 9, 70, "Input",
 CellTags->"General::njnum",
 CellID->6717],
Cell[5041, 195, 215, 6, 70, "Message",
 CellTags->"General::njnum",
 CellID->508563993],
Cell[5259, 203, 239, 6, 70, "Message",
 CellTags->"General::njnum",
 CellID->27672034],
Cell[5501, 211, 153, 5, 70, "Output",
 CellTags->"General::njnum",
 CellID->727028220]
}, Open  ]],
Cell[5669, 219, 116, 3, 70, "ExampleText",
 CellID->309676543],
Cell[CellGroupData[{
Cell[5810, 226, 259, 9, 70, "Input",
 CellTags->"General::njnum",
 CellID->22982],
Cell[6072, 237, 153, 5, 70, "Output",
 CellTags->"General::njnum",
 CellID->188940014]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6264, 247, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

