(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10764,        422]
NotebookOptionsPosition[      6042,        260]
NotebookOutlinePosition[      8501,        338]
CellTagsIndexPosition[      8385,        332]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::noval", "ObjectName",
 CellID->7480],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"noval\"\>"}], ":", 
  " ", "\<\"Symbol `1` in part assignment does not have an immediate value.\"\
\>"}]], "Message", "MSG",
 CellID->418237653],

Cell["\<\
Generated by an attempted assignment to part of the  value of a symbol when \
the symbol does not have an immediate value. \
\>", "Notes",
 CellID->10998],

Cell["\<\
It is necessary to initialize the value of a symbol  before making \
assignments to parts of the value of that symbol. \
\>", "Notes",
 CellID->27328],

Cell[TextData[{
 "Immediate values can be assigned using ",
 Cell[BoxData[
  ButtonBox["Set",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"]], "InlineFormula"],
 " (",
 StyleBox["lhs", "TI"],
 StyleBox["=", "MR"],
 StyleBox["rhs", "TI"],
 "). Delayed values can be assigned using ",
 Cell[BoxData[
  ButtonBox["SetDelayed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"]], "InlineFormula"],
 " (",
 StyleBox["lhs", "TI"],
 StyleBox[":=", "MR"],
 StyleBox["rhs", "TI"],
 ")."
}], "Notes",
 CellID->31141]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->580548964],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->374988065],

Cell[TextData[{
 "If the symbol ",
 StyleBox["vector", "MR"],
 " does not have a value, this assignment to ",
 StyleBox["vector[[1]]", "MR"],
 " will generate an error, and the assignment will not be made."
}], "ExampleText",
 CellID->223515621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"vector", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "=", "1"}]], "Input",
 CellTags->"General::noval",
 CellLabel->"In[1]:=",
 CellID->1570],

Cell[BoxData[
 RowBox[{
  RowBox[{"Set", "::", "\<\"noval\"\>"}], ":", 
  " ", "\<\"Symbol \\!\\(vector\\) in part assignment does not have an \
immediate value.\"\>"}]], "Message", "MSG",
 CellTags->"General::noval",
 CellID->631831015],

Cell[BoxData["1"], "Output",
 CellTags->"General::noval",
 CellLabel->"Out[1]=",
 CellID->635958]
}, Open  ]],

Cell[TextData[{
 "A similar error will occur if the value of ",
 StyleBox["vector", "MR"],
 " is a delayed value."
}], "ExampleText",
 CellID->169440598],

Cell[BoxData[
 RowBox[{"vector", ":=", 
  RowBox[{"{", 
   RowBox[{"Null", ",", "Null", ",", "Null"}], "}"}]}]], "Input",
 CellTags->"General::noval",
 CellLabel->"In[2]:=",
 CellID->11296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"vector", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "=", "1"}]], "Input",
 CellTags->"General::noval",
 CellLabel->"In[3]:=",
 CellID->4307],

Cell[BoxData[
 RowBox[{
  RowBox[{"Set", "::", "\<\"noval\"\>"}], ":", 
  " ", "\<\"Symbol \\!\\(vector\\) in part assignment does not have an \
immediate value.\"\>"}]], "Message", "MSG",
 CellTags->"General::noval",
 CellID->430445447],

Cell[BoxData["1"], "Output",
 CellTags->"General::noval",
 CellLabel->"Out[3]=",
 CellID->340370693]
}, Open  ]],

Cell[TextData[{
 "The assignment works as intended if ",
 StyleBox["vector", "MR"],
 " has an immediate value."
}], "ExampleText",
 CellID->89746601],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vector", "=", 
  RowBox[{"{", 
   RowBox[{"Null", ",", "Null", ",", "Null"}], "}"}]}]], "Input",
 CellTags->"General::noval",
 CellLabel->"In[4]:=",
 CellID->3865],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Null", ",", "Null", ",", "Null"}], "}"}]], "Output",
 CellTags->"General::noval",
 CellLabel->"Out[4]=",
 CellID->363611614]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"vector", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "=", "1"}]], "Input",
 CellTags->"General::noval",
 CellLabel->"In[5]:=",
 CellID->10024],

Cell[BoxData["1"], "Output",
 CellTags->"General::noval",
 CellLabel->"Out[5]=",
 CellID->302582058]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["vector"], "Input",
 CellTags->"General::noval",
 CellLabel->"In[6]:=",
 CellID->4399],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "Null", ",", "Null"}], "}"}]], "Output",
 CellTags->"General::noval",
 CellLabel->"Out[6]=",
 CellID->12272847]
}, Open  ]],

Cell[TextData[{
 "Clear the value of ",
 StyleBox["vector", "MR"],
 "."
}], "ExampleText",
 CellID->225609589],

Cell[BoxData[
 RowBox[{"Clear", "[", "vector", "]"}]], "Input",
 CellTags->"General::noval",
 CellLabel->"In[7]:=",
 CellID->28878]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::noval - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 5, 46.4268902}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::noval", "synonyms" -> {}, "title" -> 
    "General::noval", "type" -> "Message", "uri" -> "ref/message/noval"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2353, 94, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->580548964]},
 "General::noval"->{
  Cell[3159, 126, 173, 6, 70, "Input",
   CellTags->"General::noval",
   CellID->1570],
  Cell[3335, 134, 237, 6, 70, "Message",
   CellTags->"General::noval",
   CellID->631831015],
  Cell[3575, 142, 97, 3, 70, "Output",
   CellTags->"General::noval",
   CellID->635958],
  Cell[3843, 155, 189, 6, 70, "Input",
   CellTags->"General::noval",
   CellID->11296],
  Cell[4057, 165, 173, 6, 70, "Input",
   CellTags->"General::noval",
   CellID->4307],
  Cell[4233, 173, 237, 6, 70, "Message",
   CellTags->"General::noval",
   CellID->430445447],
  Cell[4473, 181, 100, 3, 70, "Output",
   CellTags->"General::noval",
   CellID->340370693],
  Cell[4762, 196, 187, 6, 70, "Input",
   CellTags->"General::noval",
   CellID->3865],
  Cell[4952, 204, 164, 5, 70, "Output",
   CellTags->"General::noval",
   CellID->363611614],
  Cell[5153, 214, 174, 6, 70, "Input",
   CellTags->"General::noval",
   CellID->10024],
  Cell[5330, 222, 100, 3, 70, "Output",
   CellTags->"General::noval",
   CellID->302582058],
  Cell[5467, 230, 99, 3, 70, "Input",
   CellTags->"General::noval",
   CellID->4399],
  Cell[5569, 235, 160, 5, 70, "Output",
   CellTags->"General::noval",
   CellID->12272847],
  Cell[5857, 250, 131, 4, 70, "Input",
   CellTags->"General::noval",
   CellID->28878]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6948, 282},
 {"General::noval", 7088, 286}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->7480],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 200, 5, 70, "Message",
 CellID->418237653],
Cell[1460, 56, 164, 4, 70, "Notes",
 CellID->10998],
Cell[1627, 62, 160, 4, 70, "Notes",
 CellID->27328],
Cell[1790, 68, 526, 21, 70, "Notes",
 CellID->31141]
}, Closed]],
Cell[CellGroupData[{
Cell[2353, 94, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->580548964],
Cell[CellGroupData[{
Cell[2738, 108, 148, 5, 70, "ExampleSection",
 CellID->374988065],
Cell[2889, 115, 245, 7, 70, "ExampleText",
 CellID->223515621],
Cell[CellGroupData[{
Cell[3159, 126, 173, 6, 70, "Input",
 CellTags->"General::noval",
 CellID->1570],
Cell[3335, 134, 237, 6, 70, "Message",
 CellTags->"General::noval",
 CellID->631831015],
Cell[3575, 142, 97, 3, 70, "Output",
 CellTags->"General::noval",
 CellID->635958]
}, Open  ]],
Cell[3687, 148, 153, 5, 70, "ExampleText",
 CellID->169440598],
Cell[3843, 155, 189, 6, 70, "Input",
 CellTags->"General::noval",
 CellID->11296],
Cell[CellGroupData[{
Cell[4057, 165, 173, 6, 70, "Input",
 CellTags->"General::noval",
 CellID->4307],
Cell[4233, 173, 237, 6, 70, "Message",
 CellTags->"General::noval",
 CellID->430445447],
Cell[4473, 181, 100, 3, 70, "Output",
 CellTags->"General::noval",
 CellID->340370693]
}, Open  ]],
Cell[4588, 187, 149, 5, 70, "ExampleText",
 CellID->89746601],
Cell[CellGroupData[{
Cell[4762, 196, 187, 6, 70, "Input",
 CellTags->"General::noval",
 CellID->3865],
Cell[4952, 204, 164, 5, 70, "Output",
 CellTags->"General::noval",
 CellID->363611614]
}, Open  ]],
Cell[CellGroupData[{
Cell[5153, 214, 174, 6, 70, "Input",
 CellTags->"General::noval",
 CellID->10024],
Cell[5330, 222, 100, 3, 70, "Output",
 CellTags->"General::noval",
 CellID->302582058]
}, Open  ]],
Cell[CellGroupData[{
Cell[5467, 230, 99, 3, 70, "Input",
 CellTags->"General::noval",
 CellID->4399],
Cell[5569, 235, 160, 5, 70, "Output",
 CellTags->"General::noval",
 CellID->12272847]
}, Open  ]],
Cell[5744, 243, 110, 5, 70, "ExampleText",
 CellID->225609589],
Cell[5857, 250, 131, 4, 70, "Input",
 CellTags->"General::noval",
 CellID->28878]
}, Open  ]]
}, Open  ]],
Cell[6015, 258, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

