(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6909,        261]
NotebookOptionsPosition[      4030,        165]
NotebookOutlinePosition[      5684,        216]
CellTagsIndexPosition[      5567,        210]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::npolys", "ObjectName",
 CellID->11627],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"npolys\"\>"}], ":", 
  " ", "\<\"`1` is not a list of polynomials with rational number \
coefficients.\"\>"}]], "Message", "MSG",
 CellID->258078170],

Cell["\<\
Generated when the polynomials shown in the message are expected to be \
polynomials with coefficients that are integers or rational numbers.\
\>", "Notes",
 CellID->16207],

Cell["\<\
The polynomials reported in the message will sometimes be derived in a \
non-trivial way from the input.\
\>", "Notes",
 CellID->28349]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->666391771],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->732384790],

Cell["\<\
An error occurs in this example because one of the coefficients in the input \
is not a rational number.\
\>", "ExampleText",
 CellID->358812550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"Sqrt", "[", "2", "]"}]}], ",", 
   RowBox[{"Modulus", "->", "x"}]}], "]"}]], "Input",
 CellTags->"General::npolys",
 CellLabel->"In[1]:=",
 CellID->389],

Cell[BoxData[
 RowBox[{
  RowBox[{"Factor", "::", "\<\"npolys\"\>"}], ":", 
  " ", "\<\"\\!\\({\\(\\(\\@2 + \\(\\(3\\\\ y\\)\\)\\)\\), x}\\) is not a \
list of polynomials with rational number coefficients.\"\>"}]], "Message", \
"MSG",
 CellTags->"General::npolys",
 CellID->272284665],

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    SqrtBox["2"], "+", 
    RowBox[{"3", " ", "y"}]}], ",", 
   RowBox[{"Modulus", "\[Rule]", "x"}]}], "]"}]], "Output",
 CellTags->"General::npolys",
 CellLabel->"Out[1]=",
 CellID->252021434]
}, Open  ]],

Cell[TextData[{
 "This shows valid input in ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->194450128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", " ", "y"}], "+", "x"}], ",", 
   RowBox[{"Modulus", "->", "  ", "x"}]}], "]"}]], "Input",
 CellTags->"General::npolys",
 CellLabel->"In[2]:=",
 CellID->7530],

Cell[BoxData[
 RowBox[{"3", " ", "y"}]], "Output",
 CellTags->"General::npolys",
 CellLabel->"Out[2]=",
 CellID->36755258]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::npolys - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 5, 46.8487760}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::npolys", "synonyms" -> {}, "title" -> 
    "General::npolys", "type" -> "Message", "uri" -> "ref/message/npolys"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1834, 71, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->666391771]},
 "General::npolys"->{
  Cell[2550, 100, 262, 9, 70, "Input",
   CellTags->"General::npolys",
   CellID->389],
  Cell[2815, 111, 285, 7, 70, "Message",
   CellTags->"General::npolys",
   CellID->272284665],
  Cell[3103, 120, 255, 9, 70, "Output",
   CellTags->"General::npolys",
   CellID->252021434],
  Cell[3603, 144, 236, 8, 70, "Input",
   CellTags->"General::npolys",
   CellID->7530],
  Cell[3842, 154, 122, 4, 70, "Output",
   CellTags->"General::npolys",
   CellID->36755258]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4940, 187},
 {"General::npolys", 5081, 191}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 1, 70, "ObjectName",
 CellID->11627],
Cell[CellGroupData[{
Cell[781, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 49, 205, 5, 70, "Message",
 CellID->258078170],
Cell[1467, 56, 182, 4, 70, "Notes",
 CellID->16207],
Cell[1652, 62, 145, 4, 70, "Notes",
 CellID->28349]
}, Closed]],
Cell[CellGroupData[{
Cell[1834, 71, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->666391771],
Cell[CellGroupData[{
Cell[2219, 85, 148, 5, 70, "ExampleSection",
 CellID->732384790],
Cell[2370, 92, 155, 4, 70, "ExampleText",
 CellID->358812550],
Cell[CellGroupData[{
Cell[2550, 100, 262, 9, 70, "Input",
 CellTags->"General::npolys",
 CellID->389],
Cell[2815, 111, 285, 7, 70, "Message",
 CellTags->"General::npolys",
 CellID->272284665],
Cell[3103, 120, 255, 9, 70, "Output",
 CellTags->"General::npolys",
 CellID->252021434]
}, Open  ]],
Cell[3373, 132, 205, 8, 70, "ExampleText",
 CellID->194450128],
Cell[CellGroupData[{
Cell[3603, 144, 236, 8, 70, "Input",
 CellTags->"General::npolys",
 CellID->7530],
Cell[3842, 154, 122, 4, 70, "Output",
 CellTags->"General::npolys",
 CellID->36755258]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4003, 163, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

