(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7473,        279]
NotebookOptionsPosition[      4665,        185]
NotebookOutlinePosition[      6305,        236]
CellTagsIndexPosition[      6190,        230]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::nsgn", "ObjectName",
 CellID->2719],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"nsgn\"\>"}], ":", 
  " ", "\<\"Value for option NumberSigns -> `1` should be a pair of strings \
or two pairs of strings.\"\>"}]], "Message", "MSG",
 CellID->553963345],

Cell[TextData[{
 "Generated when the value of the ",
 Cell[BoxData[
  ButtonBox["NumberSigns",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberSigns"]], "InlineFormula"],
 " option is not a list of two strings or a list of two such lists."
}], "Notes",
 CellID->14270]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->161622214],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->360051997],

Cell[TextData[{
 "An error occurs in this example because the value of the ",
 Cell[BoxData[
  ButtonBox["NumberSigns",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberSigns"]], "InlineFormula"],
 " option is a pair of symbols rather than a pair of strings."
}], "ExampleText",
 CellID->87526508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "23.1"}], ",", "67.8"}], "}"}], ",", 
   RowBox[{"NumberSigns", "->", 
    RowBox[{"{", 
     RowBox[{"Negative", ",", "Positive"}], "}"}]}]}], "]"}]], "Input",
 CellTags->"General::nsgn",
 CellLabel->"In[1]:=",
 CellID->14473],

Cell[BoxData[
 RowBox[{
  RowBox[{"NumberForm", "::", "\<\"nsgn\"\>"}], ":", 
  " ", "\<\"Value for option NumberSigns -> \\!\\({Negative, Positive}\\) \
should be a pair of strings or two pairs of strings.\"\>"}]], "Message", \
"MSG",
 CellTags->"General::nsgn",
 CellID->453050240],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox["\<\"-23.1\"\>",
     -23.1,
     AutoDelete->True], ",", 
    InterpretationBox["\<\"67.8\"\>",
     67.8,
     AutoDelete->True]}], "}"}],
  NumberForm[#, NumberSigns -> {Negative, Positive}]& ]], "Output",
 CellTags->"General::nsgn",
 CellLabel->"Out[1]//NumberForm=",
 CellID->203090202]
}, Open  ]],

Cell[TextData[{
 "This shows a valid value for the ",
 Cell[BoxData[
  ButtonBox["NumberSigns",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberSigns"]], "InlineFormula"],
 " option."
}], "ExampleText",
 CellID->477887455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "23.1"}], ",", "67.8"}], "}"}], ",", 
   RowBox[{"NumberSigns", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<-\>\"", ",", "\"\<+\>\""}], "}"}]}]}], "]"}]], "Input",
 CellTags->"General::nsgn",
 CellLabel->"In[2]:=",
 CellID->22570],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox["\<\"-23.1\"\>",
     -23.1,
     AutoDelete->True], ",", 
    InterpretationBox["\<\"+67.8\"\>",
     67.8,
     AutoDelete->True]}], "}"}],
  NumberForm[#, NumberSigns -> {"-", "+"}]& ]], "Output",
 CellTags->"General::nsgn",
 CellLabel->"Out[2]//NumberForm=",
 CellID->224903232]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::nsgn - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 5, 54.3020918}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::nsgn", "synonyms" -> {}, "title" -> 
    "General::nsgn", "type" -> "Message", "uri" -> "ref/message/nsgn"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1795, 69, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->161622214]},
 "General::nsgn"->{
  Cell[2659, 102, 329, 11, 70, "Input",
   CellTags->"General::nsgn",
   CellID->14473],
  Cell[2991, 115, 283, 7, 70, "Message",
   CellTags->"General::nsgn",
   CellID->453050240],
  Cell[3277, 124, 364, 13, 70, "Output",
   CellTags->"General::nsgn",
   CellID->203090202],
  Cell[3910, 152, 331, 11, 70, "Input",
   CellTags->"General::nsgn",
   CellID->22570],
  Cell[4244, 165, 355, 13, 70, "Output",
   CellTags->"General::nsgn",
   CellID->224903232]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5567, 207},
 {"General::nsgn", 5706, 211}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 50, 1, 70, "ObjectName",
 CellID->2719],
Cell[CellGroupData[{
Cell[778, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1256, 49, 224, 5, 70, "Message",
 CellID->553963345],
Cell[1483, 56, 275, 8, 70, "Notes",
 CellID->14270]
}, Closed]],
Cell[CellGroupData[{
Cell[1795, 69, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->161622214],
Cell[CellGroupData[{
Cell[2180, 83, 148, 5, 70, "ExampleSection",
 CellID->360051997],
Cell[2331, 90, 303, 8, 70, "ExampleText",
 CellID->87526508],
Cell[CellGroupData[{
Cell[2659, 102, 329, 11, 70, "Input",
 CellTags->"General::nsgn",
 CellID->14473],
Cell[2991, 115, 283, 7, 70, "Message",
 CellTags->"General::nsgn",
 CellID->453050240],
Cell[3277, 124, 364, 13, 70, "Output",
 CellTags->"General::nsgn",
 CellID->203090202]
}, Open  ]],
Cell[3656, 140, 229, 8, 70, "ExampleText",
 CellID->477887455],
Cell[CellGroupData[{
Cell[3910, 152, 331, 11, 70, "Input",
 CellTags->"General::nsgn",
 CellID->22570],
Cell[4244, 165, 355, 13, 70, "Output",
 CellTags->"General::nsgn",
 CellID->224903232]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4638, 183, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

