(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7971,        295]
NotebookOptionsPosition[      5086,        199]
NotebookOutlinePosition[      6742,        250]
CellTagsIndexPosition[      6625,        244]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::precbd", "ObjectName",
 CellID->2702],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"precbd\"\>"}], ":", 
  " ", "\<\"Requested precision `1` is not a machine-sized real number \
between $MinPrecision and $MaxPrecision.\"\>"}]], "Message", "MSG",
 CellID->212453444],

Cell["\<\
Generated when the indicated expression is expected to  be a real number in \
the indicated range.\
\>", "Notes",
 CellID->4825],

Cell[TextData[{
 "You can change  the values of ",
 Cell[BoxData[
  ButtonBox["$MinPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MinPrecision"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$MaxPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxPrecision"]], "InlineFormula"],
 " for calculations that require precision outside of this range."
}], "Notes",
 CellID->30333]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->133211610],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->184549631],

Cell[TextData[{
 "An error occurs in this example because ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " is not a valid value for the ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " option in ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->103090312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "==", "3"}], ",", "x", ",", 
   RowBox[{"WorkingPrecision", "->", "Automatic"}]}], "]"}]], "Input",
 CellTags->"General::precbd",
 CellLabel->"In[1]:=",
 CellID->996],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"precbd\"\>"}], ":", 
  " ", "\<\"Requested precision \\!\\(Automatic\\) is not a machine-sized \
real number between $MinPrecision and $MaxPrecision.\"\>"}]], "Message", \
"MSG",
 CellTags->"General::precbd",
 CellID->119927982],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "\[Equal]", "3"}], ",", "x", ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "Automatic"}]}], "]"}]], "Output",
 CellTags->"General::precbd",
 CellLabel->"Out[1]=",
 CellID->342147902]
}, Open  ]],

Cell[TextData[{
 "This shows a valid value for the ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " option in ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->406846567],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "==", "3"}], ",", "x", ",", 
   RowBox[{"WorkingPrecision", "->", "25"}]}], "]"}]], "Input",
 CellTags->"General::precbd",
 CellLabel->"In[2]:=",
 CellID->4049],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1.73205080756887729352744634150587236694`25."}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.73205080756887729352744634150587236694`25."}], 
    "}"}]}], "}"}]], "Output",
 CellTags->"General::precbd",
 CellLabel->"Out[2]=",
 CellID->685512285]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::precbd - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 6, 18.7870936}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::precbd", "synonyms" -> {}, "title" -> 
    "General::precbd", "type" -> "Message", "uri" -> "ref/message/precbd"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2090, 80, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->133211610]},
 "General::precbd"->{
  Cell[3175, 123, 256, 8, 70, "Input",
   CellTags->"General::precbd",
   CellID->996],
  Cell[3434, 133, 282, 7, 70, "Message",
   CellTags->"General::precbd",
   CellID->119927982],
  Cell[3719, 142, 275, 8, 70, "Output",
   CellTags->"General::precbd",
   CellID->342147902],
  Cell[4395, 170, 250, 8, 70, "Input",
   CellTags->"General::precbd",
   CellID->4049],
  Cell[4648, 180, 372, 12, 70, "Output",
   CellTags->"General::precbd",
   CellID->685512285]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5996, 221},
 {"General::precbd", 6137, 225}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->2702],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 237, 5, 70, "Message",
 CellID->212453444],
Cell[1498, 56, 138, 4, 70, "Notes",
 CellID->4825],
Cell[1639, 62, 414, 13, 70, "Notes",
 CellID->30333]
}, Closed]],
Cell[CellGroupData[{
Cell[2090, 80, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->133211610],
Cell[CellGroupData[{
Cell[2475, 94, 148, 5, 70, "ExampleSection",
 CellID->184549631],
Cell[2626, 101, 524, 18, 70, "ExampleText",
 CellID->103090312],
Cell[CellGroupData[{
Cell[3175, 123, 256, 8, 70, "Input",
 CellTags->"General::precbd",
 CellID->996],
Cell[3434, 133, 282, 7, 70, "Message",
 CellTags->"General::precbd",
 CellID->119927982],
Cell[3719, 142, 275, 8, 70, "Output",
 CellTags->"General::precbd",
 CellID->342147902]
}, Open  ]],
Cell[4009, 153, 361, 13, 70, "ExampleText",
 CellID->406846567],
Cell[CellGroupData[{
Cell[4395, 170, 250, 8, 70, "Input",
 CellTags->"General::precbd",
 CellID->4049],
Cell[4648, 180, 372, 12, 70, "Output",
 CellTags->"General::precbd",
 CellID->685512285]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5059, 197, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

