(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8067,        292]
NotebookOptionsPosition[      5075,        192]
NotebookOutlinePosition[      6732,        243]
CellTagsIndexPosition[      6615,        237]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::precsm", "ObjectName",
 CellID->12088],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"precsm\"\>"}], ":", 
  " ", "\<\"Requested precision `1` is smaller than $MinPrecision. Using \
$MinPrecision instead.\"\>"}]], "Message", "MSG",
 CellID->424304793],

Cell[TextData[{
 "Generated when a requested value of precision is less  than the value of ",
 Cell[BoxData[
  ButtonBox["$MinPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MinPrecision"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->8533],

Cell[TextData[{
 "You can lower the value of ",
 Cell[BoxData[
  ButtonBox["$MinPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MinPrecision"]], "InlineFormula"],
 " if necessary."
}], "Notes",
 CellID->12353],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the accuracy of a number is the number of known digits to the right of  \
the decimal point, the precision is the total number of significant digits,  \
the scale is the number of digits to the left of the decimal point, and the  \
precision is the sum of the scale and the accuracy."
}], "Notes",
 CellID->24802],

Cell[TextData[{
 " This is a warning message to indicate that the value of ",
 Cell[BoxData[
  ButtonBox["$MinPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MinPrecision"]], "InlineFormula"],
 " has been exceeded.  This warning message does not necessarily indicate an  \
error."
}], "Notes",
 CellID->25475]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->23169877],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->777620646],

Cell[TextData[{
 "An error occurs in this example because the precision specified in ",
 Cell[BoxData[
  ButtonBox["SetPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetPrecision"]], "InlineFormula"],
 " is less than the value of ",
 Cell[BoxData[
  ButtonBox["$MinPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MinPrecision"]], "InlineFormula"],
 " when this expression is evaluated."
}], "ExampleText",
 CellID->872638751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MinPrecision", "=", "50"}], "}"}], ",", 
   RowBox[{"SetPrecision", "[", 
    RowBox[{"Pi", ",", "25"}], "]"}]}], "]"}]], "Input",
 CellTags->"General::precsm",
 CellLabel->"In[1]:=",
 CellID->2802],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetPrecision", "::", "\<\"precsm\"\>"}], ":", 
  " ", "\<\"Requested precision \\!\\(25\\) is smaller than $MinPrecision. \
Using $MinPrecision instead.\"\>"}]], "Message", "MSG",
 CellTags->"General::precsm",
 CellID->124551427],

Cell[BoxData["3.\
1415926535897932384626433832795028841971693993751058209849474090732`50."], \
"Output",
 CellTags->"General::precsm",
 CellLabel->"Out[1]=",
 CellID->732020532]
}, Open  ]],

Cell["This shows valid precision specifications.", "ExampleText",
 CellID->103406281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MinPrecision", "=", "25"}], "}"}], ",", 
   RowBox[{"SetPrecision", "[", 
    RowBox[{"Pi", ",", "25"}], "]"}]}], "]"}]], "Input",
 CellTags->"General::precsm",
 CellLabel->"In[2]:=",
 CellID->12778],

Cell[BoxData["3.14159265358979323846264338358735068483`25."], "Output",
 CellTags->"General::precsm",
 CellLabel->"Out[2]=",
 CellID->145113421]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::precsm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 6, 19.1777286}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::precsm", "synonyms" -> {}, "title" -> 
    "General::precsm", "type" -> "Message", "uri" -> "ref/message/precsm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2720, 101, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->23169877]},
 "General::precsm"->{
  Cell[3733, 139, 278, 9, 70, "Input",
   CellTags->"General::precsm",
   CellID->2802],
  Cell[4014, 150, 264, 6, 70, "Message",
   CellTags->"General::precsm",
   CellID->124551427],
  Cell[4281, 158, 177, 5, 70, "Output",
   CellTags->"General::precsm",
   CellID->732020532],
  Cell[4583, 171, 279, 9, 70, "Input",
   CellTags->"General::precsm",
   CellID->12778],
  Cell[4865, 182, 144, 3, 70, "Output",
   CellTags->"General::precsm",
   CellID->145113421]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5985, 214},
 {"General::precsm", 6126, 218}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 1, 70, "ObjectName",
 CellID->12088],
Cell[CellGroupData[{
Cell[781, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 49, 221, 5, 70, "Message",
 CellID->424304793],
Cell[1483, 56, 255, 8, 70, "Notes",
 CellID->8533],
Cell[1741, 66, 223, 8, 70, "Notes",
 CellID->12353],
Cell[1967, 76, 390, 9, 70, "Notes",
 CellID->24802],
Cell[2360, 87, 323, 9, 70, "Notes",
 CellID->25475]
}, Closed]],
Cell[CellGroupData[{
Cell[2720, 101, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->23169877],
Cell[CellGroupData[{
Cell[3104, 115, 148, 5, 70, "ExampleSection",
 CellID->777620646],
Cell[3255, 122, 453, 13, 70, "ExampleText",
 CellID->872638751],
Cell[CellGroupData[{
Cell[3733, 139, 278, 9, 70, "Input",
 CellTags->"General::precsm",
 CellID->2802],
Cell[4014, 150, 264, 6, 70, "Message",
 CellTags->"General::precsm",
 CellID->124551427],
Cell[4281, 158, 177, 5, 70, "Output",
 CellTags->"General::precsm",
 CellID->732020532]
}, Open  ]],
Cell[4473, 166, 85, 1, 70, "ExampleText",
 CellID->103406281],
Cell[CellGroupData[{
Cell[4583, 171, 279, 9, 70, "Input",
 CellTags->"General::precsm",
 CellID->12778],
Cell[4865, 182, 144, 3, 70, "Output",
 CellTags->"General::precsm",
 CellID->145113421]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5048, 190, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

