(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6783,        263]
NotebookOptionsPosition[      3934,        167]
NotebookOutlinePosition[      5567,        218]
CellTagsIndexPosition[      5452,        212]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::rnum", "ObjectName",
 CellID->32090],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"rnum\"\>"}], ":", 
  " ", "\<\"`1` is not a valid root number.\"\>"}]], "Message", "MSG",
 CellID->158436233],

Cell["\<\
Generated when an expression other than a positive  integer is encountered \
where a root number is expected.\
\>", "Notes",
 CellID->6157],

Cell[TextData[{
 " This message can be generated by functions that use root numbers, such as \
",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["FundamentalUnits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldFundamentalUnits"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->24891]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->175683304],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->73814881],

Cell["\<\
An error occurs in this example because zero is not a valid root number.\
\>", "ExampleText",
 CellID->580251619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "2"}], ",", "0"}], "]"}]], "Input",
 CellTags->"General::rnum",
 CellLabel->"In[1]:=",
 CellID->29171],

Cell[BoxData[
 RowBox[{
  RowBox[{"Root", "::", "\<\"rnum\"\>"}], ":", 
  " ", "\<\"\\!\\(0\\) is not a valid root number.\"\>"}]], "Message", "MSG",
 CellTags->"General::rnum",
 CellID->351745785],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    SuperscriptBox["x", "2"]}], ",", "0"}], "]"}]], "Output",
 CellTags->"General::rnum",
 CellLabel->"Out[1]=",
 CellID->1332021]
}, Open  ]],

Cell[TextData[{
 "This shows valid arguments in ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->135832663],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "2"}], ",", "2"}], "]"}]], "Input",
 CellTags->"General::rnum",
 CellLabel->"In[2]:=",
 CellID->6729],

Cell[BoxData[
 SqrtBox["2"]], "Output",
 CellTags->"General::rnum",
 CellLabel->"Out[2]=",
 CellID->419995890]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::rnum - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 6, 42.4126984}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::rnum", "synonyms" -> {}, "title" -> 
    "General::rnum", "type" -> "Message", "uri" -> "ref/message/rnum"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2013, 80, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->175683304]},
 "General::rnum"->{
  Cell[2696, 108, 196, 7, 70, "Input",
   CellTags->"General::rnum",
   CellID->29171],
  Cell[2895, 117, 197, 5, 70, "Message",
   CellTags->"General::rnum",
   CellID->351745785],
  Cell[3095, 124, 220, 8, 70, "Output",
   CellTags->"General::rnum",
   CellID->1332021],
  Cell[3560, 147, 195, 7, 70, "Input",
   CellTags->"General::rnum",
   CellID->6729],
  Cell[3758, 156, 110, 4, 70, "Output",
   CellTags->"General::rnum",
   CellID->419995890]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4836, 189},
 {"General::rnum", 4975, 193}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->32090],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 165, 4, 70, "Message",
 CellID->158436233],
Cell[1425, 55, 149, 4, 70, "Notes",
 CellID->6157],
Cell[1577, 61, 399, 14, 70, "Notes",
 CellID->24891]
}, Closed]],
Cell[CellGroupData[{
Cell[2013, 80, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->175683304],
Cell[CellGroupData[{
Cell[2398, 94, 147, 5, 70, "ExampleSection",
 CellID->73814881],
Cell[2548, 101, 123, 3, 70, "ExampleText",
 CellID->580251619],
Cell[CellGroupData[{
Cell[2696, 108, 196, 7, 70, "Input",
 CellTags->"General::rnum",
 CellID->29171],
Cell[2895, 117, 197, 5, 70, "Message",
 CellTags->"General::rnum",
 CellID->351745785],
Cell[3095, 124, 220, 8, 70, "Output",
 CellTags->"General::rnum",
 CellID->1332021]
}, Open  ]],
Cell[3330, 135, 205, 8, 70, "ExampleText",
 CellID->135832663],
Cell[CellGroupData[{
Cell[3560, 147, 195, 7, 70, "Input",
 CellTags->"General::rnum",
 CellID->6729],
Cell[3758, 156, 110, 4, 70, "Output",
 CellTags->"General::rnum",
 CellID->419995890]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[3907, 165, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

