(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9015,        332]
NotebookOptionsPosition[      5571,        216]
NotebookOutlinePosition[      7480,        276]
CellTagsIndexPosition[      7364,        270]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::strmi", "ObjectName",
 CellID->32100],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"strmi\"\>"}], ":", 
  " ", "\<\"First argument in `1` is not a valid file or string identifier.\"\
\>"}]], "Message", "MSG",
 CellID->174345468],

Cell[TextData[{
 "Generated when the first argument in ",
 Cell[BoxData[
  ButtonBox["InputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputStream"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["OutputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputStream"]], "InlineFormula"],
 " is neither a string representing the name of a file nor an identifier for  \
a string that is used as a stream."
}], "Notes",
 CellID->17752],

Cell[TextData[{
 "This message is  normally seen only when attempting to enter ",
 Cell[BoxData[
  ButtonBox["InputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputStream"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["OutputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputStream"]], "InlineFormula"],
 " expressions explicitly, rather than using the expressions that have been  \
generated by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Notes",
 CellID->29429]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20799848],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->448233279],

Cell[TextData[{
 "An error occurs in this example because the first argument in ",
 Cell[BoxData[
  ButtonBox["OutputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputStream"]], "InlineFormula"],
 " is not a string."
}], "ExampleText",
 CellID->212029537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"strm", "=", 
  RowBox[{"OpenWrite", "[", "\"\<TEST\>\"", "]"}]}]], "Input",
 CellTags->"General::strmi",
 CellLabel->"In[1]:=",
 CellID->15819],

Cell[BoxData[
 RowBox[{"OutputStream", "[", 
  RowBox[{"\<\"TEST\"\>", ",", "305"}], "]"}]], "Output",
 CellTags->"General::strmi",
 CellLabel->"Out[1]=",
 CellID->230117429]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Write", "[", 
  RowBox[{
   RowBox[{"OutputStream", "[", 
    RowBox[{"TEST", ",", "3"}], "]"}], ",", 
   RowBox[{"OutputForm", "[", "\"\<output to file\>\"", "]"}]}], 
  "]"}]], "Input",
 CellTags->"General::strmi",
 CellLabel->"In[2]:=",
 CellID->7362],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"strmi\"\>"}], ":", 
  " ", "\<\"First argument in \\!\\(OutputStream[\\(\\(TEST, 3\\)\\)]\\) is \
not a valid file or string identifier.\"\>"}]], "Message", "MSG",
 CellTags->"General::strmi",
 CellID->29571518],

Cell[BoxData[
 RowBox[{
  RowBox[{"Write", "::", "\<\"noopen\"\>"}], ":", 
  " ", "\<\"Cannot open \\!\\(OutputStream[\\(\\(TEST, 3\\)\\)]\\).\"\>"}]], \
"Message", "MSG",
 CellTags->"General::strmi",
 CellID->30743691]
}, Open  ]],

Cell[TextData[{
 "Output can be written to the open stream by giving the name of the file or  \
by using the corresponding ",
 Cell[BoxData[
  ButtonBox["OutputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputStream"]], "InlineFormula"],
 " expression."
}], "ExampleText",
 CellID->58720299],

Cell[BoxData[
 RowBox[{"Write", "[", 
  RowBox[{"strm", ",", 
   RowBox[{"OutputForm", "[", "\"\<output to file\>\"", "]"}]}], 
  "]"}]], "Input",
 CellTags->"General::strmi",
 CellLabel->"In[3]:=",
 CellID->31916],

Cell[BoxData[
 RowBox[{"Write", "[", 
  RowBox[{"\"\<TEST\>\"", ",", 
   RowBox[{"OutputForm", "[", "\"\<more output to file\>\"", "]"}]}], 
  "]"}]], "Input",
 CellTags->"General::strmi",
 CellLabel->"In[4]:=",
 CellID->27155],

Cell["Close the stream and delete the file.", "ExampleText",
 CellID->850100897],

Cell[BoxData[
 RowBox[{
  RowBox[{"Close", "[", "strm", "]"}], ";", 
  RowBox[{"DeleteFile", "[", "\"\<TEST\>\"", "]"}]}]], "Input",
 CellTags->"General::strmi",
 CellLabel->"In[5]:=",
 CellID->8863]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::strmi - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 7, 6.3195604}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::strmi", "synonyms" -> {}, "title" -> 
    "General::strmi", "type" -> "Message", "uri" -> "ref/message/strmi"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2484, 94, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->20799848]},
 "General::strmi"->{
  Cell[3313, 127, 167, 5, 70, "Input",
   CellTags->"General::strmi",
   CellID->15819],
  Cell[3483, 134, 174, 5, 70, "Output",
   CellTags->"General::strmi",
   CellID->230117429],
  Cell[3694, 144, 278, 9, 70, "Input",
   CellTags->"General::strmi",
   CellID->7362],
  Cell[3975, 155, 267, 6, 70, "Message",
   CellTags->"General::strmi",
   CellID->29571518],
  Cell[4245, 163, 219, 6, 70, "Message",
   CellTags->"General::strmi",
   CellID->30743691],
  Cell[4788, 183, 214, 7, 70, "Input",
   CellTags->"General::strmi",
   CellID->31916],
  Cell[5005, 192, 227, 7, 70, "Input",
   CellTags->"General::strmi",
   CellID->27155],
  Cell[5318, 204, 199, 6, 70, "Input",
   CellTags->"General::strmi",
   CellID->8863]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6476, 238},
 {"General::strmi", 6615, 242}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->32100],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 200, 5, 70, "Message",
 CellID->174345468],
Cell[1461, 56, 463, 14, 70, "Notes",
 CellID->17752],
Cell[1927, 72, 520, 17, 70, "Notes",
 CellID->29429]
}, Closed]],
Cell[CellGroupData[{
Cell[2484, 94, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20799848],
Cell[CellGroupData[{
Cell[2868, 108, 148, 5, 70, "ExampleSection",
 CellID->448233279],
Cell[3019, 115, 269, 8, 70, "ExampleText",
 CellID->212029537],
Cell[CellGroupData[{
Cell[3313, 127, 167, 5, 70, "Input",
 CellTags->"General::strmi",
 CellID->15819],
Cell[3483, 134, 174, 5, 70, "Output",
 CellTags->"General::strmi",
 CellID->230117429]
}, Open  ]],
Cell[CellGroupData[{
Cell[3694, 144, 278, 9, 70, "Input",
 CellTags->"General::strmi",
 CellID->7362],
Cell[3975, 155, 267, 6, 70, "Message",
 CellTags->"General::strmi",
 CellID->29571518],
Cell[4245, 163, 219, 6, 70, "Message",
 CellTags->"General::strmi",
 CellID->30743691]
}, Open  ]],
Cell[4479, 172, 306, 9, 70, "ExampleText",
 CellID->58720299],
Cell[4788, 183, 214, 7, 70, "Input",
 CellTags->"General::strmi",
 CellID->31916],
Cell[5005, 192, 227, 7, 70, "Input",
 CellTags->"General::strmi",
 CellID->27155],
Cell[5235, 201, 80, 1, 70, "ExampleText",
 CellID->850100897],
Cell[5318, 204, 199, 6, 70, "Input",
 CellTags->"General::strmi",
 CellID->8863]
}, Open  ]]
}, Open  ]],
Cell[5544, 214, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

