(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12269,        456]
NotebookOptionsPosition[      7633,        298]
NotebookOutlinePosition[     10019,        373]
CellTagsIndexPosition[      9903,        367]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::strmn", "ObjectName",
 CellID->30266],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"strmn\"\>"}], ":", 
  " ", "\<\"Requested stream `1` does not match existing stream `2` with the \
same stream number.\"\>"}]], "Message", "MSG",
 CellID->131948018],

Cell["\<\
Generated when a duplicate stream number is  encountered during input or \
output.\
\>", "Notes",
 CellID->15802],

Cell["\<\
Streams are  assigned a unique number when they are opened.  An error occurs \
if the same  number is used with a different stream.\
\>", "Notes",
 CellID->31355],

Cell[TextData[{
 "This error can  occur when entering ",
 Cell[BoxData[
  ButtonBox["InputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputStream"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["OutputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputStream"]], "InlineFormula"],
 " expressions."
}], "Notes",
 CellID->3370],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["InputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputStream"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["OutputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputStream"]], "InlineFormula"],
 " expressions returned by functions such as ",
 Cell[BoxData[
  ButtonBox["OpenAppend",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenAppend"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["OpenRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenRead"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["OpenWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenWrite",
   ButtonNote->"ObsLink: OpenTemporary -> OpenWrite"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["OpenWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenWrite"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["StringToStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringToStream"]], "InlineFormula"],
 " are generally valid and should be used whenever practical, rather than  \
entering a new ",
 Cell[BoxData[
  ButtonBox["InputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputStream"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["OutputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputStream"]], "InlineFormula"],
 " expression."
}], "Notes",
 CellID->16953]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->2093869],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->595134819],

Cell[TextData[{
 "Open a stream to a string.  The stream number is the second element in the  \
resulting ",
 Cell[BoxData[
  ButtonBox["InputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputStream"]], "InlineFormula"],
 " expression."
}], "ExampleText",
 CellID->191152648],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", " ", "=", " ", 
  RowBox[{"StringToStream", "[", "\"\<abcdefg\>\"", "]"}]}]], "Input",
 CellTags->"General::strmn",
 CellLabel->"In[1]:=",
 CellID->16213],

Cell[BoxData[
 RowBox[{"InputStream", "[", 
  RowBox[{"String", ",", "26"}], "]"}]], "Output",
 CellTags->"General::strmn",
 CellLabel->"Out[1]=",
 CellID->18857892]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellTags->"General::strmn",
 CellLabel->"In[2]:=",
 CellID->924],

Cell[BoxData["26"], "Output",
 CellTags->"General::strmn",
 CellLabel->"Out[2]=",
 CellID->135466026]
}, Open  ]],

Cell["\<\
Attempting to read from a stream with the same number but with a different \
name will generate an error.\
\>", "ExampleText",
 CellID->35156100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{
   RowBox[{"InputStream", "[", 
    RowBox[{"\"\<file\>\"", ",", 
     RowBox[{"s", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ",", "Character"}], 
  "]"}]], "Input",
 CellTags->"General::strmn",
 CellLabel->"In[3]:=",
 CellID->18860],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"strmn\"\>"}], ":", 
  " ", "\<\"Requested stream \\!\\(InputStream[\\(\\(\\\"file\\\", \
26\\)\\)]\\) does not match existing stream RowBox[{\\\"{\\\", \
RowBox[{\\\\(System`Private`StringTurnedIntoStream[\\\"abcdefg\\\"]\\\\), \
\\\",\\\", \\\\({}\\\\), \\\",\\\", 0}], \\\"}\\\"}] with the same stream \
number.\"\>"}]], "Message", "MSG",
 CellTags->"General::strmn",
 CellID->519543814],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"openx\"\>"}], ":", 
  " ", "\<\"\\!\\(InputStream[\\(\\(\\\"file\\\", 26\\)\\)]\\) is not open.\"\
\>"}]], "Message", "MSG",
 CellTags->"General::strmn",
 CellID->395267765],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReadList", "::", "\<\"nffil\"\>"}], ":", 
  " ", "\<\"File not found during \
\\!\\(ReadList[\\(\\(\\(\\(InputStream[\\(\\(\\\"file\\\", 26\\)\\)]\\)\\), \
Character\\)\\)]\\).\"\>"}]], "Message", "MSG",
 CellTags->"General::strmn",
 CellID->160550178],

Cell[BoxData["$Failed"], "Output",
 CellTags->"General::strmn",
 CellLabel->"Out[3]=",
 CellID->512340739]
}, Open  ]],

Cell["This shows a correct way to read from this stream.", "ExampleText",
 CellID->438016368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"s", ",", " ", "Character"}], "]"}]], "Input",
 CellTags->"General::strmn",
 CellLabel->"In[4]:=",
 CellID->811701038],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>", 
   ",", "\<\"e\"\>", ",", "\<\"f\"\>", ",", "\<\"g\"\>"}], "}"}]], "Output",
 CellTags->"General::strmn",
 CellLabel->"Out[4]=",
 CellID->241391895]
}, Open  ]],

Cell["Close the stream.", "ExampleText",
 CellID->179638787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "s", "]"}]], "Input",
 CellTags->"General::strmn",
 CellLabel->"In[5]:=",
 CellID->29896],

Cell[BoxData["String"], "Output",
 CellTags->"General::strmn",
 CellLabel->"Out[5]=",
 CellID->305429683]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::strmn - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 7, 6.6476938}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::strmn", "synonyms" -> {}, "title" -> 
    "General::strmn", "type" -> "Message", "uri" -> "ref/message/strmn"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3622, 138, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->2093869]},
 "General::strmn"->{
  Cell[4469, 172, 182, 5, 70, "Input",
   CellTags->"General::strmn",
   CellID->16213],
  Cell[4654, 179, 165, 5, 70, "Output",
   CellTags->"General::strmn",
   CellID->18857892],
  Cell[4856, 189, 143, 5, 70, "Input",
   CellTags->"General::strmn",
   CellID->924],
  Cell[5002, 196, 101, 3, 70, "Output",
   CellTags->"General::strmn",
   CellID->135466026],
  Cell[5298, 210, 296, 10, 70, "Input",
   CellTags->"General::strmn",
   CellID->18860],
  Cell[5597, 222, 445, 9, 70, "Message",
   CellTags->"General::strmn",
   CellID->519543814],
  Cell[6045, 233, 229, 6, 70, "Message",
   CellTags->"General::strmn",
   CellID->395267765],
  Cell[6277, 241, 287, 7, 70, "Message",
   CellTags->"General::strmn",
   CellID->160550178],
  Cell[6567, 250, 106, 3, 70, "Output",
   CellTags->"General::strmn",
   CellID->512340739],
  Cell[6806, 261, 169, 5, 70, "Input",
   CellTags->"General::strmn",
   CellID->811701038],
  Cell[6978, 268, 255, 6, 70, "Output",
   CellTags->"General::strmn",
   CellID->241391895],
  Cell[7333, 282, 126, 4, 70, "Input",
   CellTags->"General::strmn",
   CellID->29896],
  Cell[7462, 288, 105, 3, 70, "Output",
   CellTags->"General::strmn",
   CellID->305429683]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8538, 320},
 {"General::strmn", 8677, 324}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->30266],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 221, 5, 70, "Message",
 CellID->131948018],
Cell[1482, 56, 123, 4, 70, "Notes",
 CellID->15802],
Cell[1608, 62, 172, 4, 70, "Notes",
 CellID->31355],
Cell[1783, 68, 363, 13, 70, "Notes",
 CellID->3370],
Cell[2149, 83, 1436, 50, 70, "Notes",
 CellID->16953]
}, Closed]],
Cell[CellGroupData[{
Cell[3622, 138, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->2093869],
Cell[CellGroupData[{
Cell[4005, 152, 148, 5, 70, "ExampleSection",
 CellID->595134819],
Cell[4156, 159, 288, 9, 70, "ExampleText",
 CellID->191152648],
Cell[CellGroupData[{
Cell[4469, 172, 182, 5, 70, "Input",
 CellTags->"General::strmn",
 CellID->16213],
Cell[4654, 179, 165, 5, 70, "Output",
 CellTags->"General::strmn",
 CellID->18857892]
}, Open  ]],
Cell[CellGroupData[{
Cell[4856, 189, 143, 5, 70, "Input",
 CellTags->"General::strmn",
 CellID->924],
Cell[5002, 196, 101, 3, 70, "Output",
 CellTags->"General::strmn",
 CellID->135466026]
}, Open  ]],
Cell[5118, 202, 155, 4, 70, "ExampleText",
 CellID->35156100],
Cell[CellGroupData[{
Cell[5298, 210, 296, 10, 70, "Input",
 CellTags->"General::strmn",
 CellID->18860],
Cell[5597, 222, 445, 9, 70, "Message",
 CellTags->"General::strmn",
 CellID->519543814],
Cell[6045, 233, 229, 6, 70, "Message",
 CellTags->"General::strmn",
 CellID->395267765],
Cell[6277, 241, 287, 7, 70, "Message",
 CellTags->"General::strmn",
 CellID->160550178],
Cell[6567, 250, 106, 3, 70, "Output",
 CellTags->"General::strmn",
 CellID->512340739]
}, Open  ]],
Cell[6688, 256, 93, 1, 70, "ExampleText",
 CellID->438016368],
Cell[CellGroupData[{
Cell[6806, 261, 169, 5, 70, "Input",
 CellTags->"General::strmn",
 CellID->811701038],
Cell[6978, 268, 255, 6, 70, "Output",
 CellTags->"General::strmn",
 CellID->241391895]
}, Open  ]],
Cell[7248, 277, 60, 1, 70, "ExampleText",
 CellID->179638787],
Cell[CellGroupData[{
Cell[7333, 282, 126, 4, 70, "Input",
 CellTags->"General::strmn",
 CellID->29896],
Cell[7462, 288, 105, 3, 70, "Output",
 CellTags->"General::strmn",
 CellID->305429683]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[7606, 296, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

