(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7887,        291]
NotebookOptionsPosition[      5086,        197]
NotebookOutlinePosition[      6718,        248]
CellTagsIndexPosition[      6604,        242]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["General::tol", "ObjectName",
 CellID->23643],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"tol\"\>"}], ":", 
  " ", "\<\"Value of option Tolerance -> `1` is not a non-negative real \
number or Automatic.\"\>"}]], "Message", "MSG",
 CellID->108460998],

Cell[TextData[{
 "Generated when the indicated value of the ",
 Cell[BoxData[
  ButtonBox["Tolerance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tolerance"]], "InlineFormula"],
 " option does not have the expected form."
}], "Notes",
 CellID->30993]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->524679783],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->187971538],

Cell[TextData[{
 "The value of the ",
 Cell[BoxData[
  ButtonBox["Tolerance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tolerance"]], "InlineFormula"],
 " option cannot be ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->437279287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NullSpace", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.2", ",", "3.4", ",", "5.6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.2", ",", "3.4", ",", "5.7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.2", ",", "3.4", ",", "5.8"}], "}"}]}], "}"}], ",", 
   RowBox[{"Tolerance", "->", "None"}]}], "]"}]], "Input",
 CellTags->"General::tol",
 CellLabel->"In[1]:=",
 CellID->2553],

Cell[BoxData[
 RowBox[{
  RowBox[{"NullSpace", "::", "\<\"tol\"\>"}], ":", 
  " ", "\<\"Value of option Tolerance -> \\!\\(None\\) is not a non-negative \
real number or Automatic.\"\>"}]], "Message", "MSG",
 CellTags->"General::tol",
 CellID->163661241],

Cell[BoxData[
 RowBox[{"NullSpace", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.2`", ",", "3.4`", ",", "5.6`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.2`", ",", "3.4`", ",", "5.7`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.2`", ",", "3.4`", ",", "5.8`"}], "}"}]}], "}"}], ",", 
   RowBox[{"Tolerance", "\[Rule]", "None"}]}], "]"}]], "Output",
 CellTags->"General::tol",
 CellLabel->"Out[1]=",
 CellID->799707584]
}, Open  ]],

Cell[TextData[{
 "This shows a valid value for the ",
 Cell[BoxData[
  ButtonBox["Tolerance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tolerance"]], "InlineFormula"],
 " option."
}], "ExampleText",
 CellID->247134842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NullSpace", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.2", ",", "3.4", ",", "5.6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.2", ",", "3.4", ",", "5.7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.2", ",", "3.4", ",", "5.8"}], "}"}]}], "}"}], ",", 
   RowBox[{"Tolerance", "->", "0.1"}]}], "]"}]], "Input",
 CellTags->"General::tol",
 CellLabel->"In[2]:=",
 CellID->414787202],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.28128375010794976`"}], ",", 
     RowBox[{"-", "0.7969706253058678`"}], ",", "0.5345252794066736`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.9429903335828905`"}], ",", "0.3328201177351347`", ",", 
     "1.862930382873218`*^-15"}], "}"}]}], "}"}]], "Output",
 CellTags->"General::tol",
 CellLabel->"Out[2]=",
 CellID->158706143]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General::tol - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 7, 15.1322860}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "General::tol", "synonyms" -> {}, "title" -> "General::tol", 
    "type" -> "Message", "uri" -> "ref/message/tol"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1767, 69, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->524679783]},
 "General::tol"->{
  Cell[2664, 107, 452, 14, 70, "Input",
   CellTags->"General::tol",
   CellID->2553],
  Cell[3119, 123, 254, 6, 70, "Message",
   CellTags->"General::tol",
   CellID->163661241],
  Cell[3376, 131, 472, 14, 70, "Output",
   CellTags->"General::tol",
   CellID->799707584],
  Cell[4113, 160, 456, 14, 70, "Input",
   CellTags->"General::tol",
   CellID->414787202],
  Cell[4572, 176, 448, 14, 70, "Output",
   CellTags->"General::tol",
   CellID->158706143]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5984, 219},
 {"General::tol", 6122, 223}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 50, 1, 70, "ObjectName",
 CellID->23643],
Cell[CellGroupData[{
Cell[778, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1256, 49, 215, 5, 70, "Message",
 CellID->108460998],
Cell[1474, 56, 256, 8, 70, "Notes",
 CellID->30993]
}, Closed]],
Cell[CellGroupData[{
Cell[1767, 69, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->524679783],
Cell[CellGroupData[{
Cell[2152, 83, 148, 5, 70, "ExampleSection",
 CellID->187971538],
Cell[2303, 90, 336, 13, 70, "ExampleText",
 CellID->437279287],
Cell[CellGroupData[{
Cell[2664, 107, 452, 14, 70, "Input",
 CellTags->"General::tol",
 CellID->2553],
Cell[3119, 123, 254, 6, 70, "Message",
 CellTags->"General::tol",
 CellID->163661241],
Cell[3376, 131, 472, 14, 70, "Output",
 CellTags->"General::tol",
 CellID->799707584]
}, Open  ]],
Cell[3863, 148, 225, 8, 70, "ExampleText",
 CellID->247134842],
Cell[CellGroupData[{
Cell[4113, 160, 456, 14, 70, "Input",
 CellTags->"General::tol",
 CellID->414787202],
Cell[4572, 176, 448, 14, 70, "Output",
 CellTags->"General::tol",
 CellID->158706143]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5059, 195, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

