(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13396,        409]
NotebookOptionsPosition[      5076,        185]
NotebookOutlinePosition[     11518,        351]
CellTagsIndexPosition[     11231,        342]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
GroebnerBasis::intgb
PolynomialReduce::intgb
GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb
GroebnerBasis`DistributedTermsList::intgb\
\>", "ObjectName",
 CellID->3558],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"intgb\"\>"}], ":", 
  " ", "\<\"Nontrivial denominator in `1` is invalid input for `2` over the \
integers.\"\>"}]], "Message", "MSG",
 CellID->34827710],

Cell["\<\
Generated when an integer coefficient domain is specified and the indicated \
polynomial cannot be represented using integer coefficients.\
\>", "Notes",
 CellID->22305]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->412116180],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->510624060],

Cell[TextData[{
 "An error occurs in this example because the coefficients in the polynomials \
 in the first argument of ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " are not integers."
}], "ExampleText",
 CellID->34395005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "/", "3"}], "+", "x"}], ",", "x"}], "}"}], ",", "x", ",", 
   RowBox[{"CoefficientDomain", "->", "Integers"}]}], "]"}]], "Input",
 CellTags->{
  "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
   "GroebnerBasis`DistributedTermsList::intgb"},
 CellLabel->"In[1]:=",
 CellID->10932],

Cell[BoxData[
 RowBox[{
  RowBox[{"GroebnerBasis", "::", "\<\"intgb\"\>"}], ":", 
  " ", "\<\"Nontrivial denominator in \\!\\(1\\/3\\\\ \\(\\((2 + \\(\\(3\\\\ \
x\\)\\))\\)\\)\\) is invalid input for \\!\\(GroebnerBasis\\) over the \
integers.\"\>"}]], "Message", "MSG",
 CellTags->{
  "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
   "GroebnerBasis`DistributedTermsList::intgb"},
 CellID->586712589],

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["2", "3"], "+", "x"}], ",", "x"}], "}"}], ",", "x", ",", 
   RowBox[{"CoefficientDomain", "\[Rule]", "Integers"}]}], "]"}]], "Output",
 CellTags->{
  "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
   "GroebnerBasis`DistributedTermsList::intgb"},
 CellLabel->"Out[1]=",
 CellID->130025727]
}, Open  ]],

Cell["\<\
This computation can be done if the coefficient domain is expanded to include \
rational numbers.\
\>", "ExampleText",
 CellID->215709236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "/", "3"}], "+", "x"}], ",", "x"}], "}"}], ",", "x", ",", 
   RowBox[{"CoefficientDomain", "->", "Rationals"}]}], "]"}]], "Input",
 CellTags->{
  "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
   "GroebnerBasis`DistributedTermsList::intgb"},
 CellLabel->"In[2]:=",
 CellID->22690],

Cell[BoxData[
 RowBox[{"{", "1", "}"}]], "Output",
 CellTags->{
  "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
   "GroebnerBasis`DistributedTermsList::intgb"},
 CellLabel->"Out[2]=",
 CellID->128841135]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GroebnerBasis::intgb - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 8, 18.4151560}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "GroebnerBasis::intgb PolynomialReduce::intgb \
GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb \
GroebnerBasis`DistributedTermsList::intgb", "synonyms" -> {}, "title" -> 
    "GroebnerBasis::intgb", "type" -> "Message", "uri" -> 
    "ref/message/intgb"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1833, 71, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->412116180]},
 "GroebnerBasis::intgb"->{
  Cell[2707, 105, 458, 13, 70, "Input",
   CellTags->{
    "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
     "GroebnerBasis`DistributedTermsList::intgb"},
   CellID->10932],
  Cell[3168, 120, 460, 10, 70, "Message",
   CellTags->{
    "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
     "GroebnerBasis`DistributedTermsList::intgb"},
   CellID->586712589],
  Cell[3631, 132, 466, 13, 70, "Output",
   CellTags->{
    "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
     "GroebnerBasis`DistributedTermsList::intgb"},
   CellID->130025727],
  Cell[4285, 156, 459, 13, 70, "Input",
   CellTags->{
    "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
     "GroebnerBasis`DistributedTermsList::intgb"},
   CellID->22690],
  Cell[4747, 171, 263, 7, 70, "Output",
   CellTags->{
    "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
     "GroebnerBasis`DistributedTermsList::intgb"},
   CellID->128841135]},
 "PolynomialReduce::intgb"->{
  Cell[2707, 105, 458, 13, 70, "Input",
   CellTags->{
    "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
     "GroebnerBasis`DistributedTermsList::intgb"},
   CellID->10932],
  Cell[3168, 120, 460, 10, 70, "Message",
   CellTags->{
    "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
     "GroebnerBasis`DistributedTermsList::intgb"},
   CellID->586712589],
  Cell[3631, 132, 466, 13, 70, "Output",
   CellTags->{
    "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
     "GroebnerBasis`DistributedTermsList::intgb"},
   CellID->130025727],
  Cell[4285, 156, 459, 13, 70, "Input",
   CellTags->{
    "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
     "GroebnerBasis`DistributedTermsList::intgb"},
   CellID->22690],
  Cell[4747, 171, 263, 7, 70, "Output",
   CellTags->{
    "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
     "GroebnerBasis`DistributedTermsList::intgb"},
   CellID->128841135]},
 "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb"->{
  Cell[2707, 105, 458, 13, 70, "Input",
   CellTags->{
    "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
     "GroebnerBasis`DistributedTermsList::intgb"},
   CellID->10932],
  Cell[3168, 120, 460, 10, 70, "Message",
   CellTags->{
    "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
     "GroebnerBasis`DistributedTermsList::intgb"},
   CellID->586712589],
  Cell[3631, 132, 466, 13, 70, "Output",
   CellTags->{
    "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
     "GroebnerBasis`DistributedTermsList::intgb"},
   CellID->130025727],
  Cell[4285, 156, 459, 13, 70, "Input",
   CellTags->{
    "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
     "GroebnerBasis`DistributedTermsList::intgb"},
   CellID->22690],
  Cell[4747, 171, 263, 7, 70, "Output",
   CellTags->{
    "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
     "GroebnerBasis`DistributedTermsList::intgb"},
   CellID->128841135]},
 "GroebnerBasis`DistributedTermsList::intgb"->{
  Cell[2707, 105, 458, 13, 70, "Input",
   CellTags->{
    "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
     "GroebnerBasis`DistributedTermsList::intgb"},
   CellID->10932],
  Cell[3168, 120, 460, 10, 70, "Message",
   CellTags->{
    "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
     "GroebnerBasis`DistributedTermsList::intgb"},
   CellID->586712589],
  Cell[3631, 132, 466, 13, 70, "Output",
   CellTags->{
    "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
     "GroebnerBasis`DistributedTermsList::intgb"},
   CellID->130025727],
  Cell[4285, 156, 459, 13, 70, "Input",
   CellTags->{
    "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
     "GroebnerBasis`DistributedTermsList::intgb"},
   CellID->22690],
  Cell[4747, 171, 263, 7, 70, "Output",
   CellTags->{
    "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
     "GroebnerBasis`DistributedTermsList::intgb"},
   CellID->128841135]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6127, 211},
 {"GroebnerBasis::intgb", 6273, 215},
 {"PolynomialReduce::intgb", 7504, 246},
 {"GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 8758, 277},
 {"GroebnerBasis`DistributedTermsList::intgb", 10007, 308}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 178, 6, 70, "ObjectName",
 CellID->3558],
Cell[CellGroupData[{
Cell[906, 37, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1384, 54, 230, 6, 70, "Message",
 CellID->34827710],
Cell[1617, 62, 179, 4, 70, "Notes",
 CellID->22305]
}, Closed]],
Cell[CellGroupData[{
Cell[1833, 71, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->412116180],
Cell[CellGroupData[{
Cell[2218, 85, 148, 5, 70, "ExampleSection",
 CellID->510624060],
Cell[2369, 92, 313, 9, 70, "ExampleText",
 CellID->34395005],
Cell[CellGroupData[{
Cell[2707, 105, 458, 13, 70, "Input",
 CellTags->{
  "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
   "GroebnerBasis`DistributedTermsList::intgb"},
 CellID->10932],
Cell[3168, 120, 460, 10, 70, "Message",
 CellTags->{
  "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
   "GroebnerBasis`DistributedTermsList::intgb"},
 CellID->586712589],
Cell[3631, 132, 466, 13, 70, "Output",
 CellTags->{
  "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
   "GroebnerBasis`DistributedTermsList::intgb"},
 CellID->130025727]
}, Open  ]],
Cell[4112, 148, 148, 4, 70, "ExampleText",
 CellID->215709236],
Cell[CellGroupData[{
Cell[4285, 156, 459, 13, 70, "Input",
 CellTags->{
  "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
   "GroebnerBasis`DistributedTermsList::intgb"},
 CellID->22690],
Cell[4747, 171, 263, 7, 70, "Output",
 CellTags->{
  "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb", 
   "GroebnerBasis`DistributedTermsList::intgb"},
 CellID->128841135]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5049, 183, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

