(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15574,        473]
NotebookOptionsPosition[      7022,        249]
NotebookOutlinePosition[     13658,        415]
CellTagsIndexPosition[     13362,        406]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
GroebnerBasis::mnmord2
PolynomialReduce::mnmord2
GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2
GroebnerBasis`DistributedTermsList::mnmord2\
\>", "ObjectName",
 CellID->11967],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"mnmord2\"\>"}], ":", 
  " ", "\<\"`1` does not order all terms formed from variables `2`.\"\>"}]], \
"Message", "MSG",
 CellID->187043394],

Cell[TextData[{
 "Generated when the value of the ",
 Cell[BoxData["MonomialOrder"], "InlineFormula"],
 " option is a weight matrix and that weight matrix does not specify the \
order for all of the variables in the argument polynomials."
}], "Notes",
 CellID->13557]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->75163464],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->4874135],

Cell[TextData[{
 "An error occurs in this example because the weight matrix given as the  \
value of the ",
 Cell[BoxData["MonomialOrder"], "InlineFormula"],
 " option does not specify ordering for all of the variables."
}], "ExampleText",
 CellID->87144371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", " ", "y"}], "+", "1"}], ",", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", " ", "z"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", 
       RowBox[{"x", "^", "2"}]}], "+", "x", "+", "y"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"MonomialOrder", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellTags->{
  "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
   "GroebnerBasis`DistributedTermsList::mnmord2"},
 CellLabel->"In[1]:=",
 CellID->15340],

Cell[BoxData[
 RowBox[{
  RowBox[{"GroebnerBasis", "::", "\<\"mnmord2\"\>"}], ":", 
  " ", "\<\"\\!\\({\\(\\({1, 0}\\)\\), \\(\\({0, 1}\\)\\)}\\) does not order \
all terms formed from variables \\!\\({x, y, z}\\).\"\>"}]], "Message", "MSG",
 
 CellTags->{
  "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
   "GroebnerBasis`DistributedTermsList::mnmord2"},
 CellID->827899547],

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"x", " ", "y"}]}], ",", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      RowBox[{"y", " ", "z"}]}], ",", 
     RowBox[{"x", "+", "y", "+", 
      RowBox[{
       SuperscriptBox["x", "2"], " ", 
       SuperscriptBox["z", "2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"MonomialOrder", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Output",
 CellTags->{
  "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
   "GroebnerBasis`DistributedTermsList::mnmord2"},
 CellLabel->"Out[1]=",
 CellID->177655879]
}, Open  ]],

Cell["This shows a valid weight matrix for these polynomials.", "ExampleText",
 CellID->68724670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", " ", "y"}], "+", "1"}], ",", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", " ", "z"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], " ", 
       RowBox[{"x", "^", "2"}]}], "+", "x", "+", "y"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"MonomialOrder", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",\

 CellTags->{
  "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
   "GroebnerBasis`DistributedTermsList::mnmord2"},
 CellLabel->"In[2]:=",
 CellID->11184],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["z", "2"], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["z", "3"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["z", "6"]}], "+", 
    SuperscriptBox["z", "9"]}], ",", 
   RowBox[{"y", "+", "z", "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["z", "2"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["z", "5"]}], "+", 
    SuperscriptBox["z", "8"]}], ",", 
   RowBox[{"x", "-", "z", "-", 
    SuperscriptBox["z", "2"], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["z", "5"]}], "-", 
    SuperscriptBox["z", "8"]}]}], "}"}]], "Output",
 CellTags->{
  "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
   "GroebnerBasis`DistributedTermsList::mnmord2"},
 CellLabel->"Out[2]=",
 CellID->558739049]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GroebnerBasis::mnmord2 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 8, 18.7589148}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "GroebnerBasis::mnmord2 PolynomialReduce::mnmord2 \
GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2 \
GroebnerBasis`DistributedTermsList::mnmord2", "synonyms" -> {}, "title" -> 
    "GroebnerBasis::mnmord2", "type" -> "Message", "uri" -> 
    "ref/message/mnmord2"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1915, 73, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->75163464]},
 "GroebnerBasis::mnmord2"->{
  Cell[2731, 104, 884, 28, 70, "Input",
   CellTags->{
    "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
     "GroebnerBasis`DistributedTermsList::mnmord2"},
   CellID->15340],
  Cell[3618, 134, 441, 10, 70, "Message",
   CellTags->{
    "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
     "GroebnerBasis`DistributedTermsList::mnmord2"},
   CellID->827899547],
  Cell[4062, 146, 897, 28, 70, "Output",
   CellTags->{
    "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
     "GroebnerBasis`DistributedTermsList::mnmord2"},
   CellID->177655879],
  Cell[5096, 182, 981, 31, 70, "Input",
   CellTags->{
    "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
     "GroebnerBasis`DistributedTermsList::mnmord2"},
   CellID->11184],
  Cell[6080, 215, 876, 27, 70, "Output",
   CellTags->{
    "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
     "GroebnerBasis`DistributedTermsList::mnmord2"},
   CellID->558739049]},
 "PolynomialReduce::mnmord2"->{
  Cell[2731, 104, 884, 28, 70, "Input",
   CellTags->{
    "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
     "GroebnerBasis`DistributedTermsList::mnmord2"},
   CellID->15340],
  Cell[3618, 134, 441, 10, 70, "Message",
   CellTags->{
    "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
     "GroebnerBasis`DistributedTermsList::mnmord2"},
   CellID->827899547],
  Cell[4062, 146, 897, 28, 70, "Output",
   CellTags->{
    "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
     "GroebnerBasis`DistributedTermsList::mnmord2"},
   CellID->177655879],
  Cell[5096, 182, 981, 31, 70, "Input",
   CellTags->{
    "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
     "GroebnerBasis`DistributedTermsList::mnmord2"},
   CellID->11184],
  Cell[6080, 215, 876, 27, 70, "Output",
   CellTags->{
    "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
     "GroebnerBasis`DistributedTermsList::mnmord2"},
   CellID->558739049]},
 "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2"->{
  Cell[2731, 104, 884, 28, 70, "Input",
   CellTags->{
    "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
     "GroebnerBasis`DistributedTermsList::mnmord2"},
   CellID->15340],
  Cell[3618, 134, 441, 10, 70, "Message",
   CellTags->{
    "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
     "GroebnerBasis`DistributedTermsList::mnmord2"},
   CellID->827899547],
  Cell[4062, 146, 897, 28, 70, "Output",
   CellTags->{
    "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
     "GroebnerBasis`DistributedTermsList::mnmord2"},
   CellID->177655879],
  Cell[5096, 182, 981, 31, 70, "Input",
   CellTags->{
    "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
     "GroebnerBasis`DistributedTermsList::mnmord2"},
   CellID->11184],
  Cell[6080, 215, 876, 27, 70, "Output",
   CellTags->{
    "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
     "GroebnerBasis`DistributedTermsList::mnmord2"},
   CellID->558739049]},
 "GroebnerBasis`DistributedTermsList::mnmord2"->{
  Cell[2731, 104, 884, 28, 70, "Input",
   CellTags->{
    "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
     "GroebnerBasis`DistributedTermsList::mnmord2"},
   CellID->15340],
  Cell[3618, 134, 441, 10, 70, "Message",
   CellTags->{
    "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
     "GroebnerBasis`DistributedTermsList::mnmord2"},
   CellID->827899547],
  Cell[4062, 146, 897, 28, 70, "Output",
   CellTags->{
    "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
     "GroebnerBasis`DistributedTermsList::mnmord2"},
   CellID->177655879],
  Cell[5096, 182, 981, 31, 70, "Input",
   CellTags->{
    "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
     "GroebnerBasis`DistributedTermsList::mnmord2"},
   CellID->11184],
  Cell[6080, 215, 876, 27, 70, "Output",
   CellTags->{
    "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
     "GroebnerBasis`DistributedTermsList::mnmord2"},
   CellID->558739049]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8087, 275},
 {"GroebnerBasis::mnmord2", 8234, 279},
 {"PolynomialReduce::mnmord2", 9508, 310},
 {"GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 10805, 341},
 {"GroebnerBasis`DistributedTermsList::mnmord2", 12097, 372}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 187, 6, 70, "ObjectName",
 CellID->11967],
Cell[CellGroupData[{
Cell[915, 37, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1393, 54, 215, 6, 70, "Message",
 CellID->187043394],
Cell[1611, 62, 267, 6, 70, "Notes",
 CellID->13557]
}, Closed]],
Cell[CellGroupData[{
Cell[1915, 73, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->75163464],
Cell[CellGroupData[{
Cell[2299, 87, 146, 5, 70, "ExampleSection",
 CellID->4874135],
Cell[2448, 94, 258, 6, 70, "ExampleText",
 CellID->87144371],
Cell[CellGroupData[{
Cell[2731, 104, 884, 28, 70, "Input",
 CellTags->{
  "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
   "GroebnerBasis`DistributedTermsList::mnmord2"},
 CellID->15340],
Cell[3618, 134, 441, 10, 70, "Message",
 CellTags->{
  "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
   "GroebnerBasis`DistributedTermsList::mnmord2"},
 CellID->827899547],
Cell[4062, 146, 897, 28, 70, "Output",
 CellTags->{
  "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
   "GroebnerBasis`DistributedTermsList::mnmord2"},
 CellID->177655879]
}, Open  ]],
Cell[4974, 177, 97, 1, 70, "ExampleText",
 CellID->68724670],
Cell[CellGroupData[{
Cell[5096, 182, 981, 31, 70, "Input",
 CellTags->{
  "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
   "GroebnerBasis`DistributedTermsList::mnmord2"},
 CellID->11184],
Cell[6080, 215, 876, 27, 70, "Output",
 CellTags->{
  "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2", 
   "GroebnerBasis`DistributedTermsList::mnmord2"},
 CellID->558739049]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6995, 247, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

