(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10369,        323]
NotebookOptionsPosition[      4449,        163]
NotebookOutlinePosition[      9029,        281]
CellTagsIndexPosition[      8739,        272]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
GroebnerBasis::pdvar2
PolynomialReduce::pdvar2
GroebnerBasis`GroebnerWalk`GroebnerWalk::pdvar2
GroebnerBasis`DistributedTermsList::pdvar2\
\>", "ObjectName",
 CellID->10148],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"pdvar2\"\>"}], ":", 
  " ", "\<\"The polynomial domain variable `1` is improperly used in \
polynomial `2`.\"\>"}]], "Message", "MSG",
 CellID->571640242],

Cell[TextData[{
 "Generated when the value of the ",
 Cell[BoxData["CoefficientDomain"], "InlineFormula"],
 " option is ",
 StyleBox["Polynomials[", "MR"],
 StyleBox["var", "MR",
  FontSlant->"Italic"],
 StyleBox["]", "MR"],
 " and ",
 StyleBox["var", "MR",
  FontSlant->"Italic"],
 " is used in the indicated expression in a position that is not part of a \
polynomial coefficient."
}], "Notes",
 CellID->20465]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->355947917],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->56699599],

Cell["\<\
An error occurs in this example because the expressions listed in the first \
argument are not polynomials in the specified variable with coefficients in \
the specified domain.\
\>", "ExampleText",
 CellID->559907504],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "+", 
      RowBox[{"y", "^", "x"}]}], ",", 
     RowBox[{"1", "-", 
      RowBox[{"x", " ", "y"}]}]}], "}"}], ",", "y", ",", 
   RowBox[{"CoefficientDomain", "->", 
    RowBox[{"Polynomials", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellTags->{
  "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::pdvar2", 
   "GroebnerBasis`DistributedTermsList::pdvar2"},
 CellLabel->"In[1]:=",
 CellID->23930],

Cell[BoxData[
 RowBox[{
  RowBox[{"GroebnerBasis", "::", "\<\"pdvar2\"\>"}], ":", 
  " ", "\<\"The polynomial domain variable \\!\\(x\\) is improperly used in \
polynomial \\!\\(y + y\\^x\\).\"\>"}]], "Message", "MSG",
 CellTags->{
  "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::pdvar2", 
   "GroebnerBasis`DistributedTermsList::pdvar2"},
 CellID->310147984],

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "+", 
      SuperscriptBox["y", "x"]}], ",", 
     RowBox[{"1", "-", 
      RowBox[{"x", " ", "y"}]}]}], "}"}], ",", "y", ",", 
   RowBox[{"CoefficientDomain", "\[Rule]", 
    RowBox[{"Polynomials", "[", "x", "]"}]}]}], "]"}]], "Output",
 CellTags->{
  "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::pdvar2", 
   "GroebnerBasis`DistributedTermsList::pdvar2"},
 CellLabel->"Out[1]=",
 CellID->8167164]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GroebnerBasis::pdvar2 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 8, 19.0401720}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "GroebnerBasis::pdvar2 PolynomialReduce::pdvar2 \
GroebnerBasis`GroebnerWalk`GroebnerWalk::pdvar2 \
GroebnerBasis`DistributedTermsList::pdvar2", "synonyms" -> {}, "title" -> 
    "GroebnerBasis::pdvar2", "type" -> "Message", "uri" -> 
    "ref/message/pdvar2"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2072, 81, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->355947917]},
 "GroebnerBasis::pdvar2"->{
  Cell[2860, 111, 548, 16, 70, "Input",
   CellTags->{
    "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::pdvar2", 
     "GroebnerBasis`DistributedTermsList::pdvar2"},
   CellID->23930],
  Cell[3411, 129, 412, 9, 70, "Message",
   CellTags->{
    "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::pdvar2", 
     "GroebnerBasis`DistributedTermsList::pdvar2"},
   CellID->310147984],
  Cell[3826, 140, 557, 16, 70, "Output",
   CellTags->{
    "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::pdvar2", 
     "GroebnerBasis`DistributedTermsList::pdvar2"},
   CellID->8167164]},
 "PolynomialReduce::pdvar2"->{
  Cell[2860, 111, 548, 16, 70, "Input",
   CellTags->{
    "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::pdvar2", 
     "GroebnerBasis`DistributedTermsList::pdvar2"},
   CellID->23930],
  Cell[3411, 129, 412, 9, 70, "Message",
   CellTags->{
    "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::pdvar2", 
     "GroebnerBasis`DistributedTermsList::pdvar2"},
   CellID->310147984],
  Cell[3826, 140, 557, 16, 70, "Output",
   CellTags->{
    "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::pdvar2", 
     "GroebnerBasis`DistributedTermsList::pdvar2"},
   CellID->8167164]},
 "GroebnerBasis`GroebnerWalk`GroebnerWalk::pdvar2"->{
  Cell[2860, 111, 548, 16, 70, "Input",
   CellTags->{
    "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::pdvar2", 
     "GroebnerBasis`DistributedTermsList::pdvar2"},
   CellID->23930],
  Cell[3411, 129, 412, 9, 70, "Message",
   CellTags->{
    "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::pdvar2", 
     "GroebnerBasis`DistributedTermsList::pdvar2"},
   CellID->310147984],
  Cell[3826, 140, 557, 16, 70, "Output",
   CellTags->{
    "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::pdvar2", 
     "GroebnerBasis`DistributedTermsList::pdvar2"},
   CellID->8167164]},
 "GroebnerBasis`DistributedTermsList::pdvar2"->{
  Cell[2860, 111, 548, 16, 70, "Input",
   CellTags->{
    "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::pdvar2", 
     "GroebnerBasis`DistributedTermsList::pdvar2"},
   CellID->23930],
  Cell[3411, 129, 412, 9, 70, "Message",
   CellTags->{
    "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::pdvar2", 
     "GroebnerBasis`DistributedTermsList::pdvar2"},
   CellID->310147984],
  Cell[3826, 140, 557, 16, 70, "Output",
   CellTags->{
    "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::pdvar2", 
     "GroebnerBasis`DistributedTermsList::pdvar2"},
   CellID->8167164]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5507, 189},
 {"GroebnerBasis::pdvar2", 5654, 193},
 {"PolynomialReduce::pdvar2", 6417, 212},
 {"GroebnerBasis`GroebnerWalk`GroebnerWalk::pdvar2", 7203, 231},
 {"GroebnerBasis`DistributedTermsList::pdvar2", 7984, 250}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 183, 6, 70, "ObjectName",
 CellID->10148],
Cell[CellGroupData[{
Cell[911, 37, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1389, 54, 231, 6, 70, "Message",
 CellID->571640242],
Cell[1623, 62, 412, 14, 70, "Notes",
 CellID->20465]
}, Closed]],
Cell[CellGroupData[{
Cell[2072, 81, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->355947917],
Cell[CellGroupData[{
Cell[2457, 95, 147, 5, 70, "ExampleSection",
 CellID->56699599],
Cell[2607, 102, 228, 5, 70, "ExampleText",
 CellID->559907504],
Cell[CellGroupData[{
Cell[2860, 111, 548, 16, 70, "Input",
 CellTags->{
  "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::pdvar2", 
   "GroebnerBasis`DistributedTermsList::pdvar2"},
 CellID->23930],
Cell[3411, 129, 412, 9, 70, "Message",
 CellTags->{
  "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::pdvar2", 
   "GroebnerBasis`DistributedTermsList::pdvar2"},
 CellID->310147984],
Cell[3826, 140, 557, 16, 70, "Output",
 CellTags->{
  "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::pdvar2", 
   "GroebnerBasis`DistributedTermsList::pdvar2"},
 CellID->8167164]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4422, 161, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

