(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14696,        451]
NotebookOptionsPosition[      6094,        225]
NotebookOutlinePosition[     12722,        391]
CellTagsIndexPosition[     12427,        382]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
GroebnerBasis::wgtmat1
PolynomialReduce::wgtmat1
GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1
GroebnerBasis`DistributedTermsList::wgtmat1\
\>", "ObjectName",
 CellID->12973],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"wgtmat1\"\>"}], ":", 
  " ", "\<\"`1` is not a valid weight matrix.\"\>"}]], "Message", "MSG",
 CellID->173641040],

Cell[TextData[{
 "Generated when the value of the ",
 Cell[BoxData["MonomialOrder"], "InlineFormula"],
 " option is not a valid weight matrix."
}], "Notes",
 CellID->16390],

Cell[TextData[{
 "A weight matrix used as the value of the ",
 Cell[BoxData["MonomialOrder"], "InlineFormula"],
 " option is expected to be a non-degenerate matrix with positive integer or \
rational elements."
}], "Notes",
 CellID->13504]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->221604692],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->561985362],

Cell["\<\
An error occurs in this example because the weight matrix includes elements \
that are not integers or rational numbers.\
\>", "ExampleText",
 CellID->264117550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"3", "x", " ", "y"}]}], ",", 
     RowBox[{"y", "-", 
      RowBox[{"2", "x"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"MonomialOrder", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Pi", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "Pi"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellTags->{
  "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
   "GroebnerBasis`DistributedTermsList::wgtmat1"},
 CellLabel->"In[1]:=",
 CellID->22334],

Cell[BoxData[
 RowBox[{
  RowBox[{"GroebnerBasis", "::", "\<\"wgtmat1\"\>"}], ":", 
  " ", "\<\"\\!\\({\\(\\({\[Pi], 0}\\)\\), \\(\\({0, \[Pi]}\\)\\)}\\) is not \
a valid weight matrix.\"\>"}]], "Message", "MSG",
 CellTags->{
  "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
   "GroebnerBasis`DistributedTermsList::wgtmat1"},
 CellID->14460643],

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"3", " ", "x", " ", "y"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "x"}], "+", "y"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"MonomialOrder", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Pi]", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "\[Pi]"}], "}"}]}], "}"}]}]}], "]"}]], "Output",
 CellTags->{
  "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
   "GroebnerBasis`DistributedTermsList::wgtmat1"},
 CellLabel->"Out[1]=",
 CellID->148663983]
}, Open  ]],

Cell[TextData[{
 "This shows a valid weight matrix as the value of the ",
 Cell[BoxData["MonomialOrder"], "InlineFormula"],
 " option."
}], "ExampleText",
 CellID->573558193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"3", "x", " ", "y"}]}], ",", 
     RowBox[{"y", "-", 
      RowBox[{"2", "x"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"MonomialOrder", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellTags->{
  "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
   "GroebnerBasis`DistributedTermsList::wgtmat1"},
 CellLabel->"In[2]:=",
 CellID->32059],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"y", "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["y", "2"]}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "-", "y"}]}], "}"}]], "Output",
 CellTags->{
  "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
   "GroebnerBasis`DistributedTermsList::wgtmat1"},
 CellLabel->"Out[2]=",
 CellID->582214673]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GroebnerBasis::wgtmat1 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 8, 19.2901784}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "GroebnerBasis::wgtmat1 PolynomialReduce::wgtmat1 \
GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1 \
GroebnerBasis`DistributedTermsList::wgtmat1", "synonyms" -> {}, "title" -> 
    "GroebnerBasis::wgtmat1", "type" -> "Message", "uri" -> 
    "ref/message/wgtmat1"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2038, 79, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->221604692]},
 "GroebnerBasis::wgtmat1"->{
  Cell[2770, 108, 720, 23, 70, "Input",
   CellTags->{
    "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
     "GroebnerBasis`DistributedTermsList::wgtmat1"},
   CellID->22334],
  Cell[3493, 133, 409, 9, 70, "Message",
   CellTags->{
    "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
     "GroebnerBasis`DistributedTermsList::wgtmat1"},
   CellID->14460643],
  Cell[3905, 144, 769, 24, 70, "Output",
   CellTags->{
    "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
     "GroebnerBasis`DistributedTermsList::wgtmat1"},
   CellID->148663983],
  Cell[4888, 180, 718, 23, 70, "Input",
   CellTags->{
    "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
     "GroebnerBasis`DistributedTermsList::wgtmat1"},
   CellID->32059],
  Cell[5609, 205, 419, 13, 70, "Output",
   CellTags->{
    "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
     "GroebnerBasis`DistributedTermsList::wgtmat1"},
   CellID->582214673]},
 "PolynomialReduce::wgtmat1"->{
  Cell[2770, 108, 720, 23, 70, "Input",
   CellTags->{
    "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
     "GroebnerBasis`DistributedTermsList::wgtmat1"},
   CellID->22334],
  Cell[3493, 133, 409, 9, 70, "Message",
   CellTags->{
    "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
     "GroebnerBasis`DistributedTermsList::wgtmat1"},
   CellID->14460643],
  Cell[3905, 144, 769, 24, 70, "Output",
   CellTags->{
    "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
     "GroebnerBasis`DistributedTermsList::wgtmat1"},
   CellID->148663983],
  Cell[4888, 180, 718, 23, 70, "Input",
   CellTags->{
    "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
     "GroebnerBasis`DistributedTermsList::wgtmat1"},
   CellID->32059],
  Cell[5609, 205, 419, 13, 70, "Output",
   CellTags->{
    "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
     "GroebnerBasis`DistributedTermsList::wgtmat1"},
   CellID->582214673]},
 "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1"->{
  Cell[2770, 108, 720, 23, 70, "Input",
   CellTags->{
    "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
     "GroebnerBasis`DistributedTermsList::wgtmat1"},
   CellID->22334],
  Cell[3493, 133, 409, 9, 70, "Message",
   CellTags->{
    "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
     "GroebnerBasis`DistributedTermsList::wgtmat1"},
   CellID->14460643],
  Cell[3905, 144, 769, 24, 70, "Output",
   CellTags->{
    "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
     "GroebnerBasis`DistributedTermsList::wgtmat1"},
   CellID->148663983],
  Cell[4888, 180, 718, 23, 70, "Input",
   CellTags->{
    "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
     "GroebnerBasis`DistributedTermsList::wgtmat1"},
   CellID->32059],
  Cell[5609, 205, 419, 13, 70, "Output",
   CellTags->{
    "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
     "GroebnerBasis`DistributedTermsList::wgtmat1"},
   CellID->582214673]},
 "GroebnerBasis`DistributedTermsList::wgtmat1"->{
  Cell[2770, 108, 720, 23, 70, "Input",
   CellTags->{
    "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
     "GroebnerBasis`DistributedTermsList::wgtmat1"},
   CellID->22334],
  Cell[3493, 133, 409, 9, 70, "Message",
   CellTags->{
    "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
     "GroebnerBasis`DistributedTermsList::wgtmat1"},
   CellID->14460643],
  Cell[3905, 144, 769, 24, 70, "Output",
   CellTags->{
    "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
     "GroebnerBasis`DistributedTermsList::wgtmat1"},
   CellID->148663983],
  Cell[4888, 180, 718, 23, 70, "Input",
   CellTags->{
    "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
     "GroebnerBasis`DistributedTermsList::wgtmat1"},
   CellID->32059],
  Cell[5609, 205, 419, 13, 70, "Output",
   CellTags->{
    "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
     "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
     "GroebnerBasis`DistributedTermsList::wgtmat1"},
   CellID->582214673]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7159, 251},
 {"GroebnerBasis::wgtmat1", 7307, 255},
 {"PolynomialReduce::wgtmat1", 8579, 286},
 {"GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 9874, 317},
 {"GroebnerBasis`DistributedTermsList::wgtmat1", 11164, 348}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 187, 6, 70, "ObjectName",
 CellID->12973],
Cell[CellGroupData[{
Cell[915, 37, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1393, 54, 191, 5, 70, "Message",
 CellID->173641040],
Cell[1587, 61, 172, 5, 70, "Notes",
 CellID->16390],
Cell[1762, 68, 239, 6, 70, "Notes",
 CellID->13504]
}, Closed]],
Cell[CellGroupData[{
Cell[2038, 79, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->221604692],
Cell[CellGroupData[{
Cell[2423, 93, 148, 5, 70, "ExampleSection",
 CellID->561985362],
Cell[2574, 100, 171, 4, 70, "ExampleText",
 CellID->264117550],
Cell[CellGroupData[{
Cell[2770, 108, 720, 23, 70, "Input",
 CellTags->{
  "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
   "GroebnerBasis`DistributedTermsList::wgtmat1"},
 CellID->22334],
Cell[3493, 133, 409, 9, 70, "Message",
 CellTags->{
  "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
   "GroebnerBasis`DistributedTermsList::wgtmat1"},
 CellID->14460643],
Cell[3905, 144, 769, 24, 70, "Output",
 CellTags->{
  "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
   "GroebnerBasis`DistributedTermsList::wgtmat1"},
 CellID->148663983]
}, Open  ]],
Cell[4689, 171, 174, 5, 70, "ExampleText",
 CellID->573558193],
Cell[CellGroupData[{
Cell[4888, 180, 718, 23, 70, "Input",
 CellTags->{
  "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
   "GroebnerBasis`DistributedTermsList::wgtmat1"},
 CellID->32059],
Cell[5609, 205, 419, 13, 70, "Output",
 CellTags->{
  "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
   "GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1", 
   "GroebnerBasis`DistributedTermsList::wgtmat1"},
 CellID->582214673]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6067, 223, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

