(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6438,        241]
NotebookOptionsPosition[      3614,        147]
NotebookOutlinePosition[      5267,        198]
CellTagsIndexPosition[      5150,        192]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Integrate::idiv", "ObjectName",
 CellID->17414],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"idiv\"\>"}], ":", 
  " ", "\<\"Integral of `1` does not converge on `2`.\"\>"}]], "Message", \
"MSG",
 CellID->197304353],

Cell["\<\
Generated when the indicated definite integral does not converge.\
\>", "Notes",
 CellID->11822]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->415161054],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->527731840],

Cell["\<\
A message is generated in this example because this integral is divergent.\
\>", "ExampleText",
 CellID->206861714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellTags->"Integrate::idiv",
 CellLabel->"In[1]:=",
 CellID->22531],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"idiv\"\>"}], ":", 
  " ", "\<\"Integral of \\!\\(\[ExponentialE]\\^x\\) does not converge on \\!\
\\({0, \[Infinity]}\\).\"\>"}]], "Message", "MSG",
 CellTags->"Integrate::idiv",
 CellID->963020659],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellTags->"Integrate::idiv",
 CellLabel->"Out[1]=",
 CellID->3461580]
}, Open  ]],

Cell["This shows a similar integral that is convergent.", "ExampleText",
 CellID->38976302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellTags->"Integrate::idiv",
 CellLabel->"In[2]:=",
 CellID->11464],

Cell[BoxData["1"], "Output",
 CellTags->"Integrate::idiv",
 CellLabel->"Out[2]=",
 CellID->395701231]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Integrate::idiv - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 9, 14.5572182}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Integrate::idiv", "synonyms" -> {}, "title" -> 
    "Integrate::idiv", "type" -> "Message", "uri" -> "ref/message/idiv"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1584, 64, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->415161054]},
 "Integrate::idiv"->{
  Cell[2270, 92, 251, 8, 70, "Input",
   CellTags->"Integrate::idiv",
   CellID->22531],
  Cell[2524, 102, 256, 6, 70, "Message",
   CellTags->"Integrate::idiv",
   CellID->963020659],
  Cell[2783, 110, 259, 8, 70, "Output",
   CellTags->"Integrate::idiv",
   CellID->3461580],
  Cell[3173, 126, 271, 9, 70, "Input",
   CellTags->"Integrate::idiv",
   CellID->11464],
  Cell[3447, 137, 101, 3, 70, "Output",
   CellTags->"Integrate::idiv",
   CellID->395701231]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4522, 169},
 {"Integrate::idiv", 4663, 173}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 1, 70, "ObjectName",
 CellID->17414],
Cell[CellGroupData[{
Cell[781, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 49, 179, 5, 70, "Message",
 CellID->197304353],
Cell[1441, 56, 106, 3, 70, "Notes",
 CellID->11822]
}, Closed]],
Cell[CellGroupData[{
Cell[1584, 64, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->415161054],
Cell[CellGroupData[{
Cell[1969, 78, 148, 5, 70, "ExampleSection",
 CellID->527731840],
Cell[2120, 85, 125, 3, 70, "ExampleText",
 CellID->206861714],
Cell[CellGroupData[{
Cell[2270, 92, 251, 8, 70, "Input",
 CellTags->"Integrate::idiv",
 CellID->22531],
Cell[2524, 102, 256, 6, 70, "Message",
 CellTags->"Integrate::idiv",
 CellID->963020659],
Cell[2783, 110, 259, 8, 70, "Output",
 CellTags->"Integrate::idiv",
 CellID->3461580]
}, Open  ]],
Cell[3057, 121, 91, 1, 70, "ExampleText",
 CellID->38976302],
Cell[CellGroupData[{
Cell[3173, 126, 271, 9, 70, "Input",
 CellTags->"Integrate::idiv",
 CellID->11464],
Cell[3447, 137, 101, 3, 70, "Output",
 CellTags->"Integrate::idiv",
 CellID->395701231]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[3587, 145, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

