(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6959,        253]
NotebookOptionsPosition[      4161,        160]
NotebookOutlinePosition[      5756,        209]
CellTagsIndexPosition[      5636,        203]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Integrate::intnest", "ObjectName",
 CellID->13447],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"intnest\"\>"}], ":", 
  " ", "\<\"The integral `1` cannot be interpreted. The number of integral \
operators must match the number of differential operators.\"\>"}]], "Message",\
 "MSG",
 CellID->472088420],

Cell["\<\
Generated for incorrect typeset input involving an unequal number of integral \
operators and differential operators.\
\>", "Notes",
 CellID->30734],

Cell["\<\
The integral sign \[Integral] is used in typeset input to indicate \
integration. A differential operator of the form \[DifferentialD]x is used to \
identify the variable of integration.\
\>", "Notes",
 CellID->21107],

Cell["\<\
Multiple integrals can be entered using repeated integral signs and \
differential operators.\
\>", "Notes",
 CellID->17829]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->615293505],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->135075320],

Cell["\<\
This input will generate a warning message because it includes one integral \
sign and two differential operators.  When this error occurs, the input is \
not evaluated.\
\>", "ExampleText",
 CellID->61038661],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"x", 
   RowBox[{"\[DifferentialD]", "x"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 EmphasizeSyntaxErrors->True,
 CellTags->"Integrate::intnest",
 CellLabel->"In[1]:=",
 CellID->7409],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"intnest\"\>"}], ":", 
  " ", "\<\"The integral \\!\\(\[Integral] \\(\\(x \\(\\(\[DifferentialD] \
x\\)\\) \\(\\(\[DifferentialD] x\\)\\)\\)\\)\\) cannot be interpreted. The \
number of integral operators must match the number of differential operators.\
\"\>"}]], "Message", "MSG",
 CellTags->"Integrate::intnest",
 CellID->393011378]
}, Open  ]],

Cell["\<\
A double integral can be indicated using matching integral signs and \
differential operators.\
\>", "ExampleText",
 CellID->14910287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"\[Integral]", 
   RowBox[{"x", 
    RowBox[{"\[DifferentialD]", "x"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Input",
 CellTags->"Integrate::intnest",
 CellLabel->"In[2]:=",
 CellID->21069],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["x", "3"], "6"]], "Output",
 CellTags->"Integrate::intnest",
 CellLabel->"Out[2]=",
 CellID->216025935]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Integrate::intnest - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 9, 15.0259802}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Integrate::intnest", "synonyms" -> {}, "title" -> 
    "Integrate::intnest", "type" -> "Message", "uri" -> 
    "ref/message/intnest"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2091, 79, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->615293505]},
 "Integrate::intnest"->{
  Cell[2871, 109, 246, 8, 70, "Input",
   CellTags->"Integrate::intnest",
   CellID->7409],
  Cell[3120, 119, 392, 8, 70, "Message",
   CellTags->"Integrate::intnest",
   CellID->393011378],
  Cell[3696, 138, 248, 8, 70, "Input",
   CellTags->"Integrate::intnest",
   CellID->21069],
  Cell[3947, 148, 148, 5, 70, "Output",
   CellTags->"Integrate::intnest",
   CellID->216025935]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5086, 183},
 {"Integrate::intnest", 5230, 187}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 56, 1, 70, "ObjectName",
 CellID->13447],
Cell[CellGroupData[{
Cell[784, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1262, 49, 264, 6, 70, "Message",
 CellID->472088420],
Cell[1529, 57, 158, 4, 70, "Notes",
 CellID->30734],
Cell[1690, 63, 227, 5, 70, "Notes",
 CellID->21107],
Cell[1920, 70, 134, 4, 70, "Notes",
 CellID->17829]
}, Closed]],
Cell[CellGroupData[{
Cell[2091, 79, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->615293505],
Cell[CellGroupData[{
Cell[2476, 93, 148, 5, 70, "ExampleSection",
 CellID->135075320],
Cell[2627, 100, 219, 5, 70, "ExampleText",
 CellID->61038661],
Cell[CellGroupData[{
Cell[2871, 109, 246, 8, 70, "Input",
 CellTags->"Integrate::intnest",
 CellID->7409],
Cell[3120, 119, 392, 8, 70, "Message",
 CellTags->"Integrate::intnest",
 CellID->393011378]
}, Open  ]],
Cell[3527, 130, 144, 4, 70, "ExampleText",
 CellID->14910287],
Cell[CellGroupData[{
Cell[3696, 138, 248, 8, 70, "Input",
 CellTags->"Integrate::intnest",
 CellID->21069],
Cell[3947, 148, 148, 5, 70, "Output",
 CellTags->"Integrate::intnest",
 CellID->216025935]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4134, 158, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

