(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6863,        246]
NotebookOptionsPosition[      4076,        153]
NotebookOutlinePosition[      5666,        202]
CellTagsIndexPosition[      5546,        196]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Integrate::nodiffd", "ObjectName",
 CellID->24402],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"nodiffd\"\>"}], ":", 
  " ", "\<\"`1` cannot be interpreted. Integrals are entered in the form \
\\!\\(\[Integral]f\[DifferentialD]x\\), where \\!\\(\[DifferentialD]\\) is \
entered as \[EscapeKey]dd\[EscapeKey].\"\>"}]], "Message", "MSG",
 CellID->318809596],

Cell["\<\
Generated for typeset input when an integration operator is used without a \
corresponding differential operator.\
\>", "Notes",
 CellID->23010],

Cell["\<\
The integral sign \[Integral] is used in typeset input to indicate \
integration. A differential operator of the form \[DifferentialD]x is used to \
identify the variable of integration.\
\>", "Notes",
 CellID->30261],

Cell["\<\
You can use buttons from the Basic Calculations palette, the Basic Input \
palette, or other palettes to enter integrals.  Standard palettes can be \
accessed by selecting Palettes under the File menu.\
\>", "Notes",
 CellID->18972]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->139619400],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->65714159],

Cell["\<\
This input generates a message because it includes an integral sign without a \
corresponding differential operator.  When this error occurs, the input is \
not evaluated.\
\>", "ExampleText",
 CellID->78217988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", "x"}]], "Input",
 EmphasizeSyntaxErrors->True,
 CellTags->"Integrate::nodiffd",
 CellLabel->"In[1]:=",
 CellID->3359],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"nodiffd\"\>"}], ":", 
  " ", "\<\"\\!\\(\[Integral] x\\) cannot be interpreted. Integrals are \
entered in the form \\!\\(\[Integral]f\[DifferentialD]x\\), where \\!\\(\
\[DifferentialD]\\) is entered as \[EscapeKey]dd\[EscapeKey].\"\>"}]], \
"Message", "MSG",
 CellTags->"Integrate::nodiffd",
 CellID->99992509]
}, Open  ]],

Cell["This shows a correctly typeset integral.", "ExampleText",
 CellID->151288200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"x", " ", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellTags->"Integrate::nodiffd",
 CellLabel->"In[2]:=",
 CellID->4056],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["x", "2"], "2"]], "Output",
 CellTags->"Integrate::nodiffd",
 CellLabel->"Out[2]=",
 CellID->204304]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Integrate::nodiffd - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 9, 15.1822342}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Integrate::nodiffd", "synonyms" -> {}, "title" -> 
    "Integrate::nodiffd", "type" -> "Message", "uri" -> 
    "ref/message/nodiffd"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2248, 80, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->139619400]},
 "Integrate::nodiffd"->{
  Cell[3029, 110, 155, 5, 70, "Input",
   CellTags->"Integrate::nodiffd",
   CellID->3359],
  Cell[3187, 117, 370, 8, 70, "Message",
   CellTags->"Integrate::nodiffd",
   CellID->99992509],
  Cell[3680, 133, 182, 6, 70, "Input",
   CellTags->"Integrate::nodiffd",
   CellID->4056],
  Cell[3865, 141, 145, 5, 70, "Output",
   CellTags->"Integrate::nodiffd",
   CellID->204304]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5001, 176},
 {"Integrate::nodiffd", 5145, 180}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 56, 1, 70, "ObjectName",
 CellID->24402],
Cell[CellGroupData[{
Cell[784, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1262, 49, 317, 6, 70, "Message",
 CellID->318809596],
Cell[1582, 57, 154, 4, 70, "Notes",
 CellID->23010],
Cell[1739, 63, 227, 5, 70, "Notes",
 CellID->30261],
Cell[1969, 70, 242, 5, 70, "Notes",
 CellID->18972]
}, Closed]],
Cell[CellGroupData[{
Cell[2248, 80, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->139619400],
Cell[CellGroupData[{
Cell[2633, 94, 147, 5, 70, "ExampleSection",
 CellID->65714159],
Cell[2783, 101, 221, 5, 70, "ExampleText",
 CellID->78217988],
Cell[CellGroupData[{
Cell[3029, 110, 155, 5, 70, "Input",
 CellTags->"Integrate::nodiffd",
 CellID->3359],
Cell[3187, 117, 370, 8, 70, "Message",
 CellTags->"Integrate::nodiffd",
 CellID->99992509]
}, Open  ]],
Cell[3572, 128, 83, 1, 70, "ExampleText",
 CellID->151288200],
Cell[CellGroupData[{
Cell[3680, 133, 182, 6, 70, "Input",
 CellTags->"Integrate::nodiffd",
 CellID->4056],
Cell[3865, 141, 145, 5, 70, "Output",
 CellTags->"Integrate::nodiffd",
 CellID->204304]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4049, 151, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

