(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9066,        323]
NotebookOptionsPosition[      5273,        204]
NotebookOutlinePosition[      7382,        265]
CellTagsIndexPosition[      7252,        259]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["InterpolatingFunction::dmval", "ObjectName",
 CellID->12162],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"InterpolatingFunction", "::", "\<\"dmval\"\>"}], ":", 
  " ", "\<\"Input value `1` lies outside the range of data in the \
interpolating function. Extrapolation will be used.\"\>"}]], "Message", "MSG",
 
 CellID->25066985],

Cell[TextData[{
 "Generated when the argument passed to an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " expression falls outside of the range of the interpolation. "
}], "Notes",
 CellID->6200],

Cell["\<\
Extrapolation outside of the range of the interpolation  can give results \
that give misleading results.\
\>", "Notes",
 CellID->12563]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->118704006],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->88383547],

Cell[TextData[{
 "A warning is generated in this example because the point at which the ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " expression is evaluated is beyond the range of the interpolation."
}], "ExampleText",
 CellID->1174810],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"interp", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3.7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "6.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "1.8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "2.1"}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellTags->"InterpolatingFunction::dmval",
 CellLabel->"In[1]:=",
 CellID->17424],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"2.`", ",", "8.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"InterpolatingFunction::dmval",
 CellLabel->"Out[1]=",
 CellID->198385816]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"interp", "[", "20", "]"}]], "Input",
 CellTags->"InterpolatingFunction::dmval",
 CellLabel->"In[2]:=",
 CellID->504],

Cell[BoxData[
 RowBox[{
  RowBox[{"InterpolatingFunction", "::", "\<\"dmval\"\>"}], ":", 
  " ", "\<\"Input value \\!\\({20}\\) lies outside the range of data in the \
interpolating function. Extrapolation will be used.\"\>"}]], "Message", "MSG",
 
 CellTags->"InterpolatingFunction::dmval",
 CellID->337420538],

Cell[BoxData["1216.8999999999999`"], "Output",
 CellTags->"InterpolatingFunction::dmval",
 CellLabel->"Out[2]=",
 CellID->375522222]
}, Open  ]],

Cell[TextData[{
 "There is no difficulty if the ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " expression is evaluated within the range of the interpolation."
}], "ExampleText",
 CellID->64133554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"interp", "[", "4", "]"}]], "Input",
 CellTags->"InterpolatingFunction::dmval",
 CellLabel->"In[3]:=",
 CellID->403789562],

Cell[BoxData["5.131111111111111`"], "Output",
 CellTags->"InterpolatingFunction::dmval",
 CellLabel->"Out[3]=",
 CellID->105868211]
}, Open  ]],

Cell[TextData[{
 "Clear the value of ",
 StyleBox["interp", "MR"],
 "."
}], "ExampleText",
 CellID->533192040],

Cell[BoxData[
 RowBox[{"Clear", "[", "interp", "]"}]], "Input",
 CellTags->"InterpolatingFunction::dmval",
 CellLabel->"In[4]:=",
 CellID->9588]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InterpolatingFunction::dmval - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 9, 22.9011818}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "InterpolatingFunction::dmval", "synonyms" -> {}, "title" -> 
    "InterpolatingFunction::dmval", "type" -> "Message", "uri" -> 
    "ref/message/dmval"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2017, 76, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->118704006]},
 "InterpolatingFunction::dmval"->{
  Cell[2919, 109, 465, 15, 70, "Input",
   CellTags->"InterpolatingFunction::dmval",
   CellID->17424],
  Cell[3387, 126, 315, 11, 70, "Output",
   CellTags->"InterpolatingFunction::dmval",
   CellID->198385816],
  Cell[3739, 142, 140, 4, 70, "Input",
   CellTags->"InterpolatingFunction::dmval",
   CellID->504],
  Cell[3882, 148, 311, 7, 70, "Message",
   CellTags->"InterpolatingFunction::dmval",
   CellID->337420538],
  Cell[4196, 157, 132, 3, 70, "Output",
   CellTags->"InterpolatingFunction::dmval",
   CellID->375522222],
  Cell[4668, 175, 145, 4, 70, "Input",
   CellTags->"InterpolatingFunction::dmval",
   CellID->403789562],
  Cell[4816, 181, 131, 3, 70, "Output",
   CellTags->"InterpolatingFunction::dmval",
   CellID->105868211],
  Cell[5075, 194, 144, 4, 70, "Input",
   CellTags->"InterpolatingFunction::dmval",
   CellID->9588]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6226, 227},
 {"InterpolatingFunction::dmval", 6380, 231}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 66, 1, 70, "ObjectName",
 CellID->12162],
Cell[CellGroupData[{
Cell[794, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1272, 49, 257, 6, 70, "Message",
 CellID->25066985],
Cell[1532, 57, 299, 8, 70, "Notes",
 CellID->6200],
Cell[1834, 67, 146, 4, 70, "Notes",
 CellID->12563]
}, Closed]],
Cell[CellGroupData[{
Cell[2017, 76, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->118704006],
Cell[CellGroupData[{
Cell[2402, 90, 147, 5, 70, "ExampleSection",
 CellID->88383547],
Cell[2552, 97, 342, 8, 70, "ExampleText",
 CellID->1174810],
Cell[CellGroupData[{
Cell[2919, 109, 465, 15, 70, "Input",
 CellTags->"InterpolatingFunction::dmval",
 CellID->17424],
Cell[3387, 126, 315, 11, 70, "Output",
 CellTags->"InterpolatingFunction::dmval",
 CellID->198385816]
}, Open  ]],
Cell[CellGroupData[{
Cell[3739, 142, 140, 4, 70, "Input",
 CellTags->"InterpolatingFunction::dmval",
 CellID->504],
Cell[3882, 148, 311, 7, 70, "Message",
 CellTags->"InterpolatingFunction::dmval",
 CellID->337420538],
Cell[4196, 157, 132, 3, 70, "Output",
 CellTags->"InterpolatingFunction::dmval",
 CellID->375522222]
}, Open  ]],
Cell[4343, 163, 300, 8, 70, "ExampleText",
 CellID->64133554],
Cell[CellGroupData[{
Cell[4668, 175, 145, 4, 70, "Input",
 CellTags->"InterpolatingFunction::dmval",
 CellID->403789562],
Cell[4816, 181, 131, 3, 70, "Output",
 CellTags->"InterpolatingFunction::dmval",
 CellID->105868211]
}, Open  ]],
Cell[4962, 187, 110, 5, 70, "ExampleText",
 CellID->533192040],
Cell[5075, 194, 144, 4, 70, "Input",
 CellTags->"InterpolatingFunction::dmval",
 CellID->9588]
}, Open  ]]
}, Open  ]],
Cell[5246, 202, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

