(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10261,        367]
NotebookOptionsPosition[      5998,        234]
NotebookOutlinePosition[      8334,        301]
CellTagsIndexPosition[      8203,        295]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["InterpolatingFunction::dmvali", "ObjectName",
 CellID->15738],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"InterpolatingFunction", "::", "\<\"dmvali\"\>"}], ":", 
  " ", "\<\"The integration endpoint `1` in dimension `2` lies outside the \
range of data in the interpolating function. Extrapolation will be \
used.\"\>"}]], "Message", "MSG",
 CellID->412780970],

Cell[TextData[{
 "Generated when an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " expression is integrated and the range of integration extends outside of  \
the range of the interpolation."
}], "Notes",
 CellID->23915],

Cell["\<\
Although this message  does not necessarily represent an error, extrapolation \
beyond the range of  interpolation can give unexpected or misleading results.\
\
\>", "Notes",
 CellID->2141]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->351314349],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->26207698],

Cell["\<\
A warning message is generated in this example because computation of the \
integral requires extrapolation beyond the range of interpolation of the \
integrand.\
\>", "ExampleText",
 CellID->58058164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"interp", "=", 
  RowBox[{"FunctionInterpolation", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "Pi"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"InterpolatingFunction::dmvali",
 CellLabel->"In[1]:=",
 CellID->7052],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "3.141592653589793`"}], "}"}], "}"}], 
    ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"InterpolatingFunction::dmvali",
 CellLabel->"Out[1]=",
 CellID->154808525]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"interp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellTags->"InterpolatingFunction::dmvali",
 CellLabel->"In[2]:=",
 CellID->1630],

Cell[BoxData[
 RowBox[{
  RowBox[{"InterpolatingFunction", "::", "\<\"dmvali\"\>"}], ":", 
  " ", "\<\"The integration endpoint \\!\\(2\\\\ \[Pi]\\) in dimension \
\\!\\(1\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"\>"}]], "Message", "MSG",
 CellTags->"InterpolatingFunction::dmvali",
 CellID->14949085],

Cell[BoxData["1.100729341270092`"], "Output",
 CellTags->"InterpolatingFunction::dmvali",
 CellLabel->"Out[2]=",
 CellID->279867271]
}, Open  ]],

Cell["\<\
A more accurate result can be computed by extending the range of \
interpolation.\
\>", "ExampleText",
 CellID->90674557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"interp", "=", 
  RowBox[{"FunctionInterpolation", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"2", " ", "Pi"}]}], "}"}]}], "]"}]}]], "Input",
 CellTags->"InterpolatingFunction::dmvali",
 CellLabel->"In[3]:=",
 CellID->15604516],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "6.283185307179586`"}], "}"}], "}"}], 
    ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"InterpolatingFunction::dmvali",
 CellLabel->"Out[3]=",
 CellID->229434571]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"interp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellTags->"InterpolatingFunction::dmvali",
 CellLabel->"In[4]:=",
 CellID->14639],

Cell[BoxData[
 RowBox[{"-", "9.8879238130678`*^-17"}]], "Output",
 CellTags->"InterpolatingFunction::dmvali",
 CellLabel->"Out[4]=",
 CellID->576555292]
}, Open  ]],

Cell[TextData[{
 "Clear the value of ",
 StyleBox["interp", "MR"],
 "."
}], "ExampleText",
 CellID->78670053],

Cell[BoxData[
 RowBox[{"Clear", "[", "interp", "]"}]], "Input",
 CellTags->"InterpolatingFunction::dmvali",
 CellLabel->"In[5]:=",
 CellID->30456]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InterpolatingFunction::dmvali - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 9, 22.7293024}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "InterpolatingFunction::dmvali", "synonyms" -> {}, "title" -> 
    "InterpolatingFunction::dmvali", "type" -> "Message", "uri" -> 
    "ref/message/dmvali"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2128, 78, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->351314349]},
 "InterpolatingFunction::dmvali"->{
  Cell[2899, 108, 302, 9, 70, "Input",
   CellTags->"InterpolatingFunction::dmvali",
   CellID->7052],
  Cell[3204, 119, 336, 12, 70, "Output",
   CellTags->"InterpolatingFunction::dmvali",
   CellID->154808525],
  Cell[3577, 136, 282, 9, 70, "Input",
   CellTags->"InterpolatingFunction::dmvali",
   CellID->1630],
  Cell[3862, 147, 356, 7, 70, "Message",
   CellTags->"InterpolatingFunction::dmvali",
   CellID->14949085],
  Cell[4221, 156, 132, 3, 70, "Output",
   CellTags->"InterpolatingFunction::dmvali",
   CellID->279867271],
  Cell[4524, 170, 333, 10, 70, "Input",
   CellTags->"InterpolatingFunction::dmvali",
   CellID->15604516],
  Cell[4860, 182, 336, 12, 70, "Output",
   CellTags->"InterpolatingFunction::dmvali",
   CellID->229434571],
  Cell[5233, 199, 283, 9, 70, "Input",
   CellTags->"InterpolatingFunction::dmvali",
   CellID->14639],
  Cell[5519, 210, 152, 4, 70, "Output",
   CellTags->"InterpolatingFunction::dmvali",
   CellID->576555292],
  Cell[5798, 224, 146, 4, 70, "Input",
   CellTags->"InterpolatingFunction::dmvali",
   CellID->30456]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6955, 257},
 {"InterpolatingFunction::dmvali", 7110, 261}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 67, 1, 70, "ObjectName",
 CellID->15738],
Cell[CellGroupData[{
Cell[795, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1273, 49, 289, 6, 70, "Message",
 CellID->412780970],
Cell[1565, 57, 324, 9, 70, "Notes",
 CellID->23915],
Cell[1892, 68, 199, 5, 70, "Notes",
 CellID->2141]
}, Closed]],
Cell[CellGroupData[{
Cell[2128, 78, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->351314349],
Cell[CellGroupData[{
Cell[2513, 92, 147, 5, 70, "ExampleSection",
 CellID->26207698],
Cell[2663, 99, 211, 5, 70, "ExampleText",
 CellID->58058164],
Cell[CellGroupData[{
Cell[2899, 108, 302, 9, 70, "Input",
 CellTags->"InterpolatingFunction::dmvali",
 CellID->7052],
Cell[3204, 119, 336, 12, 70, "Output",
 CellTags->"InterpolatingFunction::dmvali",
 CellID->154808525]
}, Open  ]],
Cell[CellGroupData[{
Cell[3577, 136, 282, 9, 70, "Input",
 CellTags->"InterpolatingFunction::dmvali",
 CellID->1630],
Cell[3862, 147, 356, 7, 70, "Message",
 CellTags->"InterpolatingFunction::dmvali",
 CellID->14949085],
Cell[4221, 156, 132, 3, 70, "Output",
 CellTags->"InterpolatingFunction::dmvali",
 CellID->279867271]
}, Open  ]],
Cell[4368, 162, 131, 4, 70, "ExampleText",
 CellID->90674557],
Cell[CellGroupData[{
Cell[4524, 170, 333, 10, 70, "Input",
 CellTags->"InterpolatingFunction::dmvali",
 CellID->15604516],
Cell[4860, 182, 336, 12, 70, "Output",
 CellTags->"InterpolatingFunction::dmvali",
 CellID->229434571]
}, Open  ]],
Cell[CellGroupData[{
Cell[5233, 199, 283, 9, 70, "Input",
 CellTags->"InterpolatingFunction::dmvali",
 CellID->14639],
Cell[5519, 210, 152, 4, 70, "Output",
 CellTags->"InterpolatingFunction::dmvali",
 CellID->576555292]
}, Open  ]],
Cell[5686, 217, 109, 5, 70, "ExampleText",
 CellID->78670053],
Cell[5798, 224, 146, 4, 70, "Input",
 CellTags->"InterpolatingFunction::dmvali",
 CellID->30456]
}, Open  ]]
}, Open  ]],
Cell[5971, 232, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

