(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6291,        227]
NotebookOptionsPosition[      4197,        160]
NotebookOutlinePosition[      5385,        195]
CellTagsIndexPosition[      5301,        190]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["InterpolatingPolynomial::poised", "ObjectName"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"InterpolatingPolynomial", "::", "\<\"poised\"\>"}], ":", 
  " ", "\<\"The interpolation points `1` are not poised, so an interpolating \
polynomial of total degree `2` could not be found.\"\>"}]], "Message", "MSG",
 CellID->689413388],

Cell["\<\
Generated when the data points to be interpolated lie on a manifold with \
lower dimension than requested.\
\>", "Notes"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19819735],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->478289147],

Cell["Points with abscissas lying on a line in 2 dimensions:", "ExampleText",
 CellID->19854453],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], ",", "4"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->591039839],

Cell["\<\
In multiple dimensions an interpolant may not be found for some arrangements \
of points:\
\>", "ExampleText",
 CellID->533158672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InterpolatingPolynomial", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->65706371],

Cell[BoxData[
 RowBox[{
  RowBox[{"InterpolatingPolynomial", "::", "\<\"poised\"\>"}], ":", 
  " ", "\<\"The interpolation points \\!\\({\\(\\({0, 0}\\)\\), \\(\\({1, \
1}\\)\\), \\(\\({2, 2}\\)\\)}\\) are not poised, so an interpolating \
polynomial of total degree \\!\\(1\\) could not be found.\"\>"}]], "Message", \
"MSG",
 CellID->836665269],

Cell[BoxData[
 RowBox[{"InterpolatingPolynomial", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->34872654]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InterpolatingPolynomial::poised - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 9, 30.5420024}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "InterpolatingPolynomial::poised", "synonyms" -> {}, "title" -> 
    "InterpolatingPolynomial::poised", "type" -> "Message", "uri" -> 
    "ref/message/poised"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1699, 63, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->19819735]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5160, 183}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 0, 70, "ObjectName"],
Cell[CellGroupData[{
Cell[781, 31, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 48, 269, 5, 70, "Message",
 CellID->689413388],
Cell[1531, 55, 131, 3, 70, "Notes"]
}, Closed]],
Cell[CellGroupData[{
Cell[1699, 63, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19819735],
Cell[CellGroupData[{
Cell[2083, 77, 148, 5, 70, "ExampleSection",
 CellID->478289147],
Cell[2234, 84, 96, 1, 70, "ExampleText",
 CellID->19854453],
Cell[2333, 87, 505, 19, 70, "Input",
 CellID->591039839],
Cell[2841, 108, 140, 4, 70, "ExampleText",
 CellID->533158672],
Cell[CellGroupData[{
Cell[3006, 116, 193, 6, 70, "Input",
 CellID->65706371],
Cell[3202, 124, 346, 7, 70, "Message",
 CellID->836665269],
Cell[3551, 133, 580, 20, 70, "Output",
 CellID->34872654]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4170, 158, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

