(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12245,        459]
NotebookOptionsPosition[      7490,        306]
NotebookOutlinePosition[      9956,        379]
CellTagsIndexPosition[      9830,        373]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["LUBackSubstitution::bpvt", "ObjectName",
 CellID->15835],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"LUBackSubstitution", "::", "\<\"bpvt\"\>"}], ":", 
  " ", "\<\"The pivot vector `1` is invalid.\"\>"}]], "Message", "MSG",
 CellID->2584817],

Cell[TextData[{
 "Generated when the second element in the data  expression passed to ",
 Cell[BoxData["LUBackSubstitution"], "InlineFormula"],
 " is not a list of integers in the required range."
}], "Notes",
 CellID->14982],

Cell["\<\
 This message can occur if a data expression is entered incorrectly. \
\>", "Notes",
 CellID->30400],

Cell[TextData[{
 "A valid data expression can be obtained using ",
 Cell[BoxData[
  ButtonBox["LUDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LUDecomposition"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->29362]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->368809844],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->14187582],

Cell["\<\
An error occurs in this example because the second element in the data \
expression is not a list of positive integers.\
\>", "ExampleText",
 CellID->538910579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LUBackSubstitution", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"LUBackSubstitution::bpvt",
 CellLabel->"In[1]:=",
 CellID->16955],

Cell[BoxData[
 RowBox[{
  RowBox[{"LUBackSubstitution", "::", "\<\"bpvt\"\>"}], ":", 
  " ", "\<\"The pivot vector \\!\\({0, \\(\\({}\\)\\)}\\) is \
invalid.\"\>"}]], "Message", "MSG",
 CellTags->"LUBackSubstitution::bpvt",
 CellID->133891471],

Cell[BoxData[
 RowBox[{"LUBackSubstitution", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}]], "Output",
 CellTags->"LUBackSubstitution::bpvt",
 CellLabel->"Out[1]=",
 CellID->85978084]
}, Open  ]],

Cell[TextData[{
 "This shows a valid data expression in ",
 Cell[BoxData["LUBackSubstitution"], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->509632481],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LUBackSubstitution", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"LUBackSubstitution::bpvt",
 CellLabel->"In[2]:=",
 CellID->56899883],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 CellTags->"LUBackSubstitution::bpvt",
 CellLabel->"Out[2]=",
 CellID->51219385]
}, Open  ]],

Cell[TextData[{
 "A valid data expression for use in ",
 Cell[BoxData["LUBackSubstitution"], "InlineFormula"],
 " can be constructed using ",
 Cell[BoxData[
  ButtonBox["LUDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LUDecomposition"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->741408640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ludec", "=", 
  RowBox[{"LUDecomposition", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellTags->"LUBackSubstitution::bpvt",
 CellLabel->"In[3]:=",
 CellID->17027],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", "1"}], "}"}]], "Output",
 CellTags->"LUBackSubstitution::bpvt",
 CellLabel->"Out[3]=",
 CellID->326604706]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LUBackSubstitution", "[", 
  RowBox[{"ludec", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"LUBackSubstitution::bpvt",
 CellLabel->"In[4]:=",
 CellID->27853],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 CellTags->"LUBackSubstitution::bpvt",
 CellLabel->"Out[4]=",
 CellID->267279177]
}, Open  ]],

Cell["\<\
This particular example corresponds to solving a pair of linear equations.\
\>", "ExampleText",
 CellID->108974102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"LUBackSubstitution::bpvt",
 CellLabel->"In[5]:=",
 CellID->7780],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 CellTags->"LUBackSubstitution::bpvt",
 CellLabel->"Out[5]=",
 CellID->240655353]
}, Open  ]],

Cell[TextData[{
 "Clear the value of ",
 StyleBox["ludec", "MR"],
 "."
}], "ExampleText",
 CellID->385973344],

Cell[BoxData[
 RowBox[{"Clear", "[", "ludec", "]"}]], "Input",
 CellTags->"LUBackSubstitution::bpvt",
 CellLabel->"In[6]:=",
 CellID->25837]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LUBackSubstitution::bpvt - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 11, 14.4509124}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "LUBackSubstitution::bpvt", "synonyms" -> {}, "title" -> 
    "LUBackSubstitution::bpvt", "type" -> "Message", "uri" -> 
    "ref/message/bpvt"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2057, 80, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->368809844]},
 "LUBackSubstitution::bpvt"->{
  Cell[2787, 109, 523, 18, 70, "Input",
   CellTags->"LUBackSubstitution::bpvt",
   CellID->16955],
  Cell[3313, 129, 243, 6, 70, "Message",
   CellTags->"LUBackSubstitution::bpvt",
   CellID->133891471],
  Cell[3559, 137, 527, 18, 70, "Output",
   CellTags->"LUBackSubstitution::bpvt",
   CellID->85978084],
  Cell[4283, 167, 503, 17, 70, "Input",
   CellTags->"LUBackSubstitution::bpvt",
   CellID->56899883],
  Cell[4789, 186, 173, 6, 70, "Output",
   CellTags->"LUBackSubstitution::bpvt",
   CellID->51219385],
  Cell[5320, 209, 328, 11, 70, "Input",
   CellTags->"LUBackSubstitution::bpvt",
   CellID->17027],
  Cell[5651, 222, 369, 13, 70, "Output",
   CellTags->"LUBackSubstitution::bpvt",
   CellID->326604706],
  Cell[6057, 240, 225, 7, 70, "Input",
   CellTags->"LUBackSubstitution::bpvt",
   CellID->27853],
  Cell[6285, 249, 174, 6, 70, "Output",
   CellTags->"LUBackSubstitution::bpvt",
   CellID->267279177],
  Cell[6624, 265, 368, 13, 70, "Input",
   CellTags->"LUBackSubstitution::bpvt",
   CellID->7780],
  Cell[6995, 280, 174, 6, 70, "Output",
   CellTags->"LUBackSubstitution::bpvt",
   CellID->240655353],
  Cell[7296, 296, 140, 4, 70, "Input",
   CellTags->"LUBackSubstitution::bpvt",
   CellID->25837]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8431, 329},
 {"LUBackSubstitution::bpvt", 8581, 333}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 62, 1, 70, "ObjectName",
 CellID->15835],
Cell[CellGroupData[{
Cell[790, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1268, 49, 175, 4, 70, "Message",
 CellID->2584817],
Cell[1446, 55, 225, 5, 70, "Notes",
 CellID->14982],
Cell[1674, 62, 110, 3, 70, "Notes",
 CellID->30400],
Cell[1787, 67, 233, 8, 70, "Notes",
 CellID->29362]
}, Closed]],
Cell[CellGroupData[{
Cell[2057, 80, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->368809844],
Cell[CellGroupData[{
Cell[2442, 94, 147, 5, 70, "ExampleSection",
 CellID->14187582],
Cell[2592, 101, 170, 4, 70, "ExampleText",
 CellID->538910579],
Cell[CellGroupData[{
Cell[2787, 109, 523, 18, 70, "Input",
 CellTags->"LUBackSubstitution::bpvt",
 CellID->16955],
Cell[3313, 129, 243, 6, 70, "Message",
 CellTags->"LUBackSubstitution::bpvt",
 CellID->133891471],
Cell[3559, 137, 527, 18, 70, "Output",
 CellTags->"LUBackSubstitution::bpvt",
 CellID->85978084]
}, Open  ]],
Cell[4101, 158, 157, 5, 70, "ExampleText",
 CellID->509632481],
Cell[CellGroupData[{
Cell[4283, 167, 503, 17, 70, "Input",
 CellTags->"LUBackSubstitution::bpvt",
 CellID->56899883],
Cell[4789, 186, 173, 6, 70, "Output",
 CellTags->"LUBackSubstitution::bpvt",
 CellID->51219385]
}, Open  ]],
Cell[4977, 195, 318, 10, 70, "ExampleText",
 CellID->741408640],
Cell[CellGroupData[{
Cell[5320, 209, 328, 11, 70, "Input",
 CellTags->"LUBackSubstitution::bpvt",
 CellID->17027],
Cell[5651, 222, 369, 13, 70, "Output",
 CellTags->"LUBackSubstitution::bpvt",
 CellID->326604706]
}, Open  ]],
Cell[CellGroupData[{
Cell[6057, 240, 225, 7, 70, "Input",
 CellTags->"LUBackSubstitution::bpvt",
 CellID->27853],
Cell[6285, 249, 174, 6, 70, "Output",
 CellTags->"LUBackSubstitution::bpvt",
 CellID->267279177]
}, Open  ]],
Cell[6474, 258, 125, 3, 70, "ExampleText",
 CellID->108974102],
Cell[CellGroupData[{
Cell[6624, 265, 368, 13, 70, "Input",
 CellTags->"LUBackSubstitution::bpvt",
 CellID->7780],
Cell[6995, 280, 174, 6, 70, "Output",
 CellTags->"LUBackSubstitution::bpvt",
 CellID->240655353]
}, Open  ]],
Cell[7184, 289, 109, 5, 70, "ExampleText",
 CellID->385973344],
Cell[7296, 296, 140, 4, 70, "Input",
 CellTags->"LUBackSubstitution::bpvt",
 CellID->25837]
}, Open  ]]
}, Open  ]],
Cell[7463, 304, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

