(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7631,        293]
NotebookOptionsPosition[      4803,        197]
NotebookOutlinePosition[      6419,        248]
CellTagsIndexPosition[      6306,        242]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Limit::ldir", "ObjectName",
 CellID->22406],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "::", "\<\"ldir\"\>"}], ":", 
  " ", "\<\"Value of Direction -> `1` should be a number or \
Automatic.\"\>"}]], "Message", "MSG",
 CellID->139341879],

Cell[TextData[{
 "Generated when the value of the ",
 Cell[BoxData[
  ButtonBox["Direction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Direction"]], "InlineFormula"],
 " option in ",
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 " is not a number or ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9745],

Cell[TextData[{
 "The default value of the ",
 Cell[BoxData[
  ButtonBox["Direction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Direction"]], "InlineFormula"],
 " option is ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", which is equivalent to ",
 StyleBox["Direction->-1", "MR"],
 " for finite limits points."
}], "Notes",
 CellID->18711]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->453291452],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->332010434],

Cell[TextData[{
 "The symbol ",
 Cell[BoxData[
  ButtonBox["Negative",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Negative"]], "InlineFormula"],
 " is not a valid value for the ",
 Cell[BoxData[
  ButtonBox["Direction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Direction"]], "InlineFormula"],
 " option in ",
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->114813421],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", 
   RowBox[{"x", "->", "0"}], ",", 
   RowBox[{"Direction", "->", "Negative"}]}], "]"}]], "Input",
 CellTags->"Limit::ldir",
 CellLabel->"In[1]:=",
 CellID->29801],

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "::", "\<\"ldir\"\>"}], ":", 
  " ", "\<\"Value of Direction -> \\!\\(Negative\\) should be a number or \
Automatic.\"\>"}]], "Message", "MSG",
 CellTags->"Limit::ldir",
 CellID->380490834],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox["1", "x"], ",", 
   RowBox[{"x", "\[Rule]", "0"}], ",", 
   RowBox[{"Direction", "\[Rule]", "Negative"}]}], "]"}]], "Output",
 CellTags->"Limit::ldir",
 CellLabel->"Out[1]=",
 CellID->264032060]
}, Open  ]],

Cell[TextData[{
 StyleBox["Direction->1", "MR"],
 " causes the limit point to be approached from the negative side."
}], "ExampleText",
 CellID->278108971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", 
   RowBox[{"x", "->", "0"}], ",", 
   RowBox[{"Direction", "->", "1"}]}], "]"}]], "Input",
 CellTags->"Limit::ldir",
 CellLabel->"In[2]:=",
 CellID->28745],

Cell[BoxData[
 RowBox[{"-", "\[Infinity]"}]], "Output",
 CellTags->"Limit::ldir",
 CellLabel->"Out[2]=",
 CellID->17320814]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Limit::ldir - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 10, 10.6524042}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Limit::ldir", "synonyms" -> {}, "title" -> "Limit::ldir", 
    "type" -> "Message", "uri" -> "ref/message/ldir"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2397, 96, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->453291452]},
 "Limit::ldir"->{
  Cell[3437, 139, 245, 8, 70, "Input",
   CellTags->"Limit::ldir",
   CellID->29801],
  Cell[3685, 149, 232, 6, 70, "Message",
   CellTags->"Limit::ldir",
   CellID->380490834],
  Cell[3920, 157, 258, 8, 70, "Output",
   CellTags->"Limit::ldir",
   CellID->264032060],
  Cell[4373, 176, 238, 8, 70, "Input",
   CellTags->"Limit::ldir",
   CellID->28745],
  Cell[4614, 186, 123, 4, 70, "Output",
   CellTags->"Limit::ldir",
   CellID->17320814]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5700, 219},
 {"Limit::ldir", 5837, 223}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 49, 1, 70, "ObjectName",
 CellID->22406],
Cell[CellGroupData[{
Cell[777, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1255, 49, 192, 5, 70, "Message",
 CellID->139341879],
Cell[1450, 56, 481, 18, 70, "Notes",
 CellID->9745],
Cell[1934, 76, 426, 15, 70, "Notes",
 CellID->18711]
}, Closed]],
Cell[CellGroupData[{
Cell[2397, 96, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->453291452],
Cell[CellGroupData[{
Cell[2782, 110, 148, 5, 70, "ExampleSection",
 CellID->332010434],
Cell[2933, 117, 479, 18, 70, "ExampleText",
 CellID->114813421],
Cell[CellGroupData[{
Cell[3437, 139, 245, 8, 70, "Input",
 CellTags->"Limit::ldir",
 CellID->29801],
Cell[3685, 149, 232, 6, 70, "Message",
 CellTags->"Limit::ldir",
 CellID->380490834],
Cell[3920, 157, 258, 8, 70, "Output",
 CellTags->"Limit::ldir",
 CellID->264032060]
}, Open  ]],
Cell[4193, 168, 155, 4, 70, "ExampleText",
 CellID->278108971],
Cell[CellGroupData[{
Cell[4373, 176, 238, 8, 70, "Input",
 CellTags->"Limit::ldir",
 CellID->28745],
Cell[4614, 186, 123, 4, 70, "Output",
 CellTags->"Limit::ldir",
 CellID->17320814]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4776, 195, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

