(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5786,        217]
NotebookOptionsPosition[      3459,        139]
NotebookOutlinePosition[      4895,        184]
CellTagsIndexPosition[      4782,        178]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Limit::limf", "ObjectName",
 CellID->18137],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "::", "\<\"limf\"\>"}], ":", 
  " ", "\<\"Unable to determine limit direction from `1`.\"\>"}]], "Message", \
"MSG",
 CellID->600481604],

Cell[TextData[{
 "Generated when the limit point is ",
 StyleBox["DirectedInfinity[", "MR"],
 StyleBox["b", "MR",
  FontSlant->"Italic"],
 StyleBox["]", "MR"],
 " with a symbolic value of ",
 StyleBox["b", "MR",
  FontSlant->"Italic"],
 "."
}], "Notes",
 CellID->21566]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->126833956],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->551404230],

Cell[TextData[{
 "An error occurs in this example because the direction of the limit cannot  \
be determined if the limit point is a symbolic ",
 Cell[BoxData[
  ButtonBox["DirectedInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DirectedInfinity"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->381975914],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"x", "->", 
    RowBox[{"DirectedInfinity", "[", "b", "]"}]}]}], "]"}]], "Input",
 CellTags->"Limit::limf",
 CellLabel->"In[1]:=",
 CellID->568],

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "::", "\<\"limf\"\>"}], ":", 
  " ", "\<\"Unable to determine limit direction from \\!\\(x \[Rule] \
\\(\\(DirectedInfinity[b]\\)\\)\\).\"\>"}]], "Message", "MSG",
 CellTags->"Limit::limf",
 CellID->354630876],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "x"], ",", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"DirectedInfinity", "[", "b", "]"}]}]}], "]"}]], "Output",
 CellTags->"Limit::limf",
 CellLabel->"Out[1]=",
 CellID->4566364]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Limit::limf - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 10, 10.8086582}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Limit::limf", "synonyms" -> {}, "title" -> "Limit::limf", 
    "type" -> "Message", "uri" -> "ref/message/limf"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1743, 72, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->126833956]},
 "Limit::limf"->{
  Cell[2627, 106, 245, 8, 70, "Input",
   CellTags->"Limit::limf",
   CellID->568],
  Cell[2875, 116, 252, 6, 70, "Message",
   CellTags->"Limit::limf",
   CellID->354630876],
  Cell[3130, 124, 263, 8, 70, "Output",
   CellTags->"Limit::limf",
   CellID->4566364]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4356, 161},
 {"Limit::limf", 4493, 165}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 49, 1, 70, "ObjectName",
 CellID->18137],
Cell[CellGroupData[{
Cell[777, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1255, 49, 179, 5, 70, "Message",
 CellID->600481604],
Cell[1437, 56, 269, 11, 70, "Notes",
 CellID->21566]
}, Closed]],
Cell[CellGroupData[{
Cell[1743, 72, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->126833956],
Cell[CellGroupData[{
Cell[2128, 86, 148, 5, 70, "ExampleSection",
 CellID->551404230],
Cell[2279, 93, 323, 9, 70, "ExampleText",
 CellID->381975914],
Cell[CellGroupData[{
Cell[2627, 106, 245, 8, 70, "Input",
 CellTags->"Limit::limf",
 CellID->568],
Cell[2875, 116, 252, 6, 70, "Message",
 CellTags->"Limit::limf",
 CellID->354630876],
Cell[3130, 124, 263, 8, 70, "Output",
 CellTags->"Limit::limf",
 CellID->4566364]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[3432, 137, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

