(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9186,        307]
NotebookOptionsPosition[      5277,        195]
NotebookOutlinePosition[      7848,        264]
CellTagsIndexPosition[      7687,        257]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
ListConvolve::kldims
ListCorrelate::kldims\
\>", "ObjectName",
 CellID->5044],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"kldims\"\>"}], ":", 
  " ", "\<\"The kernel `1` and list `2` are not both nonempty lists with the \
same tensor rank.\"\>"}]], "Message", "MSG",
 CellID->96598862],

Cell[TextData[{
 "Generated when the tensor rank of the first argument  in ",
 Cell[BoxData[
  ButtonBox["ListConvolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListConvolve"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["ListCorrelate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListCorrelate"]], "InlineFormula"],
 " is not the same as the tensor rank of the second argument."
}], "Notes",
 CellID->29571]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->677137115],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->143178123],

Cell["\<\
An error occurs in this example because the tensor rank of the first argument \
is not the same as the tensor rank of the second argument.\
\>", "ExampleText",
 CellID->178572930],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"k1", ",", "k2", ",", "k3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "d1", "}"}], ",", 
     RowBox[{"{", "d2", "}"}], ",", 
     RowBox[{"{", "d3", "}"}]}], "}"}]}], "]"}]], "Input",
 CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"},
 CellLabel->"In[1]:=",
 CellID->27898],

Cell[BoxData[
 RowBox[{
  RowBox[{"ListConvolve", "::", "\<\"kldims\"\>"}], ":", 
  " ", "\<\"The kernel \\!\\({k1, k2, k3}\\) and list \
\\!\\({\\(\\({d1}\\)\\), \\(\\({d2}\\)\\), \\(\\({d3}\\)\\)}\\) are not both \
nonempty lists with the same tensor rank.\"\>"}]], "Message", "MSG",
 CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"},
 CellID->292330246],

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"k1", ",", "k2", ",", "k3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "d1", "}"}], ",", 
     RowBox[{"{", "d2", "}"}], ",", 
     RowBox[{"{", "d3", "}"}]}], "}"}]}], "]"}]], "Output",
 CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"},
 CellLabel->"Out[1]=",
 CellID->500542994]
}, Open  ]],

Cell[TextData[{
 "This gives an acyclic convolution, using the seventh argument in ",
 Cell[BoxData[
  ButtonBox["ListConvolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListConvolve"]], "InlineFormula"],
 " to specify the level to use from the first two arguments."
}], "ExampleText",
 CellID->100607816],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"k1", ",", "k2", ",", "k3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "d1", "}"}], ",", 
     RowBox[{"{", "d2", "}"}], ",", 
     RowBox[{"{", "d3", "}"}]}], "}"}], ",", "3", ",", "0", ",", "Times", ",",
    "Plus", ",", "1"}], "]"}]], "Input",
 CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"},
 CellLabel->"In[2]:=",
 CellID->10509],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"d3", " ", "k1"}], "+", 
     RowBox[{"d2", " ", "k2"}], "+", 
     RowBox[{"d1", " ", "k3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"d3", " ", "k2"}], "+", 
     RowBox[{"d2", " ", "k3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d3", " ", "k3"}], "}"}]}], "}"}]], "Output",
 CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"},
 CellLabel->"Out[2]=",
 CellID->61556162]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ListConvolve::kldims - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 10, 58.9505156}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "ListConvolve::kldims ListCorrelate::kldims", 
    "synonyms" -> {}, "title" -> "ListConvolve::kldims", "type" -> "Message", 
    "uri" -> "ref/message/kldims"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2007, 78, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->677137115]},
 "ListConvolve::kldims"->{
  Cell[2757, 107, 391, 12, 70, "Input",
   CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"},
   CellID->27898],
  Cell[3151, 121, 367, 7, 70, "Message",
   CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"},
   CellID->292330246],
  Cell[3521, 130, 396, 12, 70, "Output",
   CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"},
   CellID->500542994],
  Cell[4270, 157, 452, 13, 70, "Input",
   CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"},
   CellID->10509],
  Cell[4725, 172, 486, 16, 70, "Output",
   CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"},
   CellID->61556162]},
 "ListCorrelate::kldims"->{
  Cell[2757, 107, 391, 12, 70, "Input",
   CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"},
   CellID->27898],
  Cell[3151, 121, 367, 7, 70, "Message",
   CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"},
   CellID->292330246],
  Cell[3521, 130, 396, 12, 70, "Output",
   CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"},
   CellID->500542994],
  Cell[4270, 157, 452, 13, 70, "Input",
   CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"},
   CellID->10509],
  Cell[4725, 172, 486, 16, 70, "Output",
   CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"},
   CellID->61556162]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6230, 218},
 {"ListConvolve::kldims", 6376, 222},
 {"ListCorrelate::kldims", 7034, 238}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 87, 4, 70, "ObjectName",
 CellID->5044],
Cell[CellGroupData[{
Cell[815, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1293, 52, 240, 6, 70, "Message",
 CellID->96598862],
Cell[1536, 60, 434, 13, 70, "Notes",
 CellID->29571]
}, Closed]],
Cell[CellGroupData[{
Cell[2007, 78, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->677137115],
Cell[CellGroupData[{
Cell[2392, 92, 148, 5, 70, "ExampleSection",
 CellID->143178123],
Cell[2543, 99, 189, 4, 70, "ExampleText",
 CellID->178572930],
Cell[CellGroupData[{
Cell[2757, 107, 391, 12, 70, "Input",
 CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"},
 CellID->27898],
Cell[3151, 121, 367, 7, 70, "Message",
 CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"},
 CellID->292330246],
Cell[3521, 130, 396, 12, 70, "Output",
 CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"},
 CellID->500542994]
}, Open  ]],
Cell[3932, 145, 313, 8, 70, "ExampleText",
 CellID->100607816],
Cell[CellGroupData[{
Cell[4270, 157, 452, 13, 70, "Input",
 CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"},
 CellID->10509],
Cell[4725, 172, 486, 16, 70, "Output",
 CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"},
 CellID->61556162]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5250, 193, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

