(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11858,        389]
NotebookOptionsPosition[      4969,        192]
NotebookOutlinePosition[     10227,        336]
CellTagsIndexPosition[      9986,        327]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
Maximize::consf
Minimize::consf
Experimental`Infimum::consf
Experimental`Supremum::consf\
\>", "ObjectName",
 CellID->25491],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"consf\"\>"}], ":", 
  " ", "\<\"Invalid constraint `1` encountered. Constraints should be \
equations, inequalities, or variable domain specifications.\"\>"}]], "Message",\
 "MSG",
 CellID->473608420],

Cell["\<\
Generated when an expression listed after the objective function is not an \
equation, inequality, or domain specification.\
\>", "Notes",
 CellID->11896]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->202805818],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->4926093],

Cell[TextData[{
 "An error occurs in this example because the objective function is expected  \
to be the first element in the first argument of ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->160831032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", ">", "5"}], ",", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"16", "x"}], "+", "25"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellTags->{
  "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
   "Maximize::consf", "Minimize::consf"},
 CellLabel->"In[1]:=",
 CellID->7838],

Cell[BoxData[
 RowBox[{
  RowBox[{"Minimize", "::", "\<\"consf\"\>"}], ":", 
  " ", "\<\"Invalid constraint \\!\\(25 - \\(\\(16\\\\ x\\)\\) + x\\^2\\) \
encountered. Constraints should be equations, inequalities, or variable \
domain specifications.\"\>"}]], "Message", "MSG",
 CellTags->{
  "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
   "Maximize::consf", "Minimize::consf"},
 CellID->409634177],

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", ">", "5"}], ",", 
     RowBox[{"25", "-", 
      RowBox[{"16", " ", "x"}], "+", 
      SuperscriptBox["x", "2"]}]}], "}"}], ",", "x"}], "]"}]], "Output",
 CellTags->{
  "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
   "Maximize::consf", "Minimize::consf"},
 CellLabel->"Out[1]=",
 CellID->256759253]
}, Open  ]],

Cell[TextData[{
 "This shows a valid use of ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->191787149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"16", "x"}], "+", "25"}], ",", 
     RowBox[{"x", ">", "5"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellTags->{
  "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
   "Maximize::consf", "Minimize::consf"},
 CellLabel->"In[2]:=",
 CellID->9102],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "39"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "8"}], "}"}]}], "}"}]], "Output",
 CellTags->{
  "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
   "Maximize::consf", "Minimize::consf"},
 CellLabel->"Out[2]=",
 CellID->25235214]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Maximize::consf - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 11, 22.6073712}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Maximize::consf Minimize::consf Experimental`Infimum::consf \
Experimental`Supremum::consf", "synonyms" -> {}, "title" -> "Maximize::consf",
     "type" -> "Message", "uri" -> "ref/message/consf"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1821, 72, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->202805818]},
 "Experimental`Infimum::consf"->{
  Cell[2690, 106, 405, 13, 70, "Input",
   CellTags->{
    "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
     "Maximize::consf", "Minimize::consf"},
   CellID->7838],
  Cell[3098, 121, 417, 9, 70, "Message",
   CellTags->{
    "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
     "Maximize::consf", "Minimize::consf"},
   CellID->409634177],
  Cell[3518, 132, 417, 13, 70, "Output",
   CellTags->{
    "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
     "Maximize::consf", "Minimize::consf"},
   CellID->256759253],
  Cell[4184, 160, 405, 13, 70, "Input",
   CellTags->{
    "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
     "Maximize::consf", "Minimize::consf"},
   CellID->9102],
  Cell[4592, 175, 311, 10, 70, "Output",
   CellTags->{
    "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
     "Maximize::consf", "Minimize::consf"},
   CellID->25235214]},
 "Experimental`Supremum::consf"->{
  Cell[2690, 106, 405, 13, 70, "Input",
   CellTags->{
    "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
     "Maximize::consf", "Minimize::consf"},
   CellID->7838],
  Cell[3098, 121, 417, 9, 70, "Message",
   CellTags->{
    "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
     "Maximize::consf", "Minimize::consf"},
   CellID->409634177],
  Cell[3518, 132, 417, 13, 70, "Output",
   CellTags->{
    "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
     "Maximize::consf", "Minimize::consf"},
   CellID->256759253],
  Cell[4184, 160, 405, 13, 70, "Input",
   CellTags->{
    "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
     "Maximize::consf", "Minimize::consf"},
   CellID->9102],
  Cell[4592, 175, 311, 10, 70, "Output",
   CellTags->{
    "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
     "Maximize::consf", "Minimize::consf"},
   CellID->25235214]},
 "Maximize::consf"->{
  Cell[2690, 106, 405, 13, 70, "Input",
   CellTags->{
    "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
     "Maximize::consf", "Minimize::consf"},
   CellID->7838],
  Cell[3098, 121, 417, 9, 70, "Message",
   CellTags->{
    "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
     "Maximize::consf", "Minimize::consf"},
   CellID->409634177],
  Cell[3518, 132, 417, 13, 70, "Output",
   CellTags->{
    "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
     "Maximize::consf", "Minimize::consf"},
   CellID->256759253],
  Cell[4184, 160, 405, 13, 70, "Input",
   CellTags->{
    "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
     "Maximize::consf", "Minimize::consf"},
   CellID->9102],
  Cell[4592, 175, 311, 10, 70, "Output",
   CellTags->{
    "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
     "Maximize::consf", "Minimize::consf"},
   CellID->25235214]},
 "Minimize::consf"->{
  Cell[2690, 106, 405, 13, 70, "Input",
   CellTags->{
    "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
     "Maximize::consf", "Minimize::consf"},
   CellID->7838],
  Cell[3098, 121, 417, 9, 70, "Message",
   CellTags->{
    "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
     "Maximize::consf", "Minimize::consf"},
   CellID->409634177],
  Cell[3518, 132, 417, 13, 70, "Output",
   CellTags->{
    "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
     "Maximize::consf", "Minimize::consf"},
   CellID->256759253],
  Cell[4184, 160, 405, 13, 70, "Input",
   CellTags->{
    "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
     "Maximize::consf", "Minimize::consf"},
   CellID->9102],
  Cell[4592, 175, 311, 10, 70, "Output",
   CellTags->{
    "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
     "Maximize::consf", "Minimize::consf"},
   CellID->25235214]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5959, 216},
 {"Experimental`Infimum::consf", 6112, 220},
 {"Experimental`Supremum::consf", 7090, 246},
 {"Maximize::consf", 8055, 272},
 {"Minimize::consf", 9020, 298}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 134, 6, 70, "ObjectName",
 CellID->25491],
Cell[CellGroupData[{
Cell[862, 37, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1340, 54, 277, 7, 70, "Message",
 CellID->473608420],
Cell[1620, 63, 164, 4, 70, "Notes",
 CellID->11896]
}, Closed]],
Cell[CellGroupData[{
Cell[1821, 72, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->202805818],
Cell[CellGroupData[{
Cell[2206, 86, 146, 5, 70, "ExampleSection",
 CellID->4926093],
Cell[2355, 93, 310, 9, 70, "ExampleText",
 CellID->160831032],
Cell[CellGroupData[{
Cell[2690, 106, 405, 13, 70, "Input",
 CellTags->{
  "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
   "Maximize::consf", "Minimize::consf"},
 CellID->7838],
Cell[3098, 121, 417, 9, 70, "Message",
 CellTags->{
  "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
   "Maximize::consf", "Minimize::consf"},
 CellID->409634177],
Cell[3518, 132, 417, 13, 70, "Output",
 CellTags->{
  "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
   "Maximize::consf", "Minimize::consf"},
 CellID->256759253]
}, Open  ]],
Cell[3950, 148, 209, 8, 70, "ExampleText",
 CellID->191787149],
Cell[CellGroupData[{
Cell[4184, 160, 405, 13, 70, "Input",
 CellTags->{
  "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
   "Maximize::consf", "Minimize::consf"},
 CellID->9102],
Cell[4592, 175, 311, 10, 70, "Output",
 CellTags->{
  "Experimental`Infimum::consf", "Experimental`Supremum::consf", 
   "Maximize::consf", "Minimize::consf"},
 CellID->25235214]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4942, 190, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

