(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12916,        436]
NotebookOptionsPosition[      6121,        239]
NotebookOutlinePosition[     11297,        383]
CellTagsIndexPosition[     11059,        374]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
Maximize::vdom
Minimize::vdom
Experimental`Infimum::vdom
Experimental`Supremum::vdom\
\>", "ObjectName",
 CellID->20947],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"vdom\"\>"}], ":", 
  " ", "\<\"Variable domain `1` should be either Reals or Integers.\"\>"}]], \
"Message", "MSG",
 CellID->93857134],

Cell[TextData[{
 "Generated when a domain specification other than ",
 Cell[BoxData[
  ButtonBox["Reals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reals"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Integers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integers"]], "InlineFormula"],
 " is used in the indicated function."
}], "Notes",
 CellID->13190]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->804732637],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->679376032],

Cell[TextData[{
 "An error occurs in this example because ",
 Cell[BoxData[
  ButtonBox["Primes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Primes"]], "InlineFormula"],
 " is not a supported domain in ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->595482412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x", " ", "y"}], "+", 
      RowBox[{"5", " ", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"2", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"7", "y"}], "-", "x", "+", "5"}], ",", 
     RowBox[{"Element", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", "Primes"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellTags->{
  "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
   "Maximize::vdom", "Minimize::vdom"},
 CellLabel->"In[1]:=",
 CellID->24394],

Cell[BoxData[
 RowBox[{
  RowBox[{"Minimize", "::", "\<\"vdom\"\>"}], ":", 
  " ", "\<\"Variable domain \\!\\(Primes\\) should be either Reals or \
Integers.\"\>"}]], "Message", "MSG",
 CellTags->{
  "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
   "Maximize::vdom", "Minimize::vdom"},
 CellID->451528568],

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"5", "-", "x", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"7", " ", "y"}], "+", 
      RowBox[{"2", " ", "x", " ", "y"}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["y", "2"]}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "|", "y"}], ")"}], "\[Element]", "Primes"}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Output",
 CellTags->{
  "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
   "Maximize::vdom", "Minimize::vdom"},
 CellLabel->"Out[1]=",
 CellID->219585779]
}, Open  ]],

Cell[TextData[{
 "This shows a valid use of ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " with domain ",
 Cell[BoxData[
  ButtonBox["Integers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integers"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->465382857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x", " ", "y"}], "+", 
      RowBox[{"5", " ", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"2", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"7", "y"}], "-", "x", "+", "5"}], ",", 
     RowBox[{"Element", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellTags->{
  "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
   "Maximize::vdom", "Minimize::vdom"},
 CellLabel->"In[2]:=",
 CellID->18629],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], "}"}]], "Output",
 CellTags->{
  "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
   "Maximize::vdom", "Minimize::vdom"},
 CellLabel->"Out[2]=",
 CellID->816352308]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Maximize::vdom - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 11, 30.5919506}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Maximize::vdom Minimize::vdom Experimental`Infimum::vdom \
Experimental`Supremum::vdom", "synonyms" -> {}, "title" -> "Maximize::vdom", 
    "type" -> "Message", "uri" -> "ref/message/vdom"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1965, 80, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->804732637]},
 "Experimental`Infimum::vdom"->{
  Cell[2899, 118, 693, 23, 70, "Input",
   CellTags->{
    "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
     "Maximize::vdom", "Minimize::vdom"},
   CellID->24394],
  Cell[3595, 143, 321, 8, 70, "Message",
   CellTags->{
    "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
     "Maximize::vdom", "Minimize::vdom"},
   CellID->451528568],
  Cell[3919, 153, 684, 22, 70, "Output",
   CellTags->{
    "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
     "Maximize::vdom", "Minimize::vdom"},
   CellID->219585779],
  Cell[4989, 195, 695, 23, 70, "Input",
   CellTags->{
    "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
     "Maximize::vdom", "Minimize::vdom"},
   CellID->18629],
  Cell[5687, 220, 368, 12, 70, "Output",
   CellTags->{
    "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
     "Maximize::vdom", "Minimize::vdom"},
   CellID->816352308]},
 "Experimental`Supremum::vdom"->{
  Cell[2899, 118, 693, 23, 70, "Input",
   CellTags->{
    "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
     "Maximize::vdom", "Minimize::vdom"},
   CellID->24394],
  Cell[3595, 143, 321, 8, 70, "Message",
   CellTags->{
    "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
     "Maximize::vdom", "Minimize::vdom"},
   CellID->451528568],
  Cell[3919, 153, 684, 22, 70, "Output",
   CellTags->{
    "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
     "Maximize::vdom", "Minimize::vdom"},
   CellID->219585779],
  Cell[4989, 195, 695, 23, 70, "Input",
   CellTags->{
    "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
     "Maximize::vdom", "Minimize::vdom"},
   CellID->18629],
  Cell[5687, 220, 368, 12, 70, "Output",
   CellTags->{
    "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
     "Maximize::vdom", "Minimize::vdom"},
   CellID->816352308]},
 "Maximize::vdom"->{
  Cell[2899, 118, 693, 23, 70, "Input",
   CellTags->{
    "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
     "Maximize::vdom", "Minimize::vdom"},
   CellID->24394],
  Cell[3595, 143, 321, 8, 70, "Message",
   CellTags->{
    "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
     "Maximize::vdom", "Minimize::vdom"},
   CellID->451528568],
  Cell[3919, 153, 684, 22, 70, "Output",
   CellTags->{
    "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
     "Maximize::vdom", "Minimize::vdom"},
   CellID->219585779],
  Cell[4989, 195, 695, 23, 70, "Input",
   CellTags->{
    "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
     "Maximize::vdom", "Minimize::vdom"},
   CellID->18629],
  Cell[5687, 220, 368, 12, 70, "Output",
   CellTags->{
    "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
     "Maximize::vdom", "Minimize::vdom"},
   CellID->816352308]},
 "Minimize::vdom"->{
  Cell[2899, 118, 693, 23, 70, "Input",
   CellTags->{
    "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
     "Maximize::vdom", "Minimize::vdom"},
   CellID->24394],
  Cell[3595, 143, 321, 8, 70, "Message",
   CellTags->{
    "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
     "Maximize::vdom", "Minimize::vdom"},
   CellID->451528568],
  Cell[3919, 153, 684, 22, 70, "Output",
   CellTags->{
    "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
     "Maximize::vdom", "Minimize::vdom"},
   CellID->219585779],
  Cell[4989, 195, 695, 23, 70, "Input",
   CellTags->{
    "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
     "Maximize::vdom", "Minimize::vdom"},
   CellID->18629],
  Cell[5687, 220, 368, 12, 70, "Output",
   CellTags->{
    "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
     "Maximize::vdom", "Minimize::vdom"},
   CellID->816352308]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7104, 263},
 {"Experimental`Infimum::vdom", 7256, 267},
 {"Experimental`Supremum::vdom", 8216, 293},
 {"Maximize::vdom", 9163, 319},
 {"Minimize::vdom", 10110, 345}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 130, 6, 70, "ObjectName",
 CellID->20947],
Cell[CellGroupData[{
Cell[858, 37, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1336, 54, 211, 6, 70, "Message",
 CellID->93857134],
Cell[1550, 62, 378, 13, 70, "Notes",
 CellID->13190]
}, Closed]],
Cell[CellGroupData[{
Cell[1965, 80, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->804732637],
Cell[CellGroupData[{
Cell[2350, 94, 148, 5, 70, "ExampleSection",
 CellID->679376032],
Cell[2501, 101, 373, 13, 70, "ExampleText",
 CellID->595482412],
Cell[CellGroupData[{
Cell[2899, 118, 693, 23, 70, "Input",
 CellTags->{
  "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
   "Maximize::vdom", "Minimize::vdom"},
 CellID->24394],
Cell[3595, 143, 321, 8, 70, "Message",
 CellTags->{
  "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
   "Maximize::vdom", "Minimize::vdom"},
 CellID->451528568],
Cell[3919, 153, 684, 22, 70, "Output",
 CellTags->{
  "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
   "Maximize::vdom", "Minimize::vdom"},
 CellID->219585779]
}, Open  ]],
Cell[4618, 178, 346, 13, 70, "ExampleText",
 CellID->465382857],
Cell[CellGroupData[{
Cell[4989, 195, 695, 23, 70, "Input",
 CellTags->{
  "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
   "Maximize::vdom", "Minimize::vdom"},
 CellID->18629],
Cell[5687, 220, 368, 12, 70, "Output",
 CellTags->{
  "Experimental`Infimum::vdom", "Experimental`Supremum::vdom", 
   "Maximize::vdom", "Minimize::vdom"},
 CellID->816352308]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6094, 237, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

