(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11842,        442]
NotebookOptionsPosition[      7921,        310]
NotebookOutlinePosition[     10039,        376]
CellTagsIndexPosition[      9923,        370]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::bcnan", "ObjectName",
 CellID->25477],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"bcnan\"\>"}], ":", 
  " ", "\<\"Boundary conditions not numerical.\"\>"}]], "Message", "MSG",
 CellID->43542722],

Cell["\<\
Generated when the boundary conditions in a boundary value problem are not \
properly specified.\
\>", "Notes",
 CellID->1613]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->167886582],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->152307075],

Cell["\<\
This example will generate a message because one of the boundary conditions \
involves the variable of the differential equation.\
\>", "ExampleText",
 CellID->179224676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"f", "'"}], "'"}], "[", "x", "]"}], "+", 
       RowBox[{"f", "[", "x", "]"}]}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "==", "x"}], ",", 
     RowBox[{
      RowBox[{"f", "[", "2", "]"}], "==", "1"}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::bcnan",
 CellLabel->"In[1]:=",
 CellID->22419],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"bcnan\"\>"}], ":", 
  " ", "\<\"Boundary conditions not numerical.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::bcnan",
 CellID->105509651],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], "+", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "x", "]"}]}], "\[Equal]", "0"}], ",", 
     
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "\[Equal]", "x"}], ",", 
     RowBox[{
      RowBox[{"f", "[", "2", "]"}], "\[Equal]", "1"}]}], "}"}], ",", "f", ",",
    
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Output",
 CellTags->"NDSolve::bcnan",
 CellLabel->"Out[1]=",
 CellID->103209508]
}, Open  ]],

Cell["\<\
This shows a valid specification of a boundary value problem.\
\>", "ExampleText",
 CellID->147428284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"f", "'"}], "'"}], "[", "x", "]"}], "+", 
       RowBox[{"f", "[", "x", "]"}]}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"f", "[", "2", "]"}], "==", "1"}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::bcnan",
 CellLabel->"In[2]:=",
 CellID->9524],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1.`", ",", "2.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::bcnan",
 CellLabel->"Out[2]=",
 CellID->117189720]
}, Open  ]],

Cell["\<\
An error occurs in this example because a parameter in one of the boundary \
conditions does not have a numerical value.\
\>", "ExampleText",
 CellID->295640062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"f", "'"}], "'"}], "[", "x", "]"}], "+", 
       RowBox[{"f", "[", "x", "]"}]}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", "0", "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"b", " ", 
       RowBox[{"f", "[", "1", "]"}]}], "==", "1"}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::bcnan",
 CellLabel->"In[3]:=",
 CellID->242385813],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"bcnan\"\>"}], ":", 
  " ", "\<\"Boundary conditions not numerical.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::bcnan",
 CellID->366224571],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], "+", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "x", "]"}]}], "\[Equal]", "0"}], ",", 
     
     RowBox[{
      RowBox[{"f", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"b", " ", 
       RowBox[{"f", "[", "1", "]"}]}], "\[Equal]", "1"}]}], "}"}], ",", "f", 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Output",
 CellTags->"NDSolve::bcnan",
 CellLabel->"Out[3]=",
 CellID->685431196]
}, Open  ]],

Cell["\<\
This shows a valid specification of the solution of a boundary value problem.\
\
\>", "ExampleText",
 CellID->136035546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"b", "=", "2"}], "}"}], ",", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"f", "'"}], "'"}], "[", "x", "]"}], "+", 
         RowBox[{"f", "[", "x", "]"}]}], "==", "0"}], ",", 
       RowBox[{
        RowBox[{"f", "[", "0", "]"}], "==", "0"}], ",", 
       RowBox[{
        RowBox[{"b", " ", 
         RowBox[{"f", "[", "1", "]"}]}], "==", "1"}]}], "}"}], ",", "f", ",", 
     
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellTags->"NDSolve::bcnan",
 CellLabel->"In[4]:=",
 CellID->23622],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::bcnan",
 CellLabel->"Out[4]=",
 CellID->58576873]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::bcnan - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 11, 55.0457016}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::bcnan", "synonyms" -> {}, "title" -> 
    "NDSolve::bcnan", "type" -> "Message", "uri" -> "ref/message/bcnan"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1602, 64, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->167886582]},
 "NDSolve::bcnan"->{
  Cell[2343, 93, 566, 19, 70, "Input",
   CellTags->"NDSolve::bcnan",
   CellID->22419],
  Cell[2912, 114, 198, 5, 70, "Message",
   CellTags->"NDSolve::bcnan",
   CellID->105509651],
  Cell[3113, 121, 629, 21, 70, "Output",
   CellTags->"NDSolve::bcnan",
   CellID->103209508],
  Cell[3894, 152, 565, 19, 70, "Input",
   CellTags->"NDSolve::bcnan",
   CellID->9524],
  Cell[4462, 173, 407, 15, 70, "Output",
   CellTags->"NDSolve::bcnan",
   CellID->117189720],
  Cell[5080, 199, 598, 20, 70, "Input",
   CellTags->"NDSolve::bcnan",
   CellID->242385813],
  Cell[5681, 221, 198, 5, 70, "Message",
   CellTags->"NDSolve::bcnan",
   CellID->366224571],
  Cell[5882, 228, 657, 22, 70, "Output",
   CellTags->"NDSolve::bcnan",
   CellID->685431196],
  Cell[6709, 261, 737, 25, 70, "Input",
   CellTags->"NDSolve::bcnan",
   CellID->23622],
  Cell[7449, 288, 406, 15, 70, "Output",
   CellTags->"NDSolve::bcnan",
   CellID->58576873]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8828, 332},
 {"NDSolve::bcnan", 8968, 336}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->25477],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 168, 4, 70, "Message",
 CellID->43542722],
Cell[1429, 55, 136, 4, 70, "Notes",
 CellID->1613]
}, Closed]],
Cell[CellGroupData[{
Cell[1602, 64, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->167886582],
Cell[CellGroupData[{
Cell[1987, 78, 148, 5, 70, "ExampleSection",
 CellID->152307075],
Cell[2138, 85, 180, 4, 70, "ExampleText",
 CellID->179224676],
Cell[CellGroupData[{
Cell[2343, 93, 566, 19, 70, "Input",
 CellTags->"NDSolve::bcnan",
 CellID->22419],
Cell[2912, 114, 198, 5, 70, "Message",
 CellTags->"NDSolve::bcnan",
 CellID->105509651],
Cell[3113, 121, 629, 21, 70, "Output",
 CellTags->"NDSolve::bcnan",
 CellID->103209508]
}, Open  ]],
Cell[3757, 145, 112, 3, 70, "ExampleText",
 CellID->147428284],
Cell[CellGroupData[{
Cell[3894, 152, 565, 19, 70, "Input",
 CellTags->"NDSolve::bcnan",
 CellID->9524],
Cell[4462, 173, 407, 15, 70, "Output",
 CellTags->"NDSolve::bcnan",
 CellID->117189720]
}, Open  ]],
Cell[4884, 191, 171, 4, 70, "ExampleText",
 CellID->295640062],
Cell[CellGroupData[{
Cell[5080, 199, 598, 20, 70, "Input",
 CellTags->"NDSolve::bcnan",
 CellID->242385813],
Cell[5681, 221, 198, 5, 70, "Message",
 CellTags->"NDSolve::bcnan",
 CellID->366224571],
Cell[5882, 228, 657, 22, 70, "Output",
 CellTags->"NDSolve::bcnan",
 CellID->685431196]
}, Open  ]],
Cell[6554, 253, 130, 4, 70, "ExampleText",
 CellID->136035546],
Cell[CellGroupData[{
Cell[6709, 261, 737, 25, 70, "Input",
 CellTags->"NDSolve::bcnan",
 CellID->23622],
Cell[7449, 288, 406, 15, 70, "Output",
 CellTags->"NDSolve::bcnan",
 CellID->58576873]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[7894, 308, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

