(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10300,        349]
NotebookOptionsPosition[      7867,        269]
NotebookOutlinePosition[      9343,        314]
CellTagsIndexPosition[      9226,        308]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::bcnorm", "ObjectName",
 CellID->8649],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"bcnorm\"\>"}], ":", 
  " ", "\<\"Boundary condition `1` includes non-normal derivatives.\"\>"}]], \
"Message", "MSG",
 CellID->75194457],

Cell["\<\
Generated when a boundary condition for a partial differential equation \
involves derivatives that are not normal to the boundary.\
\>", "Notes",
 CellID->13488],

Cell["\<\
This problem can usually be resolved by checking that derivative boundary \
conditions are specified using the correct variable.\
\>", "Notes",
 CellID->6191]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->239810145],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->75025196],

Cell["\<\
An error occurs in this example because the boundary condition indicated in \
the message involves a derivative in a direction that is not perpendicular to \
the boundary.\
\>", "ExampleText",
 CellID->852654253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y", ",", "t"}], "]"}], ",", "t"}], "]"}], " ", 
      "\[Equal]", " ", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "t"}], "]"}], ",", "x", ",", "x"}], 
        "]"}], " ", "+", " ", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y", ",", "t"}], "]"}], ",", "y", ",", "y"}], 
        "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "y", ",", "0"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "10"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "1", ",", "0"}], "]"}], "[", "u", "]"}], "[", 
       RowBox[{"1", ",", "y", ",", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{"-", "10"}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "y", ",", "t"}], "]"}], " ", "\[Equal]", " ",
       
      RowBox[{"Exp", "[", 
       RowBox[{"-", "10"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "1", ",", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "10"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "10"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::bcnorm",
 CellLabel->"In[1]:=",
 CellID->2147],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"bcnorm\"\>"}], ":", 
  " ", "\<\"Boundary condition \\!\\(\\(\\(-\\(\\(1\\/\[ExponentialE]\\^10\\)\
\\)\\)\\) + \\(\\(\\(\\(\\*SuperscriptBox[\\\"u\\\", TagBox[\\((0, 1, 0)\\), \
Derivative], Rule[MultilineFunction, None]]\\)\\)[\\(\\(1, y, \
t\\)\\)]\\)\\)\\) includes non-normal derivatives.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::bcnorm",
 CellID->568809973],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["u", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "y", ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{
        SuperscriptBox["u", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"x", ",", "y", ",", "t"}], "]"}], "+", 
       RowBox[{
        SuperscriptBox["u", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"2", ",", "0", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"x", ",", "y", ",", "t"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "y", ",", "0"}], "]"}], "\[Equal]", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "10"}], " ", 
        SuperscriptBox["x", "2"]}]]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["u", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"1", ",", "y", ",", "t"}], "]"}], "\[Equal]", 
      FractionBox["1", 
       SuperscriptBox["\[ExponentialE]", "10"]]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "y", ",", "t"}], "]"}], "\[Equal]", 
      FractionBox["1", 
       SuperscriptBox["\[ExponentialE]", "10"]]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "1", ",", "t"}], "]"}], "\[Equal]", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "10"}], " ", 
        SuperscriptBox["x", "2"]}]]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "t"}], "]"}], "\[Equal]", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "10"}], " ", 
        SuperscriptBox["x", "2"]}]]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}]}], "]"}]], "Output",
 CellTags->"NDSolve::bcnorm",
 CellLabel->"Out[1]=",
 CellID->71059802]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::bcnorm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 11, 55.1863302}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::bcnorm", "synonyms" -> {}, "title" -> 
    "NDSolve::bcnorm", "type" -> "Message", "uri" -> "ref/message/bcnorm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1833, 71, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->239810145]},
 "NDSolve::bcnorm"->{
  Cell[2615, 101, 2224, 69, 70, "Input",
   CellTags->"NDSolve::bcnorm",
   CellID->2147],
  Cell[4842, 172, 426, 8, 70, "Message",
   CellTags->"NDSolve::bcnorm",
   CellID->568809973],
  Cell[5271, 182, 2530, 80, 70, "Output",
   CellTags->"NDSolve::bcnorm",
   CellID->71059802]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8778, 291},
 {"NDSolve::bcnorm", 8919, 295}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->8649],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 192, 5, 70, "Message",
 CellID->75194457],
Cell[1453, 56, 172, 4, 70, "Notes",
 CellID->13488],
Cell[1628, 62, 168, 4, 70, "Notes",
 CellID->6191]
}, Closed]],
Cell[CellGroupData[{
Cell[1833, 71, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->239810145],
Cell[CellGroupData[{
Cell[2218, 85, 147, 5, 70, "ExampleSection",
 CellID->75025196],
Cell[2368, 92, 222, 5, 70, "ExampleText",
 CellID->852654253],
Cell[CellGroupData[{
Cell[2615, 101, 2224, 69, 70, "Input",
 CellTags->"NDSolve::bcnorm",
 CellID->2147],
Cell[4842, 172, 426, 8, 70, "Message",
 CellTags->"NDSolve::bcnorm",
 CellID->568809973],
Cell[5271, 182, 2530, 80, 70, "Output",
 CellTags->"NDSolve::bcnorm",
 CellID->71059802]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[7840, 267, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

