(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7204,        260]
NotebookOptionsPosition[      4647,        174]
NotebookOutlinePosition[      6176,        222]
CellTagsIndexPosition[      6063,        216]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::bw", "ObjectName",
 CellID->27150],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"bw\"\>"}], ":", 
  " ", "\<\"The value of the option `1` -> `2` should be a positive integer \
or a list of two positive integers giving upper and lower \
bandwidths.\"\>"}]], "Message", "MSG",
 CellID->4257860],

Cell[TextData[{
 "Generated when the value of the ",
 StyleBox["BandWidth", "MR"],
 " option is not among the indicated forms."
}], "Notes",
 CellID->5272],

Cell["This  message applies to the BDF and IDA methods.", "Notes",
 CellID->30160]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->473884244],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->3008170],

Cell[TextData[{
 "A warning is generated in this example because ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " is not a valid value of the ",
 StyleBox["LinearSolveMethod", "MR"],
 " option."
}], "ExampleText",
 CellID->765973442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], " ", "\[Equal]", " ", 
      RowBox[{"x", "[", "t", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], " ", "\[Equal]", " ", "1"}]}], "}"}], ",",
    "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", " ", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<IDA\>\"", ",", " ", 
      RowBox[{"\"\<ImplicitSolver\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Newton\>\"", ",", " ", 
         RowBox[{"\"\<LinearSolveMethod\>\"", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<Band\>\"", ",", " ", 
            RowBox[{"\"\<BandWidth\>\"", "\[Rule]", "None"}]}], "}"}]}]}], 
        "}"}]}]}], "}"}]}]}], "]"}]], "Input",
 CellTags->"NDSolve::bw",
 CellLabel->"In[1]:=",
 CellID->635],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"bw\"\>"}], ":", 
  " ", "\<\"The value of the option \\!\\(\\\"BandWidth\\\"\\) -> \
\\!\\(NDSolve`MultistepDump`bopts\\) should be a positive integer or a list \
of two positive integers giving upper and lower bandwidths.\"\>"}]], "Message",\
 "MSG",
 CellTags->"NDSolve::bw",
 CellID->247245763],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"initf\"\>"}], ":", 
  " ", "\<\"The initialization of the method \\!\\(NDSolve`IDA\\) \
failed.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::bw",
 CellID->247413435],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "0.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::bw",
 CellLabel->"Out[1]=",
 CellID->508302302]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::bw - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 2.6083952}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::bw", "synonyms" -> {}, "title" -> "NDSolve::bw", 
    "type" -> "Message", "uri" -> "ref/message/bw"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1802, 70, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->473884244]},
 "NDSolve::bw"->{
  Cell[2662, 105, 929, 27, 70, "Input",
   CellTags->"NDSolve::bw",
   CellID->635],
  Cell[3594, 134, 353, 8, 70, "Message",
   CellTags->"NDSolve::bw",
   CellID->247245763],
  Cell[3950, 144, 224, 6, 70, "Message",
   CellTags->"NDSolve::bw",
   CellID->247413435],
  Cell[4177, 152, 404, 15, 70, "Output",
   CellTags->"NDSolve::bw",
   CellID->508302302]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5541, 196},
 {"NDSolve::bw", 5678, 200}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 49, 1, 70, "ObjectName",
 CellID->27150],
Cell[CellGroupData[{
Cell[777, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1255, 49, 267, 6, 70, "Message",
 CellID->4257860],
Cell[1525, 57, 155, 5, 70, "Notes",
 CellID->5272],
Cell[1683, 64, 82, 1, 70, "Notes",
 CellID->30160]
}, Closed]],
Cell[CellGroupData[{
Cell[1802, 70, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->473884244],
Cell[CellGroupData[{
Cell[2187, 84, 146, 5, 70, "ExampleSection",
 CellID->3008170],
Cell[2336, 91, 301, 10, 70, "ExampleText",
 CellID->765973442],
Cell[CellGroupData[{
Cell[2662, 105, 929, 27, 70, "Input",
 CellTags->"NDSolve::bw",
 CellID->635],
Cell[3594, 134, 353, 8, 70, "Message",
 CellTags->"NDSolve::bw",
 CellID->247245763],
Cell[3950, 144, 224, 6, 70, "Message",
 CellTags->"NDSolve::bw",
 CellID->247413435],
Cell[4177, 152, 404, 15, 70, "Output",
 CellTags->"NDSolve::bw",
 CellID->508302302]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4620, 172, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

