(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8496,        291]
NotebookOptionsPosition[      6123,        213]
NotebookOutlinePosition[      7591,        258]
CellTagsIndexPosition[      7475,        252]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::coend", "ObjectName",
 CellID->32628],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"coend\"\>"}], ":", 
  " ", "\<\"The endpoints of the grid coordinates `1` do not match those \
specified in `2`.\"\>"}]], "Message", "MSG",
 CellID->19724762],

Cell["\<\
Generated when explicitly specified grid coordinates are incompatible with \
the endpoints for the range of the corresponding variable.\
\>", "Notes",
 CellID->28908]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->617470672],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->257990160],

Cell[TextData[{
 "An error is generated in this example because the minimum and maximum grid  \
points specified in the value of the ",
 StyleBox["Coordinates", "MR"],
 " option are not the same as the endpoints of the range of the corresponding \
 variable."
}], "ExampleText",
 CellID->136458885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], " ", "\[Equal]", 
      " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<MethodOfLines\>\"", ",", " ", 
      RowBox[{"\"\<SpatialDiscretization\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<TensorProductGrid\>\"", ",", " ", 
         RowBox[{"\"\<Coordinates\>\"", "\[Rule]", 
          RowBox[{"Range", "[", "10", "]"}]}]}], "}"}]}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellTags->"NDSolve::coend",
 CellLabel->"In[1]:=",
 CellID->23104],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"coend\"\>"}], ":", 
  " ", "\<\"The endpoints of the grid coordinates \\!\\({1.`, 2.`, 3.`, 4.`, \
5.`, 6.`, 7.`, 8.`, 9.`, 10.`}\\) do not match those specified in \\!\\({x, \
\\(\\(-1.`\\)\\), 1.`}\\).\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::coend",
 CellID->412933961],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["u", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{
       SuperscriptBox["u", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "\[Equal]", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        SuperscriptBox["x", "2"]}]]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"MethodOfLines\"\>", ",", 
      RowBox[{"\<\"SpatialDiscretization\"\>", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\<\"TensorProductGrid\"\>", ",", 
         RowBox[{"\<\"Coordinates\"\>", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
           "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", 
            ",", "8", ",", "9", ",", "10"}], "}"}]}]}], "}"}]}]}], "}"}]}]}], 
  "]"}]], "Output",
 CellTags->"NDSolve::coend",
 CellLabel->"Out[1]=",
 CellID->169062747]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::coend - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 10.2648412}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::coend", "synonyms" -> {}, "title" -> 
    "NDSolve::coend", "type" -> "Message", "uri" -> "ref/message/coend"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1688, 65, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->617470672]},
 "NDSolve::coend"->{
  Cell[2547, 97, 1450, 44, 70, "Input",
   CellTags->"NDSolve::coend",
   CellID->23104],
  Cell[4000, 143, 335, 7, 70, "Message",
   CellTags->"NDSolve::coend",
   CellID->412933961],
  Cell[4338, 152, 1719, 54, 70, "Output",
   CellTags->"NDSolve::coend",
   CellID->169062747]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7030, 235},
 {"NDSolve::coend", 7170, 239}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->32628],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 214, 5, 70, "Message",
 CellID->19724762],
Cell[1475, 56, 176, 4, 70, "Notes",
 CellID->28908]
}, Closed]],
Cell[CellGroupData[{
Cell[1688, 65, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->617470672],
Cell[CellGroupData[{
Cell[2073, 79, 148, 5, 70, "ExampleSection",
 CellID->257990160],
Cell[2224, 86, 298, 7, 70, "ExampleText",
 CellID->136458885],
Cell[CellGroupData[{
Cell[2547, 97, 1450, 44, 70, "Input",
 CellTags->"NDSolve::coend",
 CellID->23104],
Cell[4000, 143, 335, 7, 70, "Message",
 CellTags->"NDSolve::coend",
 CellID->412933961],
Cell[4338, 152, 1719, 54, 70, "Output",
 CellTags->"NDSolve::coend",
 CellID->169062747]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6096, 211, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

