(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8142,        277]
NotebookOptionsPosition[      5775,        199]
NotebookOutlinePosition[      7241,        244]
CellTagsIndexPosition[      7125,        238]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::coexp", "ObjectName",
 CellID->8950],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"coexp\"\>"}], ":", 
  " ", "\<\"Because the coordinates were explicitly given for the direction \
of independent variable `1`, the values of options `2` will be disregarded \
for this direction.\"\>"}]], "Message", "MSG",
 CellID->38561886],

Cell["\<\
Generated when grid points are specified both directly in an explicit list \
and indirectly with values for the indicated options.\
\>", "Notes",
 CellID->3750]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->163400593],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->329000201],

Cell[TextData[{
 "A warning message is generated in this example because the grid points are  \
specified both by the value of the ",
 StyleBox["Coordinates", "MR"],
 " option and through the ",
 StyleBox["MinPoints", "MR"],
 " option."
}], "ExampleText",
 CellID->604774330],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], " ", "\[Equal]", 
      " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<MethodOfLines\>\"", ",", " ", 
      RowBox[{"\"\<SpatialDiscretization\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<TensorProductGrid\>\"", ",", " ", 
         RowBox[{"\"\<Coordinates\>\"", "\[Rule]", 
          RowBox[{"Join", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Sin", "[", 
              RowBox[{"Pi", " ", 
               RowBox[{
                RowBox[{"Range", "[", 
                 RowBox[{"0", ",", "200"}], "]"}], "/", "400"}]}], "]"}], " ",
              "-", " ", "1"}], ",", 
            RowBox[{"1", " ", "-", " ", 
             RowBox[{"Sin", "[", 
              RowBox[{"Pi", " ", 
               RowBox[{
                RowBox[{"Range", "[", 
                 RowBox[{"199", ",", "0", ",", 
                  RowBox[{"-", "1"}]}], "]"}], "/", "400"}]}], "]"}]}]}], 
           "]"}]}], " ", ",", " ", 
         RowBox[{"MinPoints", "\[Rule]", "4"}]}], "}"}]}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellTags->"NDSolve::coexp",
 CellLabel->"In[1]:=",
 CellID->7023],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"coexp\"\>"}], ":", 
  " ", "\<\"Because the coordinates were explicitly given for the direction \
of independent variable \\!\\(x\\), the values of options \
\\!\\({\\\"MaxPoints\\\", \\\"MinPoints\\\", \\\"StartingPoints\\\", \
\\\"MaxStepSize\\\", \\\"MinStepSize\\\", \\\"StartingStepSize\\\"}\\) will \
be disregarded for this direction.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::coexp",
 CellID->683621149],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.`"}], ",", "1.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "2.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::coexp",
 CellLabel->"Out[1]=",
 CellID->720442791]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::coexp - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 10.4054698}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::coexp", "synonyms" -> {}, "title" -> 
    "NDSolve::coexp", "type" -> "Message", "uri" -> "ref/message/coexp"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1763, 66, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->163400593]},
 "NDSolve::coexp"->{
  Cell[2599, 99, 2101, 61, 70, "Input",
   CellTags->"NDSolve::coexp",
   CellID->7023],
  Cell[4703, 162, 473, 9, 70, "Message",
   CellTags->"NDSolve::coexp",
   CellID->683621149],
  Cell[5179, 173, 530, 19, 70, "Output",
   CellTags->"NDSolve::coexp",
   CellID->720442791]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6682, 221},
 {"NDSolve::coexp", 6822, 225}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->8950],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 296, 6, 70, "Message",
 CellID->38561886],
Cell[1556, 57, 170, 4, 70, "Notes",
 CellID->3750]
}, Closed]],
Cell[CellGroupData[{
Cell[1763, 66, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->163400593],
Cell[CellGroupData[{
Cell[2148, 80, 148, 5, 70, "ExampleSection",
 CellID->329000201],
Cell[2299, 87, 275, 8, 70, "ExampleText",
 CellID->604774330],
Cell[CellGroupData[{
Cell[2599, 99, 2101, 61, 70, "Input",
 CellTags->"NDSolve::coexp",
 CellID->7023],
Cell[4703, 162, 473, 9, 70, "Message",
 CellTags->"NDSolve::coexp",
 CellID->683621149],
Cell[5179, 173, 530, 19, 70, "Output",
 CellTags->"NDSolve::coexp",
 CellID->720442791]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5748, 197, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

