(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8733,        284]
NotebookOptionsPosition[      5588,        194]
NotebookOutlinePosition[      7711,        251]
CellTagsIndexPosition[      7544,        244]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
NDSolve::icorddae
NDSolve`Reinitialize::icorddae\
\>", "ObjectName",
 CellID->7690],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"icorddae\"\>"}], ":", 
  " ", "\<\"For a system treated as a differential-algebraic equation, the \
differential order of the functions in the initial conditions should be equal \
or less than in the equations.\"\>"}]], "Message", "MSG",
 CellID->934436054],

Cell["\<\
Generated when an initial condition includes a derivative of higher \
differential order than that of the differential equation.\
\>", "Notes",
 CellID->24106]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->190441163],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->652183032],

Cell[TextData[{
 "An error occurs in this example because the differential order of ",
 StyleBox["y[t]", "MR"],
 " in the initial conditions is higher than the differential order of ",
 StyleBox["y[t]", "MR"],
 " in the differential equation."
}], "ExampleText",
 CellID->634495285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], "+", " ", 
       RowBox[{"y", "[", "t", "]"}]}], " ", "\[Equal]", " ", "0"}], ",", " ", 
     
     RowBox[{
      RowBox[{"y", "[", "t", "]"}], " ", "\[Equal]", " ", 
      RowBox[{"x", "[", "t", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], " ", "\[Equal]", " ", "1"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], " ", "\[Equal]", " ", "0"}], ",", 
     " ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "''"}], "[", "0", "]"}], " ", "\[Equal]", " ", "0"}], ",",
      " ", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], " ", "\[Equal]", " ", "0"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "''"}], "[", "0", "]"}], " ", "\[Equal]", " ", "0"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"},
 CellLabel->"In[1]:=",
 CellID->19385],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"icorddae\"\>"}], ":", 
  " ", "\<\"For a system treated as a differential-algebraic equation, the \
differential order of the functions in the initial conditions should be equal \
or less than in the equations.\"\>"}]], "Message", "MSG",
 CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"},
 CellID->284557060],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "t", "]"}], "+", 
       RowBox[{
        SuperscriptBox["x", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", "0"}], ",", 
     
     RowBox[{
      RowBox[{"y", "[", "t", "]"}], "\[Equal]", 
      RowBox[{"x", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "\[Prime]",
        MultilineFunction->None], "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Output",
 CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"},
 CellLabel->"Out[1]=",
 CellID->30325710]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::icorddae - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 27.0308954}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::icorddae NDSolve`Reinitialize::icorddae", 
    "synonyms" -> {}, "title" -> "NDSolve::icorddae", "type" -> "Message", 
    "uri" -> "ref/message/icorddae"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1842, 70, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->190441163]},
 "NDSolve::icorddae"->{
  Cell[2685, 102, 1179, 36, 70, "Input",
   CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"},
   CellID->19385],
  Cell[3867, 140, 381, 7, 70, "Message",
   CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"},
   CellID->284557060],
  Cell[4251, 149, 1271, 38, 70, "Output",
   CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"},
   CellID->30325710]},
 "NDSolve`Reinitialize::icorddae"->{
  Cell[2685, 102, 1179, 36, 70, "Input",
   CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"},
   CellID->19385],
  Cell[3867, 140, 381, 7, 70, "Message",
   CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"},
   CellID->284557060],
  Cell[4251, 149, 1271, 38, 70, "Output",
   CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"},
   CellID->30325710]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6543, 217},
 {"NDSolve::icorddae", 6686, 221},
 {"NDSolve`Reinitialize::icorddae", 7122, 231}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 93, 4, 70, "ObjectName",
 CellID->7690],
Cell[CellGroupData[{
Cell[821, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1299, 52, 334, 7, 70, "Message",
 CellID->934436054],
Cell[1636, 61, 169, 4, 70, "Notes",
 CellID->24106]
}, Closed]],
Cell[CellGroupData[{
Cell[1842, 70, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->190441163],
Cell[CellGroupData[{
Cell[2227, 84, 148, 5, 70, "ExampleSection",
 CellID->652183032],
Cell[2378, 91, 282, 7, 70, "ExampleText",
 CellID->634495285],
Cell[CellGroupData[{
Cell[2685, 102, 1179, 36, 70, "Input",
 CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"},
 CellID->19385],
Cell[3867, 140, 381, 7, 70, "Message",
 CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"},
 CellID->284557060],
Cell[4251, 149, 1271, 38, 70, "Output",
 CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"},
 CellID->30325710]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5561, 192, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

