(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8828,        290]
NotebookOptionsPosition[      5389,        191]
NotebookOutlinePosition[      7704,        254]
CellTagsIndexPosition[      7543,        247]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
NDSolve::ivcon
NDSolve`Reinitialize::ivcon\
\>", "ObjectName",
 CellID->2894],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"ivcon\"\>"}], ":", 
  " ", "\<\"The given initial conditions were not consistent with the \
differential-algebraic equations.  NDSolve will attempt to correct the \
values.\"\>"}]], "Message", "MSG",
 CellID->424987186],

Cell["\<\
This message can be generated when the initial conditions are inconsistent \
with each other or when there are more initial conditions than necessary to \
specify a solution.\
\>", "Notes",
 CellID->24697]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->76581659],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->241491547],

Cell["\<\
A warning message is generated in this example because some of the initial \
conditions are unnecessary.\
\>", "ExampleText",
 CellID->23511448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], "+", " ", 
       RowBox[{"y", "[", "t", "]"}]}], " ", "\[Equal]", " ", "0"}], ",", " ", 
     
     RowBox[{
      RowBox[{"y", "[", "t", "]"}], " ", "\[Equal]", " ", 
      RowBox[{"x", "[", "t", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], " ", "\[Equal]", " ", "1"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], " ", "\[Equal]", " ", "0"}], ",", 
     " ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "''"}], "[", "0", "]"}], " ", "\[Equal]", " ", "0"}], ",",
      " ", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], " ", "\[Equal]", " ", "0"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], " ", "\[Equal]", " ", "0"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"},
 CellLabel->"In[1]:=",
 CellID->28891],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ivcon\"\>"}], ":", 
  " ", "\<\"The given initial conditions were not consistent with the \
differential-algebraic equations.  NDSolve will attempt to correct the \
values.\"\>"}]], "Message", "MSG",
 CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"},
 CellID->814246879],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ivres\"\>"}], ":", 
  " ", "\<\"NDSolve has computed initial values that give a zero residual for \
the differential-algebraic system, but some components are different from \
those specified.  If you need those to be satisfied, it is recommended that \
you give initial conditions for all dependent variables and derivatives of \
them.\"\>"}]], "Message", "MSG",
 CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"},
 CellID->446088776],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], ",", 
    RowBox[{"y", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}]}], "}"}], "}"}]], "Output",
 CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"},
 CellLabel->"Out[1]=",
 CellID->336165234]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::ivcon - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 34.2810810}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::ivcon NDSolve`Reinitialize::ivcon", 
    "synonyms" -> {}, "title" -> "NDSolve::ivcon", "type" -> "Message", "uri" -> 
    "ref/message/ivcon"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1844, 71, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->76581659]},
 "NDSolve::ivcon"->{
  Cell[2558, 100, 1172, 36, 70, "Input",
   CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"},
   CellID->28891],
  Cell[3733, 138, 337, 7, 70, "Message",
   CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"},
   CellID->814246879],
  Cell[4073, 147, 501, 9, 70, "Message",
   CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"},
   CellID->446088776],
  Cell[4577, 158, 746, 26, 70, "Output",
   CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"},
   CellID->336165234]},
 "NDSolve`Reinitialize::ivcon"->{
  Cell[2558, 100, 1172, 36, 70, "Input",
   CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"},
   CellID->28891],
  Cell[3733, 138, 337, 7, 70, "Message",
   CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"},
   CellID->814246879],
  Cell[4073, 147, 501, 9, 70, "Message",
   CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"},
   CellID->446088776],
  Cell[4577, 158, 746, 26, 70, "Output",
   CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"},
   CellID->336165234]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6329, 214},
 {"NDSolve::ivcon", 6468, 218},
 {"NDSolve`Reinitialize::ivcon", 7011, 231}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 87, 4, 70, "ObjectName",
 CellID->2894],
Cell[CellGroupData[{
Cell[815, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1293, 52, 296, 7, 70, "Message",
 CellID->424987186],
Cell[1592, 61, 215, 5, 70, "Notes",
 CellID->24697]
}, Closed]],
Cell[CellGroupData[{
Cell[1844, 71, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->76581659],
Cell[CellGroupData[{
Cell[2228, 85, 148, 5, 70, "ExampleSection",
 CellID->241491547],
Cell[2379, 92, 154, 4, 70, "ExampleText",
 CellID->23511448],
Cell[CellGroupData[{
Cell[2558, 100, 1172, 36, 70, "Input",
 CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"},
 CellID->28891],
Cell[3733, 138, 337, 7, 70, "Message",
 CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"},
 CellID->814246879],
Cell[4073, 147, 501, 9, 70, "Message",
 CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"},
 CellID->446088776],
Cell[4577, 158, 746, 26, 70, "Output",
 CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"},
 CellID->336165234]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5362, 189, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

