(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7106,        254]
NotebookOptionsPosition[      4740,        176]
NotebookOutlinePosition[      6205,        221]
CellTagsIndexPosition[      6089,        215]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::ivdae", "ObjectName",
 CellID->16452],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ivdae\"\>"}], ":", 
  " ", "\<\"For differential-algebraic equations, initial conditions need to \
be given for either all the non-algebraic variables or their \
derivatives.\"\>"}]], "Message", "MSG",
 CellID->27544705],

Cell[TextData[{
 "Generated by difficulty handling algebraic equations  in the input to ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->2109]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->532811064],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->450196478],

Cell[TextData[{
 "An error occurs in this example because there is only one initial condition \
 for ",
 StyleBox["x[t]", "MR"],
 "."
}], "ExampleText",
 CellID->264267696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", " ", 
       RowBox[{"y", "[", "t", "]"}]}], " ", "==", " ", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "t", "]"}], " ", "\[Equal]", " ", 
      RowBox[{"x", "[", "t", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], " ", "\[Equal]", " ", "0"}], ",", " ", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], " ", "\[Equal]", " ", "1"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], " ", "\[Equal]", " ", "0"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::ivdae",
 CellLabel->"In[1]:=",
 CellID->176],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ivdae\"\>"}], ":", 
  " ", "\<\"For differential-algebraic equations, initial conditions need to \
be given for either all the non-algebraic variables or their \
derivatives.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::ivdae",
 CellID->126086747],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "t", "]"}], "+", 
       RowBox[{
        SuperscriptBox["x", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", "0"}], ",", 
     
     RowBox[{
      RowBox[{"y", "[", "t", "]"}], "\[Equal]", 
      RowBox[{"x", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Output",
 CellTags->"NDSolve::ivdae",
 CellLabel->"Out[1]=",
 CellID->338398427]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::ivdae - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 34.4060842}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::ivdae", "synonyms" -> {}, "title" -> 
    "NDSolve::ivdae", "type" -> "Message", "uri" -> "ref/message/ivdae"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1814, 70, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->532811064]},
 "NDSolve::ivdae"->{
  Cell[2547, 101, 886, 27, 70, "Input",
   CellTags->"NDSolve::ivdae",
   CellID->176],
  Cell[3436, 130, 306, 7, 70, "Message",
   CellTags->"NDSolve::ivdae",
   CellID->126086747],
  Cell[3745, 139, 929, 30, 70, "Output",
   CellTags->"NDSolve::ivdae",
   CellID->338398427]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5647, 198},
 {"NDSolve::ivdae", 5787, 202}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->16452],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 276, 6, 70, "Message",
 CellID->27544705],
Cell[1537, 57, 240, 8, 70, "Notes",
 CellID->2109]
}, Closed]],
Cell[CellGroupData[{
Cell[1814, 70, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->532811064],
Cell[CellGroupData[{
Cell[2199, 84, 148, 5, 70, "ExampleSection",
 CellID->450196478],
Cell[2350, 91, 172, 6, 70, "ExampleText",
 CellID->264267696],
Cell[CellGroupData[{
Cell[2547, 101, 886, 27, 70, "Input",
 CellTags->"NDSolve::ivdae",
 CellID->176],
Cell[3436, 130, 306, 7, 70, "Message",
 CellTags->"NDSolve::ivdae",
 CellID->126086747],
Cell[3745, 139, 929, 30, 70, "Output",
 CellTags->"NDSolve::ivdae",
 CellID->338398427]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4713, 174, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

