(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9624,        337]
NotebookOptionsPosition[      6749,        241]
NotebookOutlinePosition[      8399,        292]
CellTagsIndexPosition[      8283,        286]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::ivone", "ObjectName",
 CellID->30699],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ivone\"\>"}], ":", 
  " ", "\<\"Boundary values may only be specified for one independent \
variable. Initial values may only be specified at one value of the other \
independent variable.\"\>"}]], "Message", "MSG",
 CellID->460896177],

Cell["\<\
Generated when the initial values and boundary   conditions for a partial \
differential equation specify values on all sides of   the solution region.\
\>", "Notes",
 CellID->20637],

Cell[TextData[{
 "The partial differential equation   solver used by ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " is designed to solve initial value problems."
}], "Notes",
 CellID->25491]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1641523],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->11606844],

Cell["\<\
This input generates a message because the equations specify values for the \
solution on all sides of the solution region.\
\>", "ExampleText",
 CellID->658952195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Derivative", "[", 
          RowBox[{"2", ",", "0"}], "]"}], "[", "f", "]"}], "[", 
        RowBox[{"x", ",", "t"}], "]"}], "==", 
       RowBox[{
        RowBox[{
         RowBox[{"Derivative", "[", 
          RowBox[{"0", ",", "2"}], "]"}], "[", "f", "]"}], "[", 
        RowBox[{"x", ",", "t"}], "]"}]}], ",", "\n", "\t\t", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"1", ",", "t"}], "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "0"}], "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"0", ",", "t"}], "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "4"}], "]"}], "==", "0"}]}], "}"}], ",", "f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "4"}], "}"}]}], "]"}], ";"}]], "Input",
 CellTags->"NDSolve::ivone",
 CellLabel->"In[1]:=",
 CellID->30030],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ivone\"\>"}], ":", 
  " ", "\<\"Boundary values may only be specified for one independent \
variable. Initial values may only be specified at one value of the other \
independent variable.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::ivone",
 CellID->61032114]
}, Open  ]],

Cell["\<\
An error is generated in this example because there is no specification for \
the initial values of the solution.\
\>", "ExampleText",
 CellID->248144447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"2", ",", "0"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "==", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "2"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", "\n", "\t\t", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"0", ",", "t"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"1", ",", "t"}], "]"}], "==", "0"}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"NDSolve::ivone",
 CellLabel->"In[2]:=",
 CellID->25860],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ivone\"\>"}], ":", 
  " ", "\<\"Boundary values may only be specified for one independent \
variable. Initial values may only be specified at one value of the other \
independent variable.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::ivone",
 CellID->318386653],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"0", ",", "t"}], "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"1", ",", "t"}], "]"}], "\[Equal]", "0"}]}], "}"}], ",", "f", 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Output",
 CellTags->"NDSolve::ivone",
 CellLabel->"Out[2]=",
 CellID->22988389]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::ivone - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 34.5467128}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::ivone", "synonyms" -> {}, "title" -> 
    "NDSolve::ivone", "type" -> "Message", "uri" -> "ref/message/ivone"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2050, 76, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1641523]},
 "NDSolve::ivone"->{
  Cell[2782, 105, 1137, 35, 70, "Input",
   CellTags->"NDSolve::ivone",
   CellID->30030],
  Cell[3922, 142, 319, 7, 70, "Message",
   CellTags->"NDSolve::ivone",
   CellID->61032114],
  Cell[4445, 160, 895, 28, 70, "Input",
   CellTags->"NDSolve::ivone",
   CellID->25860],
  Cell[5343, 190, 320, 7, 70, "Message",
   CellTags->"NDSolve::ivone",
   CellID->318386653],
  Cell[5666, 199, 1017, 35, 70, "Output",
   CellTags->"NDSolve::ivone",
   CellID->22988389]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7656, 263},
 {"NDSolve::ivone", 7794, 267}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->30699],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 291, 6, 70, "Message",
 CellID->460896177],
Cell[1552, 57, 192, 4, 70, "Notes",
 CellID->20637],
Cell[1747, 63, 266, 8, 70, "Notes",
 CellID->25491]
}, Closed]],
Cell[CellGroupData[{
Cell[2050, 76, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1641523],
Cell[CellGroupData[{
Cell[2433, 90, 147, 5, 70, "ExampleSection",
 CellID->11606844],
Cell[2583, 97, 174, 4, 70, "ExampleText",
 CellID->658952195],
Cell[CellGroupData[{
Cell[2782, 105, 1137, 35, 70, "Input",
 CellTags->"NDSolve::ivone",
 CellID->30030],
Cell[3922, 142, 319, 7, 70, "Message",
 CellTags->"NDSolve::ivone",
 CellID->61032114]
}, Open  ]],
Cell[4256, 152, 164, 4, 70, "ExampleText",
 CellID->248144447],
Cell[CellGroupData[{
Cell[4445, 160, 895, 28, 70, "Input",
 CellTags->"NDSolve::ivone",
 CellID->25860],
Cell[5343, 190, 320, 7, 70, "Message",
 CellTags->"NDSolve::ivone",
 CellID->318386653],
Cell[5666, 199, 1017, 35, 70, "Output",
 CellTags->"NDSolve::ivone",
 CellID->22988389]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6722, 239, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

