(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6930,        248]
NotebookOptionsPosition[      4574,        170]
NotebookOutlinePosition[      6030,        215]
CellTagsIndexPosition[      5915,        209]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["NDSolve::jpde", "ObjectName",
 CellID->23251],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"jpde\"\>"}], ":", 
  " ", "\<\"For PDEs, the Jacobian will be computed using finite differences \
unless you have chosen the MethodOfLines option ExpandEquationsSymbolically \
-> True.\"\>"}]], "Message", "MSG",
 CellID->247303550],

Cell["\<\
Generated by an inconsistent specification of whether the Jacobian should be \
computed symbolically or numerically.\
\>", "Notes",
 CellID->18611]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->107294211],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->316576300],

Cell[TextData[{
 "A warning message is generated in this example because the specified value  \
of the ",
 Cell[BoxData["Jacobian"], "InlineFormula"],
 " option will not be used."
}], "ExampleText",
 CellID->709938380],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], " ", "\[Equal]", 
      " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "0"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "100"}], " ", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "t"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "t"}], "]"}]}]}], "}"}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"Jacobian", "->", "\"\<Symbolic\>\""}]}], "]"}]], "Input",
 CellTags->"NDSolve::jpde",
 CellLabel->"In[1]:=",
 CellID->11225],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"jpde\"\>"}], ":", 
  " ", "\<\"For PDEs, the Jacobian will be computed using finite differences \
unless you have chosen the MethodOfLines option ExpandEquationsSymbolically \
-> True.\"\>"}]], "Message", "MSG",
 CellTags->"NDSolve::jpde",
 CellID->38354003],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.`"}], ",", "1.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "2.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->"NDSolve::jpde",
 CellLabel->"Out[1]=",
 CellID->70858261]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve::jpde - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 12, 34.7029668}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "NDSolve::jpde", "synonyms" -> {}, "title" -> 
    "NDSolve::jpde", "type" -> "Message", "uri" -> "ref/message/jpde"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1741, 66, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->107294211]},
 "NDSolve::jpde"->{
  Cell[2520, 97, 1140, 36, 70, "Input",
   CellTags->"NDSolve::jpde",
   CellID->11225],
  Cell[3663, 135, 314, 7, 70, "Message",
   CellTags->"NDSolve::jpde",
   CellID->38354003],
  Cell[3980, 144, 528, 19, 70, "Output",
   CellTags->"NDSolve::jpde",
   CellID->70858261]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5477, 192},
 {"NDSolve::jpde", 5616, 196}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->23251],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 287, 6, 70, "Message",
 CellID->247303550],
Cell[1547, 57, 157, 4, 70, "Notes",
 CellID->18611]
}, Closed]],
Cell[CellGroupData[{
Cell[1741, 66, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->107294211],
Cell[CellGroupData[{
Cell[2126, 80, 148, 5, 70, "ExampleSection",
 CellID->316576300],
Cell[2277, 87, 218, 6, 70, "ExampleText",
 CellID->709938380],
Cell[CellGroupData[{
Cell[2520, 97, 1140, 36, 70, "Input",
 CellTags->"NDSolve::jpde",
 CellID->11225],
Cell[3663, 135, 314, 7, 70, "Message",
 CellTags->"NDSolve::jpde",
 CellID->38354003],
Cell[3980, 144, 528, 19, 70, "Output",
 CellTags->"NDSolve::jpde",
 CellID->70858261]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4547, 168, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

